/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.upstream;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.registry.ModTiles;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class AirUpstreamTile
extends BlockEntity
implements ITickable {
    public AirUpstreamTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.AIR_UPSTREAM_TILE.get(), pPos, pBlockState);
    }

    public void tick() {
        ServerLevel serverLevel;
        Level level = this.level;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getGameTime() % 20L == 0L) {
            ISpecialSourceProvider source;
            if (serverLevel.getBlockState(this.getBlockPos().above()) == this.getBlockState()) {
                return;
            }
            int power = 1;
            while (serverLevel.getBlockState(this.getBlockPos().below(power)) == this.getBlockState()) {
                ++power;
            }
            List entityList = serverLevel.getEntitiesOfClass(LivingEntity.class, new AABB(this.getBlockPos().getCenter(), this.getBlockPos().above(46 * power).getCenter()).inflate(1.1), e -> !e.isSpectator() && !e.isInWater() && !e.isInLava());
            if (!(entityList.isEmpty() || !this.requiresSource() || (source = SourceUtil.takeSourceWithParticles((BlockPos)this.getBlockPos(), (Level)serverLevel, (int)10, (int)(power * (Integer)ConfigHandler.Common.AIR_ELEVATOR_COST.get()))) != null && source.isValid())) {
                return;
            }
            for (LivingEntity e2 : entityList) {
                e2.resetFallDistance();
                e2.addEffect(new MobEffectInstance(e2.isCrouching() ? MobEffects.SLOW_FALLING : MobEffects.LEVITATION, 25, 1, false, false, false));
                e2.hurtMarked = true;
            }
        }
    }

    private boolean requiresSource() {
        return (Integer)ConfigHandler.Common.AIR_ELEVATOR_COST.get() > 0;
    }
}

