/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.prism;

import alexthw.ars_elemental.registry.ModTiles;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AdvancedPrismTile
extends ModdedTile
implements IWandable,
GeoBlockEntity {
    private static final String TAG_LENTS = "prismLent";
    private static final String TAG_ROTATION_X = "rotationX";
    private static final String TAG_ROTATION_Y = "rotationY";
    public float rotationX;
    public float rotationY;
    private ItemStack prismLens;
    final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AdvancedPrismTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public AdvancedPrismTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.ADVANCED_PRISM.get(), pos, state);
    }

    public void aim(@Nullable BlockPos blockPos, Player playerEntity) {
        if (blockPos == null) {
            return;
        }
        Vec3 thisVec = Vec3.atCenterOf((Vec3i)this.getBlockPos());
        Vec3 blockVec = Vec3.atCenterOf((Vec3i)blockPos);
        Vec3 diffVec = blockVec.subtract(thisVec);
        Vec3 diffVec2D = new Vec3(diffVec.x, diffVec.z, 0.0);
        Vec3 rotVec = new Vec3(0.0, 1.0, 0.0);
        double angle = AdvancedPrismTile.angleBetween(rotVec, diffVec2D) / Math.PI * 180.0;
        if (blockVec.x < thisVec.x) {
            angle = -angle;
        }
        this.setRotX((float)angle + 90.0f);
        rotVec = new Vec3(diffVec.x, 0.0, diffVec.z);
        angle = AdvancedPrismTile.angleBetween(diffVec, rotVec) * 180.0 / Math.PI;
        if (blockVec.y < thisVec.y) {
            angle = -angle;
        }
        this.setRotY((float)angle);
        this.updateBlock();
        ParticleUtil.beam((BlockPos)blockPos, (BlockPos)this.getBlockPos(), (Level)this.level);
        PortUtil.sendMessageNoSpam((Entity)playerEntity, (Component)Component.literal((String)("Prism now aims to " + blockPos.toShortString())));
    }

    public static double angleBetween(Vec3 a, Vec3 b) {
        double projection = a.normalize().dot(b.normalize());
        return Math.acos(Mth.clamp((double)projection, (double)-1.0, (double)1.0));
    }

    public void onWanded(Player playerEntity) {
        if (this.prismLens != null) {
            playerEntity.level().addFreshEntity((Entity)new ItemEntity(playerEntity.level(), (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), this.prismLens));
            this.prismLens = ItemStack.EMPTY;
        }
        this.updateBlock();
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null) {
            this.aim(storedPos, playerEntity);
        }
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putFloat(TAG_ROTATION_Y, this.rotationY);
        tag.putFloat(TAG_ROTATION_X, this.rotationX);
        if (this.prismLens != null) {
            tag.put(TAG_LENTS, this.prismLens.save(pRegistries));
        }
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.rotationX = tag.getFloat(TAG_ROTATION_X);
        this.rotationY = tag.getFloat(TAG_ROTATION_Y);
        if (tag.contains(TAG_LENTS)) {
            this.prismLens = ItemStack.parse((HolderLookup.Provider)pRegistries, (Tag)tag.getCompound(TAG_LENTS)).orElse(ItemStack.EMPTY);
        }
    }

    public float getRotationX() {
        return this.rotationX;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    public void setRotX(float rot) {
        this.rotationX = rot;
    }

    public void setRotY(float rot) {
        this.rotationY = rot;
    }

    public Vec3 getShootAngle() {
        float f = this.getRotationY() * ((float)Math.PI / 180);
        float f1 = (90.0f + this.getRotationX()) * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f1);
        float f3 = Mth.sin((float)f1);
        float f4 = Mth.cos((float)f);
        float f5 = Mth.sin((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4)).reverse();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public ItemStack getLens() {
        return this.prismLens == null ? ItemStack.EMPTY : this.prismLens;
    }

    void setLens(ItemStack lent, Player pPlayer) {
        this.onWanded(pPlayer);
        this.prismLens = lent;
        this.updateBlock();
    }
}

