/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.client.utils.FeedthroughManualData;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.Shapes;

public class FeedthroughMultiblock
implements MultiblockHandler.IMultiblock {
    public static FeedthroughMultiblock instance = new FeedthroughMultiblock();
    static List<StructureTemplate.StructureBlockInfo> structure = new ArrayList<StructureTemplate.StructureBlockInfo>();

    public static Block getDemoConnector() {
        return IEBlocks.Connectors.getEnergyConnector("LV", false).get();
    }

    @Override
    public Vec3i getSize(@Nullable Level world) {
        return new Vec3i(3, 1, 1);
    }

    @Override
    public void disassemble(Level world, BlockPos startPos, boolean mirrored, Direction clickDirectionAtCreation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockPos getTriggerOffset() {
        return new BlockPos(-1, 0, 0);
    }

    @Override
    public void initializeClient(Consumer<ClientMultiblocks.MultiblockManualData> consumer) {
        consumer.accept(new FeedthroughManualData());
    }

    @Override
    public float getManualScale() {
        return 12.0f;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return IEApi.ieLoc("feedthrough");
    }

    @Override
    public boolean isBlockTrigger(BlockState state, Direction side, @Nullable Level world) {
        return WireApi.getWireType(state) != null;
    }

    @Nullable
    WireType checkValidConnector(Level w, BlockPos pos, GlobalWireNetwork globalNet, Direction expectedDirection) {
        LocalWireNetwork localNet = globalNet.getNullableLocalNet(pos);
        if (localNet == null) {
            return null;
        }
        ImmutableSet connsHere = localNet.getConnections(pos);
        IImmersiveConnectable connHere = localNet.getConnector(pos);
        if (connsHere == null) {
            connsHere = ImmutableSet.of();
        }
        if (connsHere.size() > 1 || connHere.getConnectionPoints().size() != 1) {
            return null;
        }
        BlockState state = w.getBlockState(pos);
        if (!state.hasProperty((Property)IEProperties.FACING_ALL) || state.getValue((Property)IEProperties.FACING_ALL) != expectedDirection) {
            return null;
        }
        return WireApi.getWireType(state);
    }

    @Override
    public boolean createStructure(Level world, BlockPos pos, Direction side, Player player) {
        ConnectionPoint cpOther;
        WireType wire;
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(world);
        BlockState stateHere = world.getBlockState(pos);
        if (stateHere.hasProperty((Property)IEProperties.FACING_ALL)) {
            side = (Direction)stateHere.getValue((Property)IEProperties.FACING_ALL);
        }
        if ((wire = this.checkValidConnector(world, pos, globalNet, side)) == null) {
            return false;
        }
        BlockPos middlePos = pos.relative(side);
        BlockState middle = world.getBlockState(middlePos);
        if (!middle.getShape((BlockGetter)world, pos).equals(Shapes.block()) || middle.getBlock() instanceof EntityBlock || middle.getRenderShape() != RenderShape.MODEL) {
            return false;
        }
        BlockPos otherPos = pos.relative(side, 2);
        WireType otherWire = this.checkValidConnector(world, otherPos, globalNet, side.getOpposite());
        if (otherWire != wire) {
            return false;
        }
        LocalWireNetwork localHere = globalNet.getLocalNet(pos);
        ConnectionPoint cpHere = localHere.getConnector(pos).getConnectionPoints().iterator().next();
        Collection<Connection> connsHere = localHere.getConnections(cpHere);
        LocalWireNetwork localOther = globalNet.getLocalNet(otherPos);
        Collection<Connection> connsOther = localOther.getConnections(cpOther = localOther.getConnector(otherPos).getConnectionPoints().iterator().next());
        if (connsOther.stream().anyMatch(c -> c.isEnd(cpHere))) {
            return false;
        }
        for (Connection c3 : connsOther) {
            ConnectionPoint otherEnd = c3.getOtherEnd(cpOther);
            if (!connsHere.stream().anyMatch(c2 -> c2.isEnd(otherEnd))) continue;
            return false;
        }
        if (!world.isClientSide) {
            BlockState state = (BlockState)IEBlocks.Connectors.FEEDTHROUGH.defaultBlockState().setValue((Property)IEProperties.FACING_ALL, (Comparable)side);
            BlockPos masterPos = pos.relative(side);
            FeedthroughBlockEntity master = this.setBlock(world, masterPos, state, wire, middle, 0);
            if (master != null) {
                this.moveConnectionsToMaster(connsOther, cpOther, world, master.getPositivePoint());
                this.moveConnectionsToMaster(connsHere, cpHere, world, master.getNegativePoint());
            }
            this.setBlock(world, pos, state, wire, middle, -1);
            this.setBlock(world, pos.relative(side, 2), state, wire, middle, 1);
        }
        return true;
    }

    @Override
    public List<StructureTemplate.StructureBlockInfo> getStructure(@Nullable Level world) {
        if (structure.isEmpty()) {
            structure.add(new StructureTemplate.StructureBlockInfo(BlockPos.ZERO, (BlockState)FeedthroughMultiblock.getDemoConnector().defaultBlockState().setValue((Property)IEProperties.FACING_ALL, (Comparable)Direction.EAST), null));
            structure.add(new StructureTemplate.StructureBlockInfo(new BlockPos(1, 0, 0), Blocks.BOOKSHELF.defaultBlockState(), null));
            structure.add(new StructureTemplate.StructureBlockInfo(new BlockPos(2, 0, 0), (BlockState)FeedthroughMultiblock.getDemoConnector().defaultBlockState().setValue((Property)IEProperties.FACING_ALL, (Comparable)Direction.WEST), null));
        }
        return structure;
    }

    private void moveConnectionsToMaster(Collection<Connection> conns, ConnectionPoint oldCommon, Level world, ConnectionPoint newCommon) {
        for (Connection c : ImmutableSet.copyOf(conns)) {
            WireUtils.moveConnectionEnd(c, oldCommon, newCommon, world);
        }
    }

    @Nullable
    private FeedthroughBlockEntity setBlock(Level world, BlockPos here, BlockState newState, WireType wire, BlockState middle, int offset) {
        world.setBlockAndUpdate(here, newState);
        BlockEntity te = world.getBlockEntity(here);
        if (te instanceof FeedthroughBlockEntity) {
            FeedthroughBlockEntity feedthrough = (FeedthroughBlockEntity)te;
            feedthrough.reference = wire;
            feedthrough.stateForMiddle = middle;
            feedthrough.offset = offset;
            world.blockEvent(here, feedthrough.getBlockState().getBlock(), 253, 0);
            return feedthrough;
        }
        return null;
    }

    @Override
    public Component getDisplayName() {
        return IEBlocks.Connectors.FEEDTHROUGH.get().getName();
    }
}

