/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseItem;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerStandingBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ShaderItem
extends IEBaseItem
implements IShaderItem,
IEItemInterfaces.IColouredItem {
    private final ResourceLocation shaderName;

    public ShaderItem(ResourceLocation shaderName, Rarity rarity) {
        super(new Item.Properties().stacksTo(1).rarity(rarity));
        this.shaderName = shaderName;
    }

    @Override
    public ResourceLocation getShaderName() {
        return this.shaderName;
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        ResourceLocation name = this.getShaderName();
        if (ShaderRegistry.shaderRegistry.containsKey(name)) {
            BlockState blockState = world.getBlockState(pos);
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile instanceof BannerBlockEntity) {
                ShaderCase sCase = ShaderRegistry.shaderRegistry.get(name).getCase(IEApi.ieLoc("banner"));
                if (sCase != null) {
                    boolean wall = blockState.getBlock() instanceof WallBannerBlock;
                    if (wall) {
                        world.setBlockAndUpdate(pos, (BlockState)IEBlocks.Cloth.SHADER_BANNER_WALL.defaultBlockState().setValue(ShaderBannerWallBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)WallBannerBlock.FACING))));
                    } else {
                        world.setBlockAndUpdate(pos, (BlockState)IEBlocks.Cloth.SHADER_BANNER.defaultBlockState().setValue((Property)ShaderBannerStandingBlock.ROTATION, (Comparable)((Integer)blockState.getValue((Property)BannerBlock.ROTATION))));
                    }
                    tile = world.getBlockEntity(pos);
                    if (tile instanceof ShaderBannerBlockEntity) {
                        ShaderBannerBlockEntity shaderBanner = (ShaderBannerBlockEntity)tile;
                        shaderBanner.shader.setShader(this.shaderName);
                        tile.setChanged();
                        return InteractionResult.SUCCESS;
                    }
                }
            } else if (tile instanceof ShaderBannerBlockEntity) {
                ShaderBannerBlockEntity shaderBanner = (ShaderBannerBlockEntity)tile;
                shaderBanner.shader.setShader(this.shaderName);
                tile.setChanged();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        Rarity rarity = stack.getRarity();
        String rarityKey = rarity.name().toLowerCase(Locale.US);
        String rarityName = Arrays.stream(rarityKey.split("_")).map(Utils::toCamelCase).collect(Collectors.joining(" "));
        list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.shader.level").withStyle(ChatFormatting.GRAY).append((Component)Component.translatableWithFallback((String)("desc.immersiveengineering.info.shader.rarity." + rarityName), (String)rarityName).withStyle(rarity.getStyleModifier())));
        if (!Screen.hasShiftDown()) {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.shader.applyTo").append(" ").append((Component)Component.translatable((String)"desc.immersiveengineering.info.holdShift")).withStyle(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.shader.applyTo").withStyle(ChatFormatting.GRAY));
            ResourceLocation rl = this.getShaderName();
            if (rl != null) {
                List<ShaderCase> array = ShaderRegistry.shaderRegistry.get(rl).getCases();
                for (ShaderCase sCase : array) {
                    if (sCase instanceof ShaderCaseItem) continue;
                    list.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)("desc.immersiveengineering.info.shader." + String.valueOf(sCase.getShaderType()))), ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        MutableComponent itc = super.getName(stack).copy();
        itc.append(": ").append(ShaderItem.getShaderName(this.shaderName));
        return itc;
    }

    public String getDescriptionId() {
        return "item.immersiveengineering.shader";
    }

    public static Component getShaderName(ResourceLocation shader) {
        return Component.translatable((String)ShaderItem.getShaderNameKey(shader));
    }

    public static String getShaderNameKey(ResourceLocation shader) {
        return "item." + shader.getNamespace() + ".shader.name." + shader.getPath();
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        ShaderCase sCase;
        ResourceLocation name = this.getShaderName();
        if (ShaderRegistry.shaderRegistry.containsKey(name) && (sCase = ShaderRegistry.shaderRegistry.get(name).getCase(IEApi.ieLoc("item"))) != null) {
            ShaderLayer[] layers = sCase.getLayers();
            if (pass < layers.length && layers[pass] != null) {
                return layers[pass].getColor().toInt();
            }
            return -1;
        }
        return -1;
    }
}

