/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.localhandlers;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.utils.BinaryHeap;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMaps;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EnergyTransferHandler
extends LocalNetworkHandler
implements IWorldTickable {
    public static final ResourceLocation ID = IEApi.ieLoc("energy_transfer");
    private final Map<ConnectionPoint, Map<ConnectionPoint, Path>> energyPaths = new HashMap<ConnectionPoint, Map<ConnectionPoint, Path>>();
    private Object2DoubleOpenHashMap<Connection> transferredNextTick = new Object2DoubleOpenHashMap();
    private Object2DoubleMap<Connection> transferredLastTick = new Object2DoubleOpenHashMap();
    private final Map<ConnectionPoint, EnergyConnector> sources = new HashMap<ConnectionPoint, EnergyConnector>();
    private final Map<ConnectionPoint, EnergyConnector> sinks = new HashMap<ConnectionPoint, EnergyConnector>();
    private final List<SinkPathsFromSource> transferPaths = new ArrayList<SinkPathsFromSource>();
    private boolean sourceSinkMapInitialized = true;
    HashMap<Connection, List<Double>> limits = new HashMap();

    public EnergyTransferHandler(LocalWireNetwork net, GlobalWireNetwork global) {
        super(net, global);
    }

    @Override
    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        this.reset();
        return this;
    }

    @Override
    public void onConnectorLoaded(ConnectionPoint p, IImmersiveConnectable iic) {
        this.reset();
    }

    @Override
    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
        this.reset();
    }

    @Override
    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
        this.reset();
    }

    @Override
    public void onConnectionAdded(Connection c) {
        this.reset();
    }

    @Override
    public void onConnectionRemoved(Connection c) {
        this.reset();
    }

    @Override
    public void update(Level w) {
        this.transferPower();
        this.transferredLastTick = this.transferredNextTick;
        this.transferredNextTick = new Object2DoubleOpenHashMap();
        this.burnOverloaded(w);
    }

    public Object2DoubleMap<Connection> getTransferredNextTick() {
        return this.transferredNextTick;
    }

    public Object2DoubleMap<Connection> getTransferredLastTick() {
        return Object2DoubleMaps.unmodifiable(this.transferredLastTick);
    }

    private void reset() {
        this.energyPaths.clear();
        this.transferredNextTick.clear();
        this.transferredLastTick.clear();
        this.sinks.clear();
        this.sources.clear();
        this.transferPaths.clear();
        this.sourceSinkMapInitialized = false;
        this.limits.clear();
    }

    public Map<ConnectionPoint, EnergyConnector> getSources() {
        this.updateSourcesAndSinks();
        return this.sources;
    }

    @Nullable
    public Path getPath(ConnectionPoint source, ConnectionPoint sink) {
        return this.getPathsFromSource(source).get(sink);
    }

    public Map<ConnectionPoint, Path> getPathsFromSource(ConnectionPoint source) {
        Map<ConnectionPoint, Path> mutableResult = this.energyPaths.get(source);
        if (mutableResult == null) {
            Map<ConnectionPoint, Path> finalMutableResult = mutableResult = new HashMap<ConnectionPoint, Path>();
            this.runDijkstraWithSource(source, p -> finalMutableResult.put(p.end, (Path)p));
            this.energyPaths.put(source, mutableResult);
        }
        return Collections.unmodifiableMap(mutableResult);
    }

    private void updateSourcesAndSinks() {
        if (this.sourceSinkMapInitialized) {
            this.resetLimits();
            return;
        }
        this.sourceSinkMapInitialized = true;
        for (ConnectionPoint connectionPoint : this.localNet.getConnectionPoints()) {
            IImmersiveConnectable iic = this.localNet.getConnector(connectionPoint);
            if (!(iic instanceof EnergyConnector)) continue;
            EnergyConnector energyIIC = (EnergyConnector)iic;
            if (energyIIC.isSink(connectionPoint)) {
                this.sinks.put(connectionPoint, energyIIC);
            }
            if (energyIIC.isSource(connectionPoint)) {
                this.sources.put(connectionPoint, energyIIC);
            }
            if (!(energyIIC instanceof LimitingEnergyConnector)) continue;
            LimitingEnergyConnector limiting = (LimitingEnergyConnector)energyIIC;
            for (Connection c : this.localNet.getConnections(connectionPoint)) {
                this.limits.put(c, Arrays.asList(limiting.getPowerLimit(), limiting.getPowerLimit()));
            }
        }
        for (Map.Entry entry : this.sources.entrySet()) {
            Map<ConnectionPoint, Path> paths = this.getPathsFromSource((ConnectionPoint)entry.getKey());
            ArrayList<SinkPath> sinkPaths = new ArrayList<SinkPath>();
            for (Map.Entry<ConnectionPoint, EnergyConnector> sink : this.sinks.entrySet()) {
                Path pathTo = paths.get(sink.getKey());
                if (pathTo == null) continue;
                sinkPaths.add(new SinkPath(sink.getKey(), sink.getValue(), pathTo));
            }
            this.transferPaths.add(new SinkPathsFromSource((ConnectionPoint)entry.getKey(), (EnergyConnector)entry.getValue(), sinkPaths));
        }
    }

    private void runDijkstraWithSource(ConnectionPoint source, Consumer<Path> output) {
        HashMap<ConnectionPoint, Path> shortestKnown = new HashMap<ConnectionPoint, Path>();
        BinaryHeap<ConnectionPoint> heap = new BinaryHeap<ConnectionPoint>(Comparator.comparingDouble(end -> ((Path)shortestKnown.get((Object)end)).loss));
        HashMap<ConnectionPoint, BinaryHeap.HeapEntry<ConnectionPoint>> entryMap = new HashMap<ConnectionPoint, BinaryHeap.HeapEntry<ConnectionPoint>>();
        shortestKnown.put(source, new Path(source));
        entryMap.put(source, heap.insert(source));
        while (!heap.empty()) {
            ConnectionPoint endPoint = heap.extractMin();
            entryMap.remove(endPoint);
            Path shortest = (Path)shortestKnown.get(endPoint);
            output.accept(shortest);
            if (shortest.loss >= 1.0) break;
            for (Connection next : this.localNet.getConnections(endPoint)) {
                Path alternative = shortest.append(next, this.sinks.containsKey(next.getOtherEnd(shortest.end)));
                if (!shortestKnown.containsKey(alternative.end)) {
                    shortestKnown.put(alternative.end, alternative);
                    entryMap.put(alternative.end, heap.insert(alternative.end));
                    continue;
                }
                Path oldPath = (Path)shortestKnown.get(alternative.end);
                if (!(alternative.loss < oldPath.loss)) continue;
                shortestKnown.put(alternative.end, alternative);
                heap.decreaseKey((BinaryHeap.HeapEntry)entryMap.get(alternative.end));
            }
        }
    }

    private void transferPower() {
        this.updateSourcesAndSinks();
        for (SinkPathsFromSource sourceData : this.transferPaths) {
            ConnectionPoint sourceCp = sourceData.sourceCP();
            EnergyConnector source = sourceData.sourceConnector();
            int available = source.getAvailableEnergy();
            if (available <= 0) continue;
            double maxSum = 0.0;
            record OutputData(double amount, Path path, EnergyConnector output) {
            }
            ArrayList<OutputData> maxOut = new ArrayList<OutputData>(sourceData.paths().size());
            for (SinkPath sinkEntry : sourceData.paths()) {
                EnergyConnector sink = sinkEntry.sinkConnector();
                int baseRequested = sink.getRequestedEnergy();
                if (baseRequested <= 0) continue;
                double limit = Double.MAX_VALUE;
                Connection conn = null;
                for (Connection c : sinkEntry.pathTo().conns) {
                    double limitTemp;
                    if (!this.limits.containsKey(c) || !((limitTemp = Math.min(this.limits.get(c).get(1), limit)) < limit)) continue;
                    conn = c;
                    limit = limitTemp;
                }
                int requested = (int)Math.min((double)baseRequested, limit * (1.0 - sinkEntry.pathTo().loss));
                if (requested <= 0) continue;
                double requiredAtSource = Math.min((double)requested / (1.0 - sinkEntry.pathTo().loss), (double)available);
                if (conn != null) {
                    this.limits.put(conn, Arrays.asList(this.limits.get(conn).getFirst(), limit - Math.min(requiredAtSource, Math.max((double)available - maxSum, 0.0))));
                }
                maxOut.add(new OutputData(requiredAtSource, sinkEntry.pathTo(), sink));
                maxSum += requiredAtSource;
            }
            if (maxSum == 0.0) continue;
            double allowedFactor = Math.min(1.0, (double)available / maxSum);
            for (OutputData entry : maxOut) {
                Path path = entry.path();
                double atSource = allowedFactor * entry.amount();
                double availableFactor = 1.0;
                ConnectionPoint currentPoint = sourceCp;
                for (Connection c : path.conns) {
                    IImmersiveConnectable iic;
                    currentPoint = c.getOtherEnd(currentPoint);
                    double availableAtPoint = atSource * (availableFactor *= 1.0 - EnergyTransferHandler.getBasicLoss(c));
                    this.transferredNextTick.addTo((Object)c, availableAtPoint);
                    if (currentPoint.equals(path.end) || !((iic = this.localNet.getConnector(currentPoint)) instanceof EnergyConnector)) continue;
                    ((EnergyConnector)iic).onEnergyPassedThrough(availableAtPoint);
                }
                entry.output.insertEnergy(this.ceilIfClose(atSource * availableFactor));
            }
            if (allowedFactor < 1.0) {
                source.extractEnergy(available);
                continue;
            }
            source.extractEnergy(Mth.ceil((double)maxSum));
        }
    }

    private int ceilIfClose(double in) {
        return (int)(in + 0.01);
    }

    private void burnOverloaded(Level world) {
        Preconditions.checkNotNull((Object)this.globalNet);
        ArrayList<Pair> toBurn = new ArrayList<Pair>();
        for (Object2DoubleMap.Entry entry : this.transferredLastTick.object2DoubleEntrySet()) {
            Connection c = (Connection)entry.getKey();
            double transferred = entry.getDoubleValue();
            if (!(c.type instanceof IEnergyWire) || !((IEnergyWire)((Object)c.type)).shouldBurn(c, transferred)) continue;
            toBurn.add(Pair.of((Object)c, (Object)transferred));
        }
        for (Pair c : toBurn) {
            ((IEnergyWire)((Object)((Connection)c.getFirst()).type)).burn((Connection)c.getFirst(), (Double)c.getSecond(), this.globalNet, world);
        }
    }

    private static double getBasicLoss(Connection c) {
        if (c.isInternal()) {
            return 0.0;
        }
        WireType wireType = c.type;
        if (wireType instanceof IEnergyWire) {
            IEnergyWire energyWire = (IEnergyWire)((Object)wireType);
            return energyWire.getBasicLossRate(c);
        }
        return Double.POSITIVE_INFINITY;
    }

    private void resetLimits() {
        if (this.limits.isEmpty()) {
            return;
        }
        this.limits.replaceAll((connection, limit) -> Arrays.asList(this.limits.get(connection).getFirst(), this.limits.get(connection).getFirst()));
    }

    public static class Path {
        public final Connection[] conns;
        public final ConnectionPoint start;
        public final ConnectionPoint end;
        public final double loss;
        public final boolean isPathToSink;

        private Path(Connection[] conns, ConnectionPoint start, ConnectionPoint end, double loss, boolean isPathToSink) {
            this.conns = conns;
            this.start = start;
            this.end = end;
            this.loss = loss;
            this.isPathToSink = isPathToSink;
        }

        public Path(ConnectionPoint point) {
            this(new Connection[0], point, point, 0.0, false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return Arrays.equals(this.conns, path.conns);
        }

        public int hashCode() {
            return Arrays.hashCode(this.conns);
        }

        public Path append(Connection next, boolean isPathToSink) {
            ConnectionPoint newEnd = next.getOtherEnd(this.end);
            double newLoss = this.loss + (1.0 - this.loss) * EnergyTransferHandler.getBasicLoss(next);
            Connection[] newPath = Arrays.copyOf(this.conns, this.conns.length + 1);
            newPath[newPath.length - 1] = next;
            return new Path(newPath, this.start, newEnd, newLoss, isPathToSink);
        }
    }

    public static interface EnergyConnector
    extends IImmersiveConnectable {
        public boolean isSource(ConnectionPoint var1);

        public boolean isSink(ConnectionPoint var1);

        default public int getAvailableEnergy() {
            return 0;
        }

        default public int getRequestedEnergy() {
            return 0;
        }

        default public void insertEnergy(int amount) {
        }

        default public void extractEnergy(int amount) {
        }

        default public void onEnergyPassedThrough(double amount) {
        }
    }

    public static interface LimitingEnergyConnector
    extends EnergyConnector {
        public double getPowerLimit();
    }

    private record SinkPath(ConnectionPoint sinkCP, EnergyConnector sinkConnector, Path pathTo) {
    }

    private record SinkPathsFromSource(ConnectionPoint sourceCP, EnergyConnector sourceConnector, List<SinkPath> paths) {
    }

    public static interface IEnergyWire {
        public int getTransferRate();

        public double getBasicLossRate(Connection var1);

        public double getLossRate(Connection var1, int var2);

        default public boolean shouldBurn(Connection c, double power) {
            return power > (double)this.getTransferRate();
        }

        default public void burn(Connection c, double power, GlobalWireNetwork net, Level w) {
            net.removeConnection(c);
            if (w instanceof ServerLevel) {
                int numPoints = 16;
                Vec3 offset = Vec3.atLowerCornerOf((Vec3i)c.getEndA().position());
                for (int i = 1; i < 16; ++i) {
                    double posOnWire = (double)i / 16.0;
                    Vec3 pos = c.getPoint(posOnWire, c.getEndA()).add(offset);
                    ((ServerLevel)w).sendParticles((ParticleOptions)ParticleTypes.FLAME, pos.x, pos.y, pos.z, 0, 0.0, 0.0, 0.0, 1.0);
                }
            }
        }
    }
}

