/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;

public class HatchBlock
extends IEBaseBlock {
    private static final Map<Direction, VoxelShape> SHAPES = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)Shapes.box((double)0.1875, (double)0.875, (double)0.1875, (double)0.8125, (double)1.0625, (double)0.8125)).put((Object)Direction.UP, (Object)Shapes.box((double)0.1875, (double)-0.0625, (double)0.1875, (double)0.8125, (double)0.125, (double)0.8125)).put((Object)Direction.NORTH, (Object)Shapes.box((double)0.1875, (double)0.1875, (double)0.875, (double)0.8125, (double)0.8125, (double)1.0625)).put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.1875, (double)0.1875, (double)-0.0625, (double)0.8125, (double)0.8125, (double)0.125)).put((Object)Direction.WEST, (Object)Shapes.box((double)0.875, (double)0.1875, (double)0.1875, (double)1.0625, (double)0.8125, (double)0.8125)).put((Object)Direction.EAST, (Object)Shapes.box((double)-0.0625, (double)0.1875, (double)0.1875, (double)0.125, (double)0.8125, (double)0.8125)).build();

    public HatchBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    protected BlockState getInitDefaultState() {
        return super.getInitDefaultState();
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        state = (BlockState)state.setValue((Property)IEProperties.FACING_ALL, (Comparable)context.getClickedFace());
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.FACING_ALL, BlockStateProperties.WATERLOGGED});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!player.getMainHandItem().isEmpty()) {
            return InteractionResult.PASS;
        }
        Direction dir = (Direction)state.getValue((Property)IEProperties.FACING_ALL);
        IItemHandler itemHandler = CapabilityUtils.findItemHandlerAtPos(level, pos.relative(dir.getOpposite()), dir, true);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack extractItem = itemHandler.extractItem(i, 64, false);
                if (extractItem.isEmpty()) continue;
                player.setItemInHand(InteractionHand.MAIN_HAND, extractItem);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)IEProperties.FACING_ALL));
    }
}

