/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.resources;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.data.recipes.IERecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.conditions.ICondition;

public class SecondaryOutput {
    private final IngredientWithSize item;
    private final float chance;
    private ICondition[] conditions;

    public SecondaryOutput(IngredientWithSize item, float chance) {
        this.item = item;
        this.chance = chance;
        this.conditions = new ICondition[0];
    }

    public SecondaryOutput(TagKey<Item> tag, float chance) {
        this(new IngredientWithSize(tag), chance);
        this.conditions = new ICondition[]{IERecipeProvider.getTagCondition(tag)};
    }

    public SecondaryOutput(ResourceLocation tag, float chance) {
        this((TagKey<Item>)TagUtils.createItemWrapper((ResourceLocation)tag), chance);
    }

    public IngredientWithSize getItem() {
        return this.item;
    }

    public float getChance() {
        return this.chance;
    }

    public SecondaryOutput setConditions(ICondition[] conditions) {
        this.conditions = conditions;
        return this;
    }

    public ICondition[] getConditions() {
        return this.conditions;
    }
}

