/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.resources;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.data.resources.SecondaryOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum RecipeOres {
    COAL("coal", true, Items.COAL, 4, new SecondaryOutput((TagKey<Item>)IETags.sulfurDust, 0.15f)),
    DIAMOND("diamond", true, Items.DIAMOND, 2, new SecondaryOutput[0]),
    EMERALD("emerald", true, Items.EMERALD, 2, new SecondaryOutput[0]),
    LAPIS("lapis", true, Items.LAPIS_LAZULI, 9, new SecondaryOutput((TagKey<Item>)IETags.sulfurDust, 0.2f)),
    QUARTZ("quartz", true, Items.QUARTZ, 3, new SecondaryOutput((TagKey<Item>)IETags.sulfurDust, 0.25f)),
    REDSTONE("redstone", true, Items.REDSTONE, 6, new SecondaryOutput[0]),
    FLUORITE("fluorite", false, new IngredientWithSize(TagUtils.createItemWrapper((ResourceLocation)IETags.getGem((String)"fluorite")), 6), new SecondaryOutput[0]);

    private final String name;
    private final boolean isNative;
    private final TagKey<Item> ore;
    private final IngredientWithSize output;
    private final SecondaryOutput[] secondaryOutputs;

    private RecipeOres(String name, boolean isNative, IngredientWithSize output, SecondaryOutput ... secondaryOutputs) {
        this.name = name;
        this.ore = TagUtils.createItemWrapper((ResourceLocation)IETags.getOre((String)name));
        this.isNative = isNative;
        this.output = output;
        this.secondaryOutputs = secondaryOutputs;
    }

    private RecipeOres(String name, boolean isNative, Item output, int outputSize, SecondaryOutput ... secondaryOutputs) {
        this(name, isNative, new IngredientWithSize(Ingredient.of((ItemLike[])new ItemLike[]{output}), outputSize), secondaryOutputs);
    }

    public String getName() {
        return this.name;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public TagKey<Item> getOre() {
        return this.ore;
    }

    public IngredientWithSize getOutput() {
        return this.output;
    }

    public SecondaryOutput[] getSecondaryOutputs() {
        return this.secondaryOutputs;
    }
}

