/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.energy.GeneratorFuel;
import blusunrize.immersiveengineering.api.energy.ThermoelectricSource;
import blusunrize.immersiveengineering.api.energy.WindmillBiome;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.metal.WarningSignBlock;
import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import blusunrize.immersiveengineering.common.crafting.NoContainersShapedRecipe;
import blusunrize.immersiveengineering.common.crafting.RGBColourationRecipe;
import blusunrize.immersiveengineering.common.crafting.fluidaware.BasicShapedRecipe;
import blusunrize.immersiveengineering.common.crafting.fluidaware.IngredientFluidStack;
import blusunrize.immersiveengineering.common.crafting.fluidaware.ShapelessFluidAwareRecipe;
import blusunrize.immersiveengineering.common.crafting.fluidaware.TurnAndCopyRecipe;
import blusunrize.immersiveengineering.common.items.bullets.IEBullets;
import blusunrize.immersiveengineering.common.register.IEBannerPatterns;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.data.recipes.IERecipeProvider;
import blusunrize.immersiveengineering.data.recipes.WrappingRecipeOutput;
import blusunrize.immersiveengineering.data.recipes.builder.BlueprintCraftingRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.MineralMixBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

public class MiscRecipes
extends IERecipeProvider {
    public MiscRecipes(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> provider) {
        super(p_248933_, provider);
    }

    protected void buildRecipes(RecipeOutput out) {
        this.recipesVanilla(out);
        this.recipesMisc(out);
        this.buildGeneratedList(out, ImmersiveEngineering.rl((String)"arc_recycling_list"));
        this.buildGeneratedList(out, ImmersiveEngineering.rl((String)"mixer_potion_list"));
        this.buildGeneratedList(out, ImmersiveEngineering.rl((String)"potion_bottling_list"));
        out.accept(this.toRL("curtain_colour"), (Recipe)new RGBColourationRecipe(Ingredient.of((ItemLike[])new ItemLike[]{IEBlocks.Cloth.STRIP_CURTAIN})), null);
        this.recipesBlueprint(out);
        this.mineralMixes(out);
        out.accept(this.toRL("generator_fuel/biodiesel"), (Recipe)new GeneratorFuel(IETags.fluidBiodiesel, 250), null);
        out.accept(this.toRL("generator_fuel/high_power_biodiesel"), (Recipe)new GeneratorFuel(IETags.fluidHighPowerBiodiesel, 275), null);
        out.accept(this.toRL("generator_fuel/creosote"), (Recipe)new GeneratorFuel(IETags.fluidCreosote, 20), null);
        this.thermoelectricFuels(out);
        out.accept(this.toRL("windmill/ocean"), (Recipe)new WindmillBiome(BiomeTags.IS_OCEAN, 1.15f), null);
    }

    private void recipesBlueprint(RecipeOutput out) {
        ItemLike[] molds;
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("components").output(new ItemStack((ItemLike)IEItems.Ingredients.COMPONENT_IRON))).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate, 2)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).build(out, this.toRL("blueprint/component_iron"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("components").output(new ItemStack((ItemLike)IEItems.Ingredients.COMPONENT_STEEL))).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate, 2)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).build(out, this.toRL("blueprint/component_steel"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("components").output(new ItemStack((ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC))).input((TagKey<Item>)IETags.getItemTag((TagKey)IETags.treatedWoodSlab))).input((TagKey<Item>)Tags.Items.GEMS_QUARTZ)).input((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).input((TagKey<Item>)IETags.electrumWire)).build(out, this.toRL("blueprint/component_electronic"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("components").output(new ItemStack((ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC_ADV))).input((TagKey<Item>)IETags.plasticPlate)).input((ItemLike)IEItems.Ingredients.ELECTRON_TUBE, 2)).input((TagKey<Item>)IETags.aluminumWire)).build(out, this.toRL("blueprint/component_electronic_adv"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("components").output(new ItemStack((ItemLike)IEItems.Ingredients.LIGHT_BULB, 3))).input((TagKey<Item>)Tags.Items.GLASS_BLOCKS)).input(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(IETags.paper), new Ingredient.ItemValue(Items.BAMBOO.getDefaultInstance()))), 3)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).build(out, this.toRL("blueprint/light_bulb"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("components").output(new ItemStack((ItemLike)IEItems.Ingredients.ELECTRON_TUBE, 3))).input((TagKey<Item>)Tags.Items.GLASS_BLOCKS)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).plate)).input((TagKey<Item>)IETags.copperWire)).input((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).build(out, this.toRL("blueprint/electron_tube"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("components").output(new ItemStack((ItemLike)IEItems.Ingredients.CIRCUIT_BOARD))).input((TagKey<Item>)IETags.plasticPlate)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).plate)).build(out, this.toRL("blueprint/circuit_board"));
        for (ItemLike mold : molds = new ItemLike[]{IEItems.Molds.MOLD_PLATE, IEItems.Molds.MOLD_GEAR, IEItems.Molds.MOLD_ROD, IEItems.Molds.MOLD_BULLET_CASING, IEItems.Molds.MOLD_WIRE, IEItems.Molds.MOLD_PACKING_4, IEItems.Molds.MOLD_PACKING_9, IEItems.Molds.MOLD_UNPACKING}) {
            ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("molds").output((ItemLike)mold.asItem())).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate, 3)).input((ItemLike)IEItems.Tools.WIRECUTTER)).build(out, this.toRL("blueprint/" + this.toPath(mold)));
        }
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bullet").output(new ItemStack((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.CASULL), 4))).input(BulletHandler.emptyCasing, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).nugget)).build(out, this.toRL("blueprint/bullet_casull"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bullet").output(new ItemStack((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.ARMOR_PIERCING), 4))).input(BulletHandler.emptyCasing, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).nugget)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.CONSTANTAN).nugget, 2)).build(out, this.toRL("blueprint/bullet_armorpiercing"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bullet").output(new ItemStack((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.ARMOR_PIERCING), 4))).input(BulletHandler.emptyCasing, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((TagKey<Item>)IETags.netheriteNugget, 3)).build(out, this.toRL("blueprint/bullet_armorpiercing_netherite"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bullet").output(new ItemStack((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.SILVER), 4))).input(BulletHandler.emptyCasing, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).nugget)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).nugget)).build(out, this.toRL("blueprint/bullet_silver"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bullet").output(new ItemStack((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.BUCKSHOT), 4))).input(BulletHandler.emptyShell, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).dust)).build(out, this.toRL("blueprint/bullet_buckshot"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("specialBullet").output(new ItemStack((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.HIGH_EXPLOSIVE), 4))).input(BulletHandler.emptyCasing, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((ItemLike)Items.TNT)).build(out, this.toRL("blueprint/bullet_explosive"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("specialBullet").output(new ItemStack((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.DRAGONS_BREATH), 4))).input(BulletHandler.emptyShell, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).dust, 2)).build(out, this.toRL("blueprint/bullet_dragonsbreath"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("specialBullet").output(new ItemStack((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.POTION), 4))).input(BulletHandler.emptyShell, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((ItemLike)Items.GLASS_BOTTLE, 4)).build(out, this.toRL("blueprint/bullet_potion"));
        ItemStack flare = new ItemStack((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.FLARE), 4);
        DataComponentType flareComponent = IEDataComponents.getBulletData((BulletHandler.IBullet)IEBullets.FLARE_TYPE);
        flare.set(flareComponent, (Object)Color4.fromRGB((int)13381126));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("specialBullet").output(flare.copy())).input(BulletHandler.emptyShell, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).dust)).input((TagKey<Item>)Tags.Items.DYES_RED)).build(out, this.toRL("blueprint/bullet_flare_red"));
        flare.set(flareComponent, (Object)Color4.fromRGB((int)2925323));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("specialBullet").output(flare.copy())).input(BulletHandler.emptyShell, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).dust)).input((TagKey<Item>)Tags.Items.DYES_GREEN)).build(out, this.toRL("blueprint/bullet_flare_green"));
        flare.set(flareComponent, (Object)Color4.fromRGB((int)0xFFFF82));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("specialBullet").output(flare.copy())).input(BulletHandler.emptyShell, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).dust)).input((TagKey<Item>)Tags.Items.DYES_YELLOW)).build(out, this.toRL("blueprint/bullet_flare_yellow"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("specialBullet").output(new ItemStack((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.HOMING), 4))).input(BulletHandler.emptyCasing, 4)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).nugget)).input((ItemLike)Items.ENDER_EYE)).build(out, this.toRL("blueprint/bullet_homing"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("specialBullet").output((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.WOLFPACK))).input(BulletHandler.emptyShell)).input((TagKey<Item>)Tags.Items.GUNPOWDERS)).input((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.HOMING), 4)).build(out, this.toRL("blueprint/bullet_wolfpack"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bannerpatterns").output((ItemLike)IEBannerPatterns.HAMMER.item())).input((TagKey<Item>)IETags.paper)).input((ItemLike)IEItems.Tools.HAMMER)).build(out, this.toRL("blueprint/banner_hammer"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bannerpatterns").output((ItemLike)IEBannerPatterns.WIRECUTTER.item())).input((TagKey<Item>)IETags.paper)).input((ItemLike)IEItems.Tools.WIRECUTTER)).build(out, this.toRL("blueprint/banner_wirecutter"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bannerpatterns").output((ItemLike)IEBannerPatterns.SCREWDRIVER.item())).input((TagKey<Item>)IETags.paper)).input((ItemLike)IEItems.Tools.SCREWDRIVER)).build(out, this.toRL("blueprint/banner_screwdriver"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bannerpatterns").output((ItemLike)IEBannerPatterns.BEVELS.item())).input((TagKey<Item>)IETags.paper)).input((TagKey<Item>)IETags.plates)).build(out, this.toRL("blueprint/banner_bevels"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bannerpatterns").output((ItemLike)IEBannerPatterns.ORNATE.item())).input((TagKey<Item>)IETags.paper)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).dust)).build(out, this.toRL("blueprint/banner_ornate"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bannerpatterns").output((ItemLike)IEBannerPatterns.TREATED_WOOD.item())).input((TagKey<Item>)IETags.paper)).input((TagKey<Item>)IETags.getItemTag((TagKey)IETags.treatedWood))).build(out, this.toRL("blueprint/banner_treatedwood"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bannerpatterns").output((ItemLike)IEBannerPatterns.WINDMILL.item())).input((TagKey<Item>)IETags.paper)).input((ItemLike)IEBlocks.WoodenDevices.WINDMILL)).build(out, this.toRL("blueprint/banner_windmill"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bannerpatterns").output((ItemLike)IEBannerPatterns.WARNING.item())).input((TagKey<Item>)IETags.paper)).input(Ingredient.fromValues(IEBlocks.MetalDecoration.WARNING_SIGNS.values().stream().map(b -> new Ingredient.ItemValue(new ItemStack((ItemLike)b)))))).build(out, this.toRL("blueprint/banner_warning"));
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("bannerpatterns").output((ItemLike)IEBannerPatterns.WOLF.item())).input((TagKey<Item>)IETags.paper)).input((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.WOLFPACK))).build(out, this.toRL("blueprint/banner_wolf"));
        for (WarningSignBlock.WarningSignIcon icon : WarningSignBlock.WarningSignIcon.values()) {
            ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("warning_sign").output((ItemLike)IEBlocks.MetalDecoration.WARNING_SIGNS.get(icon))).input((TagKey<Item>)IETags.plates)).input((TagKey<Item>)Tags.Items.DYES_YELLOW)).build(out, this.toRL("blueprint/" + this.toPath((ItemLike)IEBlocks.MetalDecoration.WARNING_SIGNS.get(icon))));
        }
        ((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)((BlueprintCraftingRecipeBuilder)BlueprintCraftingRecipeBuilder.builder().category("automatons").output((ItemLike)IEItems.SpawnEggs.ROBOT_WOLF)).input((ItemLike)IEBlocks.MetalDevices.THERMOELECTRIC_GEN)).input((ItemLike)IEBlocks.MetalDecoration.RADIATOR)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.URANIUM).ingot, 3)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate, 2)).input((ItemLike)IEItems.Ingredients.COMPONENT_ELECTRONIC_ADV)).input((ItemLike)IEItems.Ingredients.COMPONENT_STEEL, 2)).build(out, this.toRL("blueprint/" + this.toPath((ItemLike)IEItems.SpawnEggs.ROBOT_WOLF)));
    }

    private void mineralMixes(RecipeOutput out) {
        TagKey iron = Tags.Items.ORES_IRON;
        TagKey gold = Tags.Items.ORES_GOLD;
        TagKey copper = Tags.Items.ORES_COPPER;
        TagKey aluminum = IETags.getItemTag((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ore);
        TagKey lead = IETags.getItemTag((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).ore);
        TagKey silver = IETags.getItemTag((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).ore);
        TagKey nickel = IETags.getItemTag((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.NICKEL).ore);
        TagKey uranium = IETags.getItemTag((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.URANIUM).ore);
        TagKey tin = TagUtils.createItemWrapper((ResourceLocation)IETags.getOre((String)"tin"));
        TagKey titanium = TagUtils.createItemWrapper((ResourceLocation)IETags.getOre((String)"titanium"));
        TagKey thorium = TagUtils.createItemWrapper((ResourceLocation)IETags.getOre((String)"thorium"));
        TagKey tungsten = TagUtils.createItemWrapper((ResourceLocation)IETags.getOre((String)"tungsten"));
        TagKey manganese = TagUtils.createItemWrapper((ResourceLocation)IETags.getOre((String)"manganese"));
        TagKey platinum = TagUtils.createItemWrapper((ResourceLocation)IETags.getOre((String)"platinum"));
        TagKey osmium = TagUtils.createItemWrapper((ResourceLocation)IETags.getOre((String)"osmium"));
        TagKey mercury = TagUtils.createItemWrapper((ResourceLocation)IETags.getOre((String)"mercury"));
        TagKey sulfur = IETags.sulfurDust;
        TagKey phosphorus = TagUtils.createItemWrapper((ResourceLocation)IETags.getDust((String)"phosphorus"));
        TagKey redstone = Tags.Items.ORES_REDSTONE;
        TagKey emerald = Tags.Items.ORES_EMERALD;
        Block prismarine = Blocks.PRISMARINE;
        TagKey aquamarine = TagUtils.createItemWrapper((ResourceLocation)IETags.getGem((String)"aquamarine"));
        MineralMixBuilder.builder().dimensionOverworld().biomeCondition(BiomeTags.IS_RIVER, IETags.is_swamp, BiomeTags.IS_OCEAN).addSoilSpoils().ore((ItemLike)Items.CLAY, 0.6f).ore((ItemLike)Items.SAND, 0.4f).weight(25).failchance(0.2f).build(out, this.toRL("mineral/silt"));
        MineralMixBuilder.builder().dimensionOverworld().addOverworldSpoils().ore((ItemLike)Blocks.GRANITE, 0.3f).ore((ItemLike)Blocks.DIORITE, 0.3f).ore((ItemLike)Blocks.ANDESITE, 0.3f).ore((ItemLike)Blocks.OBSIDIAN, 0.1f).weight(25).failchance(0.05f).build(out, this.toRL("mineral/igneous_rock"));
        MineralMixBuilder.builder().dimensionOverworld().biomeCondition(IETags.generateClaypan).addSoilSpoils().ore((ItemLike)Items.TERRACOTTA, 0.6f).ore((ItemLike)Items.RED_SANDSTONE, 0.3f).ore((ItemLike)Items.RED_SAND, 0.1f).weight(15).failchance(0.05f).build(out, this.toRL("mineral/hardened_clay_pan"));
        MineralMixBuilder.builder().dimensionOverworld().biomeCondition(IETags.generateSeabed).addSeabedSpoils().ore((ItemLike)Blocks.CALCITE, 0.65f).ore((ItemLike)Blocks.DRIPSTONE_BLOCK, 0.3f).ore((ItemLike)Blocks.BONE_BLOCK, 0.05f).weight(15).failchance(0.05f).build(out, this.toRL("mineral/ancient_seabed"));
        MineralMixBuilder.builder().dimensionOverworld().addOverworldSpoils().ore((ItemLike)Blocks.AMETHYST_BLOCK, 0.4f).ore((ItemLike)Blocks.CALCITE, 0.3f).ore((ItemLike)Blocks.SMOOTH_BASALT, 0.3f).weight(10).failchance(0.1f).build(out, this.toRL("mineral/amethyst_crevasse"));
        MineralMixBuilder.builder().dimensionOverworld().addOverworldSpoils().ore((TagKey<Item>)Tags.Items.ORES_COAL, 0.8f, new ICondition[0]).ore((TagKey<Item>)sulfur, 0.2f, new ICondition[0]).ore((TagKey<Item>)phosphorus, 0.2f, MiscRecipes.getTagCondition(phosphorus)).weight(25).failchance(0.05f).build(out, this.toRL("mineral/bituminous_coal"));
        MineralMixBuilder.builder().dimensionOverworld().addOverworldSpoils().ore((TagKey<Item>)iron, 0.8f, new ICondition[0]).ore((ItemLike)Blocks.DRIPSTONE_BLOCK, 0.2f).weight(25).failchance(0.05f).build(out, this.toRL("mineral/banded_iron"));
        MineralMixBuilder.builder().dimensionOverworld().biomeCondition(BiomeTags.IS_MOUNTAIN).addOverworldSpoils().ore((TagKey<Item>)iron, 0.5f, new ICondition[0]).ore((TagKey<Item>)copper, 0.45f, new ICondition[0]).ore((TagKey<Item>)sulfur, 0.05f, new ICondition[0]).weight(25).failchance(0.05f).build(out, this.toRL("mineral/chalcopyrite"));
        MineralMixBuilder.builder().dimensionOverworld().addOverworldSpoils().ore((TagKey<Item>)redstone, 0.6f, new ICondition[0]).ore((TagKey<Item>)sulfur, 0.4f, new ICondition[0]).ore((TagKey<Item>)mercury, 0.3f, MiscRecipes.getTagCondition(mercury)).weight(20).failchance(0.1f).build(out, this.toRL("mineral/cinnabar"));
        MineralMixBuilder.builder().dimensionOverworld().addOverworldSpoils().ore((TagKey<Item>)copper, 0.7f, new ICondition[0]).ore((TagKey<Item>)gold, 0.3f, new ICondition[0]).weight(20).failchance(0.1f).build(out, this.toRL("mineral/auricupride"));
        MineralMixBuilder.builder().dimensionOverworld().biomeCondition(BiomeTags.IS_BADLANDS).addOverworldSpoils().ore((TagKey<Item>)gold, 0.6f, new ICondition[0]).ore((TagKey<Item>)copper, 0.4f, new ICondition[0]).weight(20).failchance(0.1f).build(out, this.toRL("mineral/rich_auricupride"));
        MineralMixBuilder.builder().dimensionOverworld().addOverworldSpoils().ore((TagKey<Item>)aluminum, 0.6f, new ICondition[0]).ore((TagKey<Item>)iron, 0.3f, new ICondition[0]).ore((TagKey<Item>)nickel, 0.1f, new ICondition[0]).ore((TagKey<Item>)titanium, 0.1f, MiscRecipes.getTagCondition(titanium)).weight(20).failchance(0.05f).build(out, this.toRL("mineral/laterite"));
        MineralMixBuilder.builder().dimensionOverworld().addOverworldSpoils().ore((TagKey<Item>)lead, 0.4f, new ICondition[0]).ore((TagKey<Item>)silver, 0.25f, new ICondition[0]).ore((TagKey<Item>)gold, 0.25f, new ICondition[0]).ore((TagKey<Item>)sulfur, 0.1f, new ICondition[0]).weight(20).failchance(0.05f).build(out, this.toRL("mineral/galena"));
        MineralMixBuilder.builder().dimensionOverworld().addOverworldSpoils().ore((TagKey<Item>)nickel, 0.65f, new ICondition[0]).ore((TagKey<Item>)iron, 0.25f, new ICondition[0]).ore((TagKey<Item>)sulfur, 0.1f, new ICondition[0]).ore((TagKey<Item>)platinum, 0.1f, MiscRecipes.getTagCondition(platinum)).ore((TagKey<Item>)osmium, 0.1f, MiscRecipes.getTagCondition(osmium)).weight(15).failchance(0.1f).build(out, this.toRL("mineral/pentlandite"));
        MineralMixBuilder.builder().dimensionOverworld().addOverworldSpoils().ore((TagKey<Item>)Tags.Items.ORES_LAPIS, 0.75f, new ICondition[0]).ore((TagKey<Item>)gold, 0.15f, new ICondition[0]).ore((TagKey<Item>)sulfur, 0.1f, new ICondition[0]).weight(15).failchance(0.1f).build(out, this.toRL("mineral/lazulitic_intrusion"));
        MineralMixBuilder.builder().dimensionOverworld().biomeCondition(BiomeTags.IS_MOUNTAIN, BiomeTags.IS_OCEAN).addOverworldSpoils().ore((TagKey<Item>)emerald, 0.3f, new ICondition[0]).ore((ItemLike)prismarine, 0.7f).ore((TagKey<Item>)aquamarine, 0.3f, MiscRecipes.getTagCondition(aquamarine)).weight(15).failchance(0.2f).build(out, this.toRL("mineral/beryl"));
        MineralMixBuilder.builder().dimensionOverworld().biomeCondition(BiomeTags.IS_RIVER).addSoilSpoils().ore((TagKey<Item>)Tags.Items.GEMS_DIAMOND, 0.2f, new ICondition[0]).ore((ItemLike)Items.CLAY, 0.4f).ore((ItemLike)Items.SAND, 0.4f).weight(15).failchance(0.2f).build(out, this.toRL("mineral/alluvial_sift"));
        MineralMixBuilder.builder().dimensionOverworld().biomeCondition(BiomeTags.IS_BADLANDS, BiomeTags.IS_TAIGA).addOverworldSpoils().ore((TagKey<Item>)uranium, 0.6f, new ICondition[0]).ore((TagKey<Item>)lead, 0.4f, new ICondition[0]).ore((TagKey<Item>)thorium, 0.1f, MiscRecipes.getTagCondition(thorium)).weight(15).failchance(0.15f).build(out, this.toRL("mineral/uraninite"));
        ((MineralMixBuilder)MineralMixBuilder.builder().addCondition(MiscRecipes.getTagCondition(tungsten))).dimensionOverworld().addOverworldSpoils().ore((TagKey<Item>)tungsten, 0.7f, new ICondition[0]).ore((TagKey<Item>)iron, 0.3f, new ICondition[0]).ore((TagKey<Item>)manganese, 0.3f, MiscRecipes.getTagCondition(manganese)).ore((TagKey<Item>)tin, 0.3f, MiscRecipes.getTagCondition(tin)).weight(5).failchance(0.15f).build(out, this.toRL("mineral/wolframite"));
        MineralMixBuilder.builder().dimensionNether().addNetherSpoils().ore((ItemLike)Blocks.NETHER_QUARTZ_ORE, 0.6f).ore((ItemLike)Blocks.NETHER_GOLD_ORE, 0.2f).ore((TagKey<Item>)sulfur, 0.2f, new ICondition[0]).weight(20).failchance(0.15f).background(Blocks.NETHERRACK).build(out, this.toRL("mineral/mephitic_quarzite"));
        MineralMixBuilder.builder().dimensionNether().addNetherSpoils().ore((ItemLike)Blocks.POLISHED_BLACKSTONE_BRICKS, 0.4f).ore((ItemLike)Blocks.POLISHED_BLACKSTONE, 0.3f).ore((ItemLike)Blocks.ANCIENT_DEBRIS, 0.2f).ore((ItemLike)Blocks.GILDED_BLACKSTONE, 0.1f).weight(8).failchance(0.5f).background(Blocks.POLISHED_BLACKSTONE).build(out, this.toRL("mineral/ancient_debris"));
        MineralMixBuilder.builder().dimensionNether().addNetherSpoils().ore((ItemLike)Items.SOUL_SOIL, 0.5f).ore((ItemLike)Items.SOUL_SAND, 0.3f).ore((ItemLike)Items.GRAVEL, 0.2f).weight(15).failchance(0.05f).background(Blocks.SOUL_SOIL).build(out, this.toRL("mineral/nether_silt"));
        MineralMixBuilder.builder().dimensionNether().addNetherSpoils().ore((ItemLike)Items.MAGMA_BLOCK, 0.5f).ore((ItemLike)Items.SMOOTH_BASALT, 0.3f).ore((ItemLike)Items.OBSIDIAN, 0.2f).weight(15).failchance(0.05f).background(Blocks.NETHERRACK).build(out, this.toRL("mineral/cooled_lava_tube"));
    }

    private void thermoelectricFuels(RecipeOutput out) {
        out.accept(this.toRL("thermoelectric/magma"), (Recipe)new ThermoelectricSource(Blocks.MAGMA_BLOCK, 1300), null);
        out.accept(this.toRL("thermoelectric/snow"), (Recipe)new ThermoelectricSource(BlockTags.SNOW, 273), null);
        out.accept(this.toRL("thermoelectric/ice"), (Recipe)new ThermoelectricSource(Blocks.ICE, 260), null);
        out.accept(this.toRL("thermoelectric/packed_ice"), (Recipe)new ThermoelectricSource(Blocks.PACKED_ICE, 240), null);
        out.accept(this.toRL("thermoelectric/blue_ice"), (Recipe)new ThermoelectricSource(Blocks.BLUE_ICE, 200), null);
        out.accept(this.toRL("thermoelectric/uranium"), (Recipe)new ThermoelectricSource(IETags.getTagsFor((EnumMetals)EnumMetals.URANIUM).storage, 2000), null);
    }

    private void recipesVanilla(RecipeOutput out) {
        this.shapedMisc((ItemLike)Items.TORCH, 12).pattern("wc ").pattern("sss").define(Character.valueOf('w'), ItemTags.WOOL).define(Character.valueOf('c'), new Ingredient((ICustomIngredient)new IngredientFluidStack(IETags.fluidCreosote, 1000))).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_wool", MiscRecipes.has((TagKey)ItemTags.WOOL)).unlockedBy("has_stick", MiscRecipes.has((TagKey)Tags.Items.RODS_WOODEN)).unlockedBy("has_creosote", MiscRecipes.has((ItemLike)IEFluids.CREOSOTE.getBucket())).save(new WrappingRecipeOutput<ShapedRecipe>(out, BasicShapedRecipe::new), this.toRL(this.toPath((ItemLike)Items.TORCH)));
        this.shapelessMisc((ItemLike)Items.STRING).requires(Ingredient.of((TagKey)IETags.fiberHemp), 3).unlockedBy("has_hemp_fiber", MiscRecipes.has((ItemLike)IEItems.Ingredients.HEMP_FIBER)).save(out, this.toRL(this.toPath((ItemLike)Items.STRING)));
        this.shapelessMisc((ItemLike)Items.GUNPOWDER, 6).requires(Ingredient.of((TagKey)IETags.saltpeterDust), 4).requires(IETags.sulfurDust).requires((ItemLike)Items.CHARCOAL).unlockedBy("has_sulfur", MiscRecipes.has((TagKey)IETags.sulfurDust)).save(out, this.toRL("gunpowder_from_dusts"));
        this.shapelessMisc((ItemLike)Items.PAPER, 2).requires(Ingredient.of((TagKey)IETags.sawdust), 4).requires(new Ingredient((ICustomIngredient)new IngredientFluidStack(FluidTags.WATER, 1000))).unlockedBy("has_sawdust", MiscRecipes.has((TagKey)IETags.sawdust)).save(new WrappingRecipeOutput<ShapelessRecipe>(out, ShapelessFluidAwareRecipe::new), this.toRL("paper_from_sawdust"));
    }

    private void recipesMisc(RecipeOutput out) {
        ItemLike wireCoilCopper = (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER);
        this.shapedMisc(wireCoilCopper, 4).pattern(" w ").pattern("wsw").pattern(" w ").define(Character.valueOf('w'), IETags.copperWire).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_copper_ingot", MiscRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).save(out, this.toRL(this.toPath(wireCoilCopper)));
        ItemLike wireCoilElectrum = (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.ELECTRUM);
        this.shapedMisc(wireCoilElectrum, 4).pattern(" w ").pattern("wsw").pattern(" w ").define(Character.valueOf('w'), IETags.electrumWire).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_electrum_ingot", MiscRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.ELECTRUM).ingot)).save(out, this.toRL(this.toPath(wireCoilElectrum)));
        ItemLike wireCoilSteel = (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.STEEL);
        this.shapedMisc(wireCoilSteel, 4).pattern(" w ").pattern("asa").pattern(" w ").define(Character.valueOf('w'), IETags.steelWire).define(Character.valueOf('a'), IETags.aluminumWire).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_steel_ingot", MiscRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).save(new WrappingRecipeOutput<ShapedRecipe>(out, r -> new TurnAndCopyRecipe(r).allowQuarterTurn()), this.toRL(this.toPath(wireCoilSteel)));
        ItemLike wireCoilRope = (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.STRUCTURE_ROPE);
        this.shapedMisc(wireCoilRope, 4).pattern(" w ").pattern("wsw").pattern(" w ").define(Character.valueOf('w'), (ItemLike)IEItems.Ingredients.HEMP_FIBER).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_hemp_fiber", MiscRecipes.has((ItemLike)IEItems.Ingredients.HEMP_FIBER)).save(out, this.toRL(this.toPath(wireCoilRope)));
        ItemLike wireCoilStructure = (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.STRUCTURE_STEEL);
        this.shapedMisc(wireCoilStructure, 4).pattern(" w ").pattern("wsw").pattern(" w ").define(Character.valueOf('w'), (ItemLike)IEItems.Ingredients.WIRE_STEEL).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_steel_ingot", MiscRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot)).save(out, this.toRL(this.toPath(wireCoilStructure)));
        this.addCornerStraightMiddle((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER_INSULATED), 4, this.makeIngredient((TagKey<Item>)IETags.fabricHemp), this.makeIngredient((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER)), this.makeIngredient((TagKey<Item>)IETags.fabricHemp), MiscRecipes.has((ItemLike)((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER))), out);
        this.addCornerStraightMiddle((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.ELECTRUM_INSULATED), 4, this.makeIngredient((TagKey<Item>)IETags.fabricHemp), this.makeIngredient((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.ELECTRUM)), this.makeIngredient((TagKey<Item>)IETags.fabricHemp), MiscRecipes.has((ItemLike)((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.ELECTRUM))), out);
        ItemLike wireCoilRedstone = (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.REDSTONE);
        this.shapedMisc(wireCoilRedstone, 4).pattern(" w ").pattern("asa").pattern(" w ").define(Character.valueOf('w'), IETags.aluminumWire).define(Character.valueOf('a'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN).unlockedBy("has_aluminum_ingot", MiscRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).ingot)).save(new WrappingRecipeOutput<ShapedRecipe>(out, r -> new TurnAndCopyRecipe(r).allowQuarterTurn()), this.toRL(this.toPath(wireCoilRedstone)));
        this.shapelessMisc(wireCoilCopper).requires((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER_INSULATED)).requires((ItemLike)IEItems.Tools.WIRECUTTER).unlockedBy("has_copper_coil", MiscRecipes.has((ItemLike)((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER)))).save(out, this.toRL("strip_lv"));
        this.shapelessMisc(wireCoilElectrum).requires((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.ELECTRUM_INSULATED)).requires((ItemLike)IEItems.Tools.WIRECUTTER).unlockedBy("has_electrum_coil", MiscRecipes.has((ItemLike)((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.ELECTRUM)))).save(out, this.toRL("strip_mv"));
        this.shapedMisc((ItemLike)IEItems.Misc.JERRYCAN).pattern(" ii").pattern("ibb").pattern("ibb").define(Character.valueOf('i'), IETags.getTagsFor((EnumMetals)EnumMetals.IRON).plate).define(Character.valueOf('b'), (ItemLike)Items.BUCKET).unlockedBy("has_bucket", MiscRecipes.has((ItemLike)Items.BUCKET)).save(out, this.toRL("jerrycan"));
        this.shapedMisc((ItemLike)IEItems.Misc.POWERPACK).pattern("srs").pattern("clc").pattern("wrw").define(Character.valueOf('s'), IETags.treatedStick).define(Character.valueOf('l'), Tags.Items.LEATHERS).define(Character.valueOf('r'), IETags.steelRod).define(Character.valueOf('w'), (ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER_INSULATED)).define(Character.valueOf('c'), (ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"LV", (boolean)false)).unlockedBy("has_leather", MiscRecipes.has((ItemLike)Items.LEATHER)).unlockedBy("has_copper_ingot", MiscRecipes.has((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.MetalDevices.CAPACITOR_LV), MiscRecipes.has((ItemLike)IEBlocks.MetalDevices.CAPACITOR_LV)).unlockedBy("has_" + this.toPath((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"LV", (boolean)false)), MiscRecipes.has((ItemLike)IEBlocks.Connectors.getEnergyConnector((String)"LV", (boolean)false))).save(out, this.toRL(this.toPath((ItemLike)IEItems.Misc.POWERPACK)));
        this.shapedMisc((ItemLike)IEItems.Misc.MAINTENANCE_KIT).pattern("sc ").pattern("fff").define(Character.valueOf('c'), (ItemLike)IEItems.Tools.WIRECUTTER).define(Character.valueOf('s'), (ItemLike)IEItems.Tools.SCREWDRIVER).define(Character.valueOf('f'), IETags.fabricHemp).unlockedBy("has_" + this.toPath((ItemLike)IEItems.Tools.WIRECUTTER), MiscRecipes.has((ItemLike)IEItems.Tools.WIRECUTTER)).save(new WrappingRecipeOutput<ShapedRecipe>(out, NoContainersShapedRecipe::new), this.toRL(this.toPath((ItemLike)IEItems.Misc.MAINTENANCE_KIT)));
        this.shapedMisc((ItemLike)IEItems.Misc.SHIELD).pattern("sws").pattern("scs").pattern("sws").define(Character.valueOf('s'), IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).plate).define(Character.valueOf('w'), IETags.getItemTag((TagKey)IETags.treatedWood)).define(Character.valueOf('c'), (ItemLike)Items.SHIELD).unlockedBy("has_shield", MiscRecipes.has((ItemLike)Items.SHIELD)).save(out, this.toRL(this.toPath((ItemLike)IEItems.Misc.SHIELD)));
        this.shapedMisc((ItemLike)IEItems.Misc.FLUORESCENT_TUBE).pattern("GeG").pattern("GgG").pattern("GgG").define(Character.valueOf('g'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('e'), (ItemLike)IEItems.Misc.GRAPHITE_ELECTRODE).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).unlockedBy("has_electrode", MiscRecipes.has((ItemLike)IEItems.Misc.GRAPHITE_ELECTRODE)).save(out, this.toRL(this.toPath((ItemLike)IEItems.Misc.FLUORESCENT_TUBE)));
        this.shapedMisc((ItemLike)IEItems.Misc.EARMUFFS).pattern(" S ").pattern("S S").pattern("W W").define(Character.valueOf('S'), IETags.ironRod).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy("has_iron_rod", MiscRecipes.has((TagKey)IETags.ironRod)).save(out, this.toRL(this.toPath((ItemLike)IEItems.Misc.EARMUFFS)));
        this.shapelessMisc((ItemLike)IEItems.Misc.FERTILIZER, 3).requires(IETags.saltpeterDust).requires(IETags.slag).requires(IETags.sulfurDust).requires(new Ingredient((ICustomIngredient)new IngredientFluidStack(FluidTags.WATER, 1000))).unlockedBy("has_saltpeter", MiscRecipes.has((TagKey)IETags.saltpeterDust)).unlockedBy("has_sulfur", MiscRecipes.has((TagKey)IETags.sulfurDust)).unlockedBy("has_slag", MiscRecipes.has((TagKey)IETags.slag)).save(out, this.toRL(this.toPath((ItemLike)IEItems.Misc.FERTILIZER)));
        this.shapedMisc((ItemLike)IEItems.Minecarts.CART_WOODEN_CRATE).pattern("B").pattern("C").define(Character.valueOf('B'), (ItemLike)IEBlocks.WoodenDevices.CRATE).define(Character.valueOf('C'), (ItemLike)Items.MINECART).unlockedBy("has_minecart", MiscRecipes.has((ItemLike)Items.MINECART)).save(out, this.toRL(this.toPath((ItemLike)IEItems.Minecarts.CART_WOODEN_CRATE)));
        this.shapedMisc((ItemLike)IEItems.Minecarts.CART_REINFORCED_CRATE).pattern("B").pattern("C").define(Character.valueOf('B'), (ItemLike)IEBlocks.WoodenDevices.REINFORCED_CRATE).define(Character.valueOf('C'), (ItemLike)Items.MINECART).unlockedBy("has_minecart", MiscRecipes.has((ItemLike)Items.MINECART)).save(out, this.toRL(this.toPath((ItemLike)IEItems.Minecarts.CART_REINFORCED_CRATE)));
        this.shapedMisc((ItemLike)IEItems.Minecarts.CART_WOODEN_BARREL).pattern("B").pattern("C").define(Character.valueOf('B'), (ItemLike)IEBlocks.WoodenDevices.WOODEN_BARREL).define(Character.valueOf('C'), (ItemLike)Items.MINECART).unlockedBy("has_minecart", MiscRecipes.has((ItemLike)Items.MINECART)).save(out, this.toRL(this.toPath((ItemLike)IEItems.Minecarts.CART_WOODEN_BARREL)));
        this.shapedMisc((ItemLike)IEItems.Minecarts.CART_METAL_BARREL).pattern("B").pattern("C").define(Character.valueOf('B'), (ItemLike)IEBlocks.MetalDevices.BARREL).define(Character.valueOf('C'), (ItemLike)Items.MINECART).unlockedBy("has_minecart", MiscRecipes.has((ItemLike)Items.MINECART)).save(out, this.toRL(this.toPath((ItemLike)IEItems.Minecarts.CART_METAL_BARREL)));
        this.shapelessMisc((ItemLike)IEBlocks.StoneDecoration.GRIT_SAND, 5).requires(Ingredient.of((TagKey)Tags.Items.GRAVELS), 1).requires(Ingredient.of((TagKey)Tags.Items.SANDS_COLORLESS), 4).unlockedBy("has_sand", MiscRecipes.has((TagKey)Tags.Items.GRAVELS)).unlockedBy("has_gravel", MiscRecipes.has((TagKey)Tags.Items.SANDS_COLORLESS)).save(out, this.toRL("grit_sand"));
        this.shapelessMisc((ItemLike)Items.WHITE_DYE, 16).requires(new Ingredient((ICustomIngredient)new IngredientFluidStack(IETags.fluidEthanol, 1000))).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), 3).requires(IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).dust).unlockedBy("has_ethanol", MiscRecipes.has((ItemLike)IEFluids.ETHANOL.getBucket())).save(out, this.toRL("lead_white"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.LEAD).nugget), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.RED_DYE, (float)0.1f, (int)200).unlockedBy("has_lead", MiscRecipes.has((ItemLike)((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.LEAD)))).save(out, this.toRL("smelting/lead_red"));
        this.shapedMisc((ItemLike)Items.TINTED_GLASS, 3).pattern("LAL").pattern("AGA").pattern("LAL").define(Character.valueOf('L'), (ItemLike)IEItems.Ingredients.WIRE_LEAD).define(Character.valueOf('A'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS_COLORLESS).unlockedBy("has_amethyst", MiscRecipes.has((ItemLike)Items.AMETHYST_SHARD)).unlockedBy("has_lead", MiscRecipes.has((ItemLike)((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.LEAD)))).save(out, this.toRL("tinted_glass_lead_wire"));
    }

    private void buildGeneratedList(RecipeOutput out, ResourceLocation name) {
        out.accept(name, (Recipe)GeneratedListRecipe.from((ResourceLocation)name), null);
    }
}

