/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class RailgunShotEntity
extends IEProjectileEntity {
    private ItemStack ammo = ItemStack.EMPTY;
    private static final EntityDataAccessor<ItemStack> dataMarker_ammo = SynchedEntityData.defineId(RailgunShotEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private RailgunHandler.IRailgunProjectile ammoProperties;

    public RailgunShotEntity(EntityType<RailgunShotEntity> type, Level world) {
        super(type, world);
        this.pickup = AbstractArrow.Pickup.ALLOWED;
    }

    public RailgunShotEntity(Level world, @Nonnull LivingEntity living, float velocity, float accuracy, ItemStack ammo) {
        super((EntityType<? extends IEProjectileEntity>)((EntityType)IEEntityTypes.RAILGUN_SHOT.get()), world, living, velocity, accuracy);
        this.ammo = ammo;
        this.setAmmoSynced();
        this.pickup = AbstractArrow.Pickup.ALLOWED;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(dataMarker_ammo, (Object)ItemStack.EMPTY);
    }

    @Override
    @Nonnull
    protected ItemStack getPickupItem() {
        return this.ammo;
    }

    @Nonnull
    protected ItemStack getDefaultPickupItem() {
        return IEItems.Ingredients.STICK_STEEL.asItem().getDefaultInstance();
    }

    public void setAmmoSynced() {
        if (!this.getAmmo().isEmpty()) {
            this.entityData.set(dataMarker_ammo, (Object)this.getAmmo());
        }
    }

    public ItemStack getAmmoSynced() {
        return (ItemStack)this.entityData.get(dataMarker_ammo);
    }

    public ItemStack getAmmo() {
        return this.ammo;
    }

    public RailgunHandler.IRailgunProjectile getProjectileProperties() {
        if (this.ammoProperties == null && !this.ammo.isEmpty()) {
            this.ammoProperties = RailgunHandler.getProjectile(this.ammo);
        }
        return this.ammoProperties;
    }

    @Override
    public double getDefaultGravity() {
        return 0.005 * (this.getProjectileProperties() != null ? this.getProjectileProperties().getGravity() : 1.0);
    }

    @Override
    public int getMaxTicksInGround() {
        return 500;
    }

    public void baseTick() {
        if (this.getAmmo().isEmpty() && this.level().isClientSide) {
            this.ammo = this.getAmmoSynced();
        }
        super.baseTick();
    }

    protected void onHitEntity(EntityHitResult result) {
        RailgunHandler.IRailgunProjectile projectileProperties;
        if (!this.level().isClientSide && !this.getAmmo().isEmpty() && (projectileProperties = this.getProjectileProperties()) != null) {
            Entity shooter = this.getOwner();
            UUID shooterUuid = shooter != null ? shooter.getUUID() : null;
            Entity hit = result.getEntity();
            double damage = projectileProperties.getDamage(this.level(), hit, shooterUuid, (Entity)this);
            DamageSource source = projectileProperties.getDamageSource(this.level(), hit, shooterUuid, (Entity)this);
            if (source == null) {
                source = IEDamageSources.causeRailgunDamage(this, shooter);
            }
            if (shooter instanceof LivingEntity) {
                LivingEntity livingShooter = (LivingEntity)shooter;
                livingShooter.setLastHurtMob(hit);
            }
            hit.hurt(source, (float)(damage * (Double)IEServerConfig.TOOLS.railgun_damage.get()));
            projectileProperties.onHitTarget(this.level(), (HitResult)result, shooterUuid, (Entity)this);
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        RailgunHandler.IRailgunProjectile projectileProperties;
        super.onHitBlock(result);
        if (!this.level().isClientSide && !this.getAmmo().isEmpty() && (projectileProperties = this.getProjectileProperties()) != null) {
            Entity owner = this.getOwner();
            UUID shooterUuid = owner != null ? owner.getUUID() : null;
            double breakRoll = this.random.nextDouble();
            if (breakRoll <= this.getProjectileProperties().getBreakChance(shooterUuid, this.ammo)) {
                this.discard();
            }
            projectileProperties.onHitTarget(this.level(), (HitResult)result, shooterUuid, (Entity)this);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (!this.ammo.isEmpty()) {
            nbt.put("ammo", this.ammo.save((HolderLookup.Provider)this.level().registryAccess()));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.ammo = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)nbt.getCompound("ammo"));
    }
}

