/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.DropConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ExtractConveyor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.bullets.IEBullets;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItemSubPredicates;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.world.Villages;
import blusunrize.immersiveengineering.data.AdvancementBuilder;
import com.mojang.datafixers.util.Unit;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.advancements.critereon.TradeTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class Advancements
extends AdvancementProvider {
    public Advancements(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper exFileHelper) {
        super(output, provider, exFileHelper, List.of(Advancements::registerAdvancements));
    }

    private static void registerAdvancements(HolderLookup.Provider lookup, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
        AdvancementBuilder.setPage("main");
        AdvancementHolder rtfm = AdvancementBuilder.root("block/wooden_decoration/treated_wood").getItem((ItemLike)IEItems.Tools.MANUAL).save(consumer);
        AdvancementHolder conveyor = AdvancementBuilder.child("place_conveyor", rtfm).icon((ItemLike)IEBlocks.MetalDevices.CONVEYORS.get(BasicConveyor.TYPE)).orRequirements().placeBlocks(IEBlocks.MetalDevices.CONVEYORS.values()).save(consumer);
        AdvancementHolder dropConveyor = AdvancementBuilder.child("craft_drop_conveyor", conveyor).getItem((ItemLike)IEBlocks.MetalDevices.CONVEYORS.get(DropConveyor.TYPE)).save(consumer);
        AdvancementHolder chute = AdvancementBuilder.child("chute_bonk", dropConveyor).icon((ItemLike)IEBlocks.MetalDevices.CHUTES.get(EnumMetals.IRON)).codeTriggered().save(consumer);
        AdvancementHolder extractConveyor = AdvancementBuilder.child("craft_extract_conveyor", conveyor).getItem((ItemLike)IEBlocks.MetalDevices.CONVEYORS.get(ExtractConveyor.TYPE)).save(consumer);
        AdvancementHolder router = AdvancementBuilder.child("craft_router", extractConveyor).getItem((ItemLike)IEBlocks.WoodenDevices.SORTER).save(consumer);
        AdvancementHolder batcher = AdvancementBuilder.child("craft_batcher", router).goal().getItem((ItemLike)IEBlocks.WoodenDevices.ITEM_BATCHER).save(consumer);
        AdvancementHolder wire = AdvancementBuilder.child("connect_wire", rtfm).icon((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER)).codeTriggered().save(consumer);
        AdvancementHolder dynamo = AdvancementBuilder.child("place_dynamo", wire).placeBlock(IEBlocks.MetalDevices.DYNAMO).save(consumer);
        AdvancementHolder windmill = AdvancementBuilder.child("place_windmill", dynamo).placeBlock(IEBlocks.WoodenDevices.WINDMILL).save(consumer);
        AdvancementHolder heater = AdvancementBuilder.child("craft_heater", wire).getItem((ItemLike)IEBlocks.MetalDevices.FURNACE_HEATER).save(consumer);
        AdvancementHolder pump = AdvancementBuilder.child("craft_pump", heater).getItem((ItemLike)IEBlocks.MetalDevices.FLUID_PUMP).save(consumer);
        AdvancementHolder cloche = AdvancementBuilder.child("chorus_cloche", pump).icon((ItemLike)IEBlocks.MetalDevices.CLOCHE).codeTriggered().save(consumer);
        AdvancementHolder hammer = AdvancementBuilder.child("craft_hammer", rtfm).getItem((ItemLike)IEItems.Tools.HAMMER).save(consumer);
        AdvancementHolder cokeoven = AdvancementBuilder.child("mb_cokeoven", hammer).multiblock(IEMultiblocks.COKE_OVEN).save(consumer);
        AdvancementHolder blastfurnace = AdvancementBuilder.child("mb_blastfurnace", cokeoven).multiblock(IEMultiblocks.BLAST_FURNACE).save(consumer);
        AdvancementHolder steel = AdvancementBuilder.child("make_steel", blastfurnace).goal().getItem((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.STEEL)).save(consumer);
        AdvancementHolder creosote = AdvancementBuilder.child("creosote", cokeoven).getItem((ItemLike)IEFluids.CREOSOTE.getBucket()).save(consumer);
        AdvancementHolder treatedWood = AdvancementBuilder.child("craft_treatedwood", creosote).getItem((ItemLike)IEBlocks.WoodenDecoration.TREATED_WOOD.get(TreatedWoodStyles.HORIZONTAL)).save(consumer);
        AdvancementHolder workbench = AdvancementBuilder.child("craft_workbench", treatedWood).getItem((ItemLike)IEBlocks.WoodenDevices.WORKBENCH).save(consumer);
        AdvancementHolder villagers = AdvancementBuilder.child("villager", rtfm).icon((ItemLike)Items.EMERALD).orRequirements().talkToVillagers(Villages.ENGINEER, Villages.MACHINIST, Villages.ELECTRICIAN, Villages.OUTFITTER, Villages.GUNSMITH).save(consumer);
        AdvancementHolder shaderbag = AdvancementBuilder.child("buy_shaderbag", villagers).icon((ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.COMMON)).addCriterion("buy_shaderbag", Advancements.tradedForItem(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.COMMON), (ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.UNCOMMON), (ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.RARE)}))).save(consumer);
        DataComponentPredicate oreMapPredicate = DataComponentPredicate.builder().expect(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.immersiveengineering.map_orevein")).build();
        AdvancementHolder oremap = AdvancementBuilder.child("buy_oremap", villagers).icon((ItemLike)Items.FILLED_MAP).addCriterion("buy_oremap", Advancements.tradedForItem(ItemPredicate.Builder.item().of(new ItemLike[]{Items.FILLED_MAP}).hasComponents(oreMapPredicate))).save(consumer);
        AdvancementHolder illager = AdvancementBuilder.child("kill_illager", villagers).goal().icon(Raid.getLeaderBannerInstance((HolderGetter)lookup.lookupOrThrow(Registries.BANNER_PATTERN))).orRequirements().addCriterion("revolver_kill", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityTypeTags.RAIDERS), (DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_PROJECTILE)).source(EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().of(new ItemLike[]{IEItems.Weapons.REVOLVER.asItem()})).build())))).addCriterion("railgun_kill", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityTypeTags.RAIDERS), (DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_PROJECTILE)).source(EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().of(new ItemLike[]{IEItems.Weapons.RAILGUN.asItem()})).build())))).addCriterion("chemthrower_kill", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityTypeTags.RAIDERS), (DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().source(EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().of(new ItemLike[]{IEItems.Weapons.CHEMTHROWER.asItem()})).build())))).loot("shader_rare").save(consumer);
        AdvancementHolder friedbird = AdvancementBuilder.child("secret_friedbird", wire).challenge().hidden().icon((ItemLike)IEItems.Misc.ICON_FRIED).codeTriggered().loot("shader_masterwork").save(consumer);
        AdvancementHolder luckofthedraw = AdvancementBuilder.child("secret_luckofthedraw", shaderbag).challenge().hidden().icon((ItemLike)IEItems.Misc.ICON_LUCKY).codeTriggered().loot("shader_masterwork").save(consumer);
        AdvancementHolder achtung = AdvancementBuilder.child("secret_achtung", rtfm).challenge().hidden().icon((ItemLike)IEItems.Misc.ICON_ACHTUNG).codeTriggered().loot("shader_masterwork").save(consumer);
        AdvancementHolder snake = AdvancementBuilder.child("secret_snake", treatedWood).challenge().hidden().icon((ItemLike)IEItems.Misc.ICON_SNAKE).codeTriggered().loot("shader_masterwork").save(consumer);
        AdvancementBuilder.setPage("multiblocks");
        AdvancementHolder multiblocks = AdvancementBuilder.root("block/wooden_decoration/treated_wood").quiet().hasItems((ItemLike)IEItems.Metals.INGOTS.get(EnumMetals.STEEL)).icon((ItemLike)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(MetalScaffoldingType.STANDARD)).save(consumer);
        AdvancementHolder improvedblastfurnace = AdvancementBuilder.child("mb_improvedblastfurnace", multiblocks).multiblock(IEMultiblocks.ADVANCED_BLAST_FURNACE).save(consumer);
        AdvancementHolder arcfurnace = AdvancementBuilder.child("mb_arcfurnace", improvedblastfurnace).challenge().multiblock(IEMultiblocks.ARC_FURNACE).save(consumer);
        AdvancementHolder metalpress = AdvancementBuilder.child("mb_metalpress", multiblocks).multiblock(IEMultiblocks.METAL_PRESS).save(consumer);
        AdvancementHolder sheetmetal = AdvancementBuilder.child("craft_sheetmetal", metalpress).getItem((ItemLike)IEBlocks.Metals.SHEETMETAL.get(EnumMetals.IRON)).save(consumer);
        AdvancementHolder silo = AdvancementBuilder.child("mb_silo", sheetmetal).multiblock(IEMultiblocks.SILO).save(consumer);
        AdvancementHolder tank = AdvancementBuilder.child("mb_tank", sheetmetal).multiblock(IEMultiblocks.SHEETMETAL_TANK).save(consumer);
        AdvancementHolder squeezer = AdvancementBuilder.child("mb_squeezer", multiblocks).multiblock(IEMultiblocks.SQUEEZER).save(consumer);
        AdvancementHolder fermenter = AdvancementBuilder.child("mb_fermenter", squeezer).multiblock(IEMultiblocks.FERMENTER).save(consumer);
        AdvancementHolder mixer = AdvancementBuilder.child("mb_mixer", fermenter).multiblock(IEMultiblocks.MIXER).save(consumer);
        AdvancementHolder concrete = AdvancementBuilder.child("liquid_concrete", mixer).icon((ItemLike)IEFluids.CONCRETE.getBucket()).addCriterion("concrete_feet", EffectsChangedTrigger.TriggerInstance.hasEffects((MobEffectsPredicate.Builder)MobEffectsPredicate.Builder.effects().and(IEPotions.CONCRETE_FEET))).save(consumer);
        AdvancementHolder refinery = AdvancementBuilder.child("mb_refinery", fermenter).multiblock(IEMultiblocks.REFINERY).save(consumer);
        AdvancementHolder plastic = AdvancementBuilder.child("craft_duroplast", refinery).goal().getItem((ItemLike)IEItems.Ingredients.DUROPLAST_PLATE).save(consumer);
        AdvancementHolder dieselgen = AdvancementBuilder.child("mb_dieselgen", refinery).challenge().multiblock(IEMultiblocks.DIESEL_GENERATOR).save(consumer);
        AdvancementHolder crusher = AdvancementBuilder.child("mb_crusher", multiblocks).goal().multiblock(IEMultiblocks.CRUSHER).save(consumer);
        AdvancementHolder excavator = AdvancementBuilder.child("mb_excavator", crusher).challenge().multiblock(IEMultiblocks.EXCAVATOR).save(consumer);
        AdvancementBuilder.setPage("tools");
        AdvancementHolder tools = AdvancementBuilder.root("block/wooden_decoration/treated_wood").quiet().getItem((ItemLike)IEBlocks.WoodenDevices.WORKBENCH).save(consumer);
        AdvancementHolder revolver = AdvancementBuilder.child("craft_revolver", tools).getItem((ItemLike)IEItems.Weapons.REVOLVER).save(consumer);
        ItemStack upgradedRevolver = new ItemStack((ItemLike)IEItems.Weapons.REVOLVER);
        upgradedRevolver.set((Supplier)IEDataComponents.UPGRADE_DATA, (Object)new UpgradeData(List.of(new UpgradeData.UpgradeEntry(UpgradeEffect.BULLETS, (Object)6), new UpgradeData.UpgradeEntry(UpgradeEffect.ELECTRO, (Object)Unit.INSTANCE))));
        AdvancementHolder upgradeRevolver = AdvancementBuilder.child("upgrade_revolver", revolver).challenge().icon(upgradedRevolver).codeTriggered().loot("shader_rare").save(consumer);
        AdvancementHolder wolfpack = AdvancementBuilder.child("craft_wolfpack", revolver).hidden().getItem((ItemLike)BulletHandler.getBulletItem((ResourceLocation)IEBullets.WOLFPACK)).save(consumer);
        AdvancementHolder drill = AdvancementBuilder.child("craft_drill", tools).getItem((ItemLike)IEItems.Tools.DRILL).save(consumer);
        ItemStack upgradedDrill = new ItemStack((ItemLike)IEItems.Tools.DRILL);
        upgradedDrill.set((Supplier)IEDataComponents.UPGRADE_DATA, (Object)new UpgradeData(List.of(new UpgradeData.UpgradeEntry(UpgradeEffect.DAMAGE, (Object)3), new UpgradeData.UpgradeEntry(UpgradeEffect.WATERPROOF, (Object)Unit.INSTANCE), new UpgradeData.UpgradeEntry(UpgradeEffect.OILED, (Object)Unit.INSTANCE), new UpgradeData.UpgradeEntry(UpgradeEffect.SPEED, (Object)Float.valueOf(6.0f)))));
        DrillItem.setHeadStatic((ItemStack)upgradedDrill, (ItemStack)new ItemStack((ItemLike)IEItems.Tools.DRILLHEAD_STEEL));
        AdvancementHolder upgradeDrill = AdvancementBuilder.child("upgrade_drill", drill).challenge().icon(upgradedDrill).codeTriggered().loot("shader_rare").save(consumer);
        AdvancementHolder buzzsaw = AdvancementBuilder.child("craft_buzzsaw", tools).getItem((ItemLike)IEItems.Tools.BUZZSAW).save(consumer);
        ItemStack upgradedBuzzsaw = new ItemStack((ItemLike)IEItems.Tools.BUZZSAW);
        upgradedBuzzsaw.set((Supplier)IEDataComponents.UPGRADE_DATA, (Object)new UpgradeData(List.of(new UpgradeData.UpgradeEntry(UpgradeEffect.OILED, (Object)Unit.INSTANCE), new UpgradeData.UpgradeEntry(UpgradeEffect.SPAREBLADES, (Object)Unit.INSTANCE))));
        BuzzsawItem.setSawblade((ItemStack)upgradedBuzzsaw, (ItemStack)new ItemStack((ItemLike)IEItems.Tools.SAWBLADE), (int)0);
        BuzzsawItem.setSawblade((ItemStack)upgradedBuzzsaw, (ItemStack)new ItemStack((ItemLike)IEItems.Tools.SAWBLADE), (int)1);
        BuzzsawItem.setSawblade((ItemStack)upgradedBuzzsaw, (ItemStack)new ItemStack((ItemLike)IEItems.Tools.SAWBLADE), (int)2);
        AdvancementHolder upgradeBuzzsaw = AdvancementBuilder.child("upgrade_buzzsaw", buzzsaw).challenge().icon(upgradedBuzzsaw).codeTriggered().loot("shader_rare").save(consumer);
        AdvancementHolder skyhook = AdvancementBuilder.child("skyhook_distance", tools).icon((ItemLike)IEItems.Misc.SKYHOOK).codeTriggered().save(consumer);
        AdvancementHolder chemthrower = AdvancementBuilder.child("craft_chemthrower", tools).getItem((ItemLike)IEItems.Weapons.CHEMTHROWER).save(consumer);
        AdvancementHolder railgun = AdvancementBuilder.child("craft_railgun", tools).getItem((ItemLike)IEItems.Weapons.RAILGUN).save(consumer);
        ItemStack upgradedRailgun = new ItemStack((ItemLike)IEItems.Weapons.RAILGUN);
        upgradedRailgun.set((Supplier)IEDataComponents.UPGRADE_DATA, (Object)new UpgradeData(List.of(new UpgradeData.UpgradeEntry(UpgradeEffect.SCOPE, (Object)Unit.INSTANCE), new UpgradeData.UpgradeEntry(UpgradeEffect.SPEED, (Object)Float.valueOf(1.0f)))));
        AdvancementHolder upgradeRailgun = AdvancementBuilder.child("upgrade_railgun", railgun).challenge().icon(upgradedRailgun).codeTriggered().loot("shader_rare").save(consumer);
        AdvancementHolder powerpack = AdvancementBuilder.child("craft_powerpack", tools).getItem((ItemLike)IEItems.Misc.POWERPACK).save(consumer);
        ItemStack upgradedPowerpack = new ItemStack((ItemLike)IEItems.Misc.POWERPACK);
        upgradedPowerpack.set((Supplier)IEDataComponents.UPGRADE_DATA, (Object)new UpgradeData(List.of(new UpgradeData.UpgradeEntry(UpgradeEffect.ANTENNA, (Object)Unit.INSTANCE), new UpgradeData.UpgradeEntry(UpgradeEffect.INDUCTION, (Object)Unit.INSTANCE))));
        AdvancementHolder upgradePowerpack = AdvancementBuilder.child("upgrade_powerpack", powerpack).challenge().icon(upgradedPowerpack).codeTriggered().loot("shader_rare").save(consumer);
        AdvancementHolder birthdayparty = AdvancementBuilder.child("secret_birthdayparty", upgradeRevolver).challenge().hidden().icon((ItemLike)IEItems.Misc.ICON_BIRTHDAY).codeTriggered().loot("shader_masterwork").save(consumer);
        AdvancementHolder drillbreak = AdvancementBuilder.child("secret_drillbreak", upgradeDrill).challenge().hidden().icon((ItemLike)IEItems.Misc.ICON_DRILLBREAK).codeTriggered().loot("shader_masterwork").save(consumer);
        AdvancementHolder ravenholm = AdvancementBuilder.child("secret_ravenholm", upgradeRailgun).challenge().hidden().icon((ItemLike)IEItems.Misc.ICON_RAVENHOLM).codeTriggered().loot("shader_masterwork").save(consumer);
        AdvancementHolder bttf = AdvancementBuilder.child("secret_bttf", upgradePowerpack).challenge().hidden().icon((ItemLike)IEItems.Misc.ICON_BTTF).codeTriggered().loot("shader_masterwork").save(consumer);
        AdvancementBuilder.setPage("manual");
        AdvancementHolder manualUnlocks = AdvancementBuilder.hiddenRoot().codeTriggered().save(consumer);
        AdvancementBuilder.child("automatons", manualUnlocks).hasItemWithPredicate((ItemLike)IEItems.Misc.BLUEPRINT, (ItemSubPredicate.Type)IEItemSubPredicates.BLUEPRINT.get(), new IEItemSubPredicates.ItemBlueprintPredicate("automatons")).saveForManual(consumer);
        AdvancementBuilder.child("resonanz", manualUnlocks).hasItems(new ItemLike[]{Items.ECHO_SHARD}).saveForManual(consumer);
    }

    private static Path createPath(Path pathIn, AdvancementHolder advancementIn) {
        return pathIn.resolve("data/" + advancementIn.id().getNamespace() + "/advancements/" + advancementIn.id().getPath() + ".json");
    }

    private static Criterion<TradeTrigger.TriggerInstance> tradedForItem(ItemPredicate.Builder builder) {
        return CriteriaTriggers.TRADE.createCriterion((CriterionTriggerInstance)new TradeTrigger.TriggerInstance(Optional.empty(), Optional.empty(), Optional.of(builder.build())));
    }
}

