/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class PotionBucketItem
extends IEBaseItem {
    public PotionBucketItem() {
        super(new Item.Properties().stacksTo(1).component(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY));
    }

    public static ItemStack forPotion(Holder<Potion> type) {
        if (type == Potions.WATER || type == null) {
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        ItemStack result = new ItemStack(IEItems.Misc.POTION_BUCKET);
        result.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(type));
        return result;
    }

    @Override
    public void fillCreativeTab(CreativeModeTab.Output out) {
        List<Holder.Reference> sortedPotions = BuiltInRegistries.POTION.holders().sorted(Comparator.comparing(e -> PotionBucketItem.getPotionName(Optional.of(e)).getString())).toList();
        for (Holder.Reference p : sortedPotions) {
            if (p == Potions.WATER) continue;
            out.accept(PotionBucketItem.forPotion((Holder<Potion>)p));
        }
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        registrar.register(Capabilities.FluidHandler.ITEM, (stack, $) -> new FluidHandler((ItemStack)stack));
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        return Component.translatable((String)"item.immersiveengineering.potion_bucket", (Object[])new Object[]{PotionBucketItem.getPotionName(((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).potion())});
    }

    private static Component getPotionName(Optional<Holder<Potion>> potion) {
        String potionKey = Potion.getName(potion, (String)(Items.POTION.getDescriptionId() + ".effect."));
        return Component.translatable((String)potionKey);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext ctx, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).addPotionTooltip(tooltip::add, 1.0f, ctx.tickRate());
    }

    private static class FluidHandler
    implements IFluidHandlerItem {
        private final ItemStack stack;
        private boolean empty = false;

        private FluidHandler(ItemStack stack) {
            this.stack = stack;
        }

        private FluidStack getFluid() {
            if (this.empty) {
                return FluidStack.EMPTY;
            }
            return PotionFluid.getFluidStackForType(((PotionContents)this.stack.get(DataComponents.POTION_CONTENTS)).potion(), 1000, PotionFluid.PotionBottleType.REGULAR);
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.empty ? new ItemStack((ItemLike)Items.BUCKET) : this.stack;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (tank == 0) {
                return this.getFluid();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? 1000 : 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack fluid = this.getFluid();
            if (!FluidStack.isSameFluidSameComponents((FluidStack)fluid, (FluidStack)resource)) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.empty || this.stack.getCount() > 1 || maxDrain < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack potion = this.getFluid();
            if (action.execute()) {
                this.empty = true;
            }
            return potion;
        }
    }
}

