/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManual;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ShaderManualElement
extends SpecialManualElements {
    final ShaderRegistry.ShaderRegistryEntry shader;
    ItemStack shaderItem;
    ItemStack[] exampleItems;
    IngredientWithSize replicationCost;
    int example = 0;
    boolean unlocked;
    MutableComponent name;
    MutableComponent text;

    public ShaderManualElement(ManualInstance manual, ShaderRegistry.ShaderRegistryEntry shader) {
        super(manual);
        this.shader = shader;
    }

    @Override
    public int getPixelsTaken() {
        return 47;
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> buttons) {
        LocalPlayer player = ManualUtils.mc().player;
        UUID uuid = player.getUUID();
        this.unlocked = ShaderRegistry.receivedShaders.get((Object)uuid).contains(this.shader.getName());
        this.shaderItem = ShaderRegistry.makeShaderStack(this.shader.name);
        this.replicationCost = this.shader.replicationCost.get();
        if (this.unlocked) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack is : ShaderRegistry.itemExamples) {
                ItemStack s = is.copy();
                CapabilityShader.ShaderWrapper wrapper = (CapabilityShader.ShaderWrapper)s.getCapability(CapabilityShader.ITEM);
                if (wrapper == null) continue;
                wrapper.setShader(this.shader.name);
                list.add(s);
            }
            this.exampleItems = list.toArray(new ItemStack[0]);
            this.example = 0;
            if (this.exampleItems.length > 1) {
                buttons.add(new GuiButtonManualNavigation(gui, x + 50, y, 10, 16, 0, btn -> {
                    --this.example;
                    if (this.example < 0) {
                        this.example = this.exampleItems.length - 1;
                    }
                }));
                buttons.add(new GuiButtonManualNavigation(gui, x + 100, y, 10, 16, 1, btn -> {
                    this.example = (this.example + 1) % this.exampleItems.length;
                }));
            }
        } else {
            this.exampleItems = null;
        }
        this.name = TextUtils.applyFormat(this.shaderItem.getHoverName(), ChatFormatting.BOLD);
        MutableComponent textAssembly = Component.literal((String)"");
        textAssembly.append((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.shader.level"), ChatFormatting.BOLD));
        textAssembly.append((Component)Component.translatable((String)("desc.immersiveengineering.info.shader.rarity." + this.shader.rarity.name().toLowerCase(Locale.US))));
        if (this.unlocked) {
            String details;
            String set = this.shader.info_set == null || this.shader.info_set.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.set.%s", this.shader.info_set);
            String reference = this.shader.info_reference == null || this.shader.info_reference.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.reference.%s", this.shader.info_reference);
            String string = details = this.shader.info_details == null || this.shader.info_details.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.details.%s", this.shader.info_details);
            if (set != null) {
                textAssembly.append("\n").append((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.shader.set"), ChatFormatting.BOLD)).append(" " + set);
            }
            if (reference != null) {
                textAssembly.append("\n").append((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.shader.reference"), ChatFormatting.BOLD)).append("\n" + reference);
            }
            if (details != null) {
                textAssembly.append("\n").append((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.shader.details"), ChatFormatting.BOLD)).append("\n" + details);
            }
            Object cost = Integer.toString(this.replicationCost.getCount());
            if (!IngredientUtils.hasPlayerIngredient((Player)ManualUtils.mc().player, this.replicationCost) && !ManualUtils.mc().player.getAbilities().instabuild) {
                cost = String.valueOf(ChatFormatting.RED) + (String)cost;
            }
            buttons.add(new GuiButtonManual(gui, x + 50, y + 120, 70, 12, (Component)Component.literal((String)(I18n.get((String)"ie.manual.entry.shaderList.order", (Object[])new Object[0]) + " " + (String)cost + "x   ")).withStyle(ChatFormatting.BOLD), btn -> {
                if (IngredientUtils.hasPlayerIngredient((Player)ManualUtils.mc().player, this.replicationCost) || ManualUtils.mc().player.getAbilities().instabuild) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MessageShaderManual(MessageShaderManual.MessageType.SPAWN, this.shader.getName()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                gui.fullInit();
            }).setTextColour(gui.getManual().getTextColour(), gui.getManual().getHighlightColour()));
        } else {
            textAssembly.append("\n\n").append((Component)Component.translatable((String)"ie.manual.entry.shaderList.noInfo"));
            if (player.getAbilities().instabuild) {
                buttons.add(new GuiButtonManual(gui, x + 10, y + 120, 100, 16, (Component)Component.translatable((String)"ie.manual.entry.shaderList.unlock"), btn -> {
                    UUID playerId = ManualUtils.mc().player.getUUID();
                    PacketDistributor.sendToServer((CustomPacketPayload)new MessageShaderManual(MessageShaderManual.MessageType.UNLOCK, this.shader.getName()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ShaderRegistry.receivedShaders.put((Object)playerId, (Object)this.shader.getName());
                    gui.fullInit();
                }).setTextColour(gui.getManual().getTextColour(), gui.getManual().getHighlightColour()));
            }
        }
        this.text = textAssembly;
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        Lighting.setupFor3DItems();
        float scale = 2.0f;
        PoseStack transform = graphics.pose();
        transform.pushPose();
        transform.translate((float)x, (float)y, 0.0f);
        transform.scale(scale, scale, scale);
        boolean examples = this.exampleItems != null && this.exampleItems.length > 0;
        ManualUtils.renderItemStack(graphics, this.shaderItem, (int)((float)(10 + (examples ? 0 : 34)) / scale), (int)(-8.0f / scale), false);
        if (examples && this.example >= 0 && this.example < this.exampleItems.length) {
            ManualUtils.renderItemStack(graphics, this.exampleItems[this.example], (int)(63.0f / scale), (int)(-8.0f / scale), false);
        }
        transform.scale(1.0f / scale, 1.0f / scale, 1.0f / scale);
        if (this.unlocked) {
            ManualUtils.renderItemStack(graphics, this.replicationCost.getRandomizedExampleStack(ManualUtils.mc().player.tickCount), 102, 118, false);
        }
        Lighting.setupForFlatItems();
        int w = this.manual.fontRenderer().width(this.name.getString());
        this.drawWrappedWithTransform(graphics, (FormattedText)this.name, 60 - w / 2, 24);
        if (this.text != null && !this.text.getString().isEmpty()) {
            this.drawWrappedWithTransform(graphics, (FormattedText)this.text, 0, 38);
        }
        transform.popPose();
    }

    private void drawWrappedWithTransform(GuiGraphics graphics, FormattedText text, int x, int y) {
        for (FormattedCharSequence line : this.manual.fontRenderer().split(text, 120)) {
            graphics.drawString(this.manual.fontRenderer(), line, (float)x, (float)y, this.manual.getTextColour(), false);
            Objects.requireNonNull(this.manual.fontRenderer());
            y += 9;
        }
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public void recalculateCraftingRecipes() {
    }
}

