/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.client.gui.ClientBlockEntityScreen;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.common.blocks.metal.RedstoneSwitchboardBlockEntity;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

public class RedstoneSwitchboardScreen
extends ClientBlockEntityScreen<RedstoneSwitchboardBlockEntity> {
    private static final ResourceLocation TEXTURE = IEContainerScreen.makeTextureLocation("switchboard");
    public static final GuiButtonIE.ButtonTexture IDENT = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("switchboard/ident"));
    public static final GuiButtonIE.ButtonTexture INVERT = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("switchboard/invert"));
    public static final GuiButtonIE.ButtonTexture EMPTY = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("switchboard/empty"));
    public static final ResourceLocation PLUG = IEApi.ieLoc("switchboard/plug");
    private final boolean[] inverterStates = new boolean[16];
    private DyeColor clickedInput;

    public RedstoneSwitchboardScreen(RedstoneSwitchboardBlockEntity tileEntity, Component title) {
        super(tileEntity, title);
        this.xSize = 240;
        this.ySize = 138;
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        for (int i = 0; i < 16; ++i) {
            int finalIndex = i;
            this.addRenderableWidget((GuiEventListener)new GuiButtonBoolean(this.guiLeft + 9 + i * 14, this.guiTop + 105, 12, 11, (Component)Component.empty(), () -> this.inverterStates[finalIndex], IDENT, INVERT, btn -> {
                this.inverterStates[finalIndex] = (Boolean)btn.getNextState();
                this.findConnectionWidget(w -> w.setting.output().getId() == finalIndex).ifPresent(oldWidget -> this.addSetting(new RedstoneSwitchboardBlockEntity.SwitchboardSetting(oldWidget.setting.input(), this.inverterStates[finalIndex], oldWidget.setting.output())));
            }));
            this.addRenderableWidget((GuiEventListener)new GuiButtonIE(this.guiLeft + 9 + i * 14, this.guiTop + 30, 12, 12, (Component)Component.empty(), EMPTY, btn -> {
                this.clickedInput = DyeColor.byId((int)finalIndex);
            }));
            this.addRenderableWidget((GuiEventListener)new GuiButtonIE(this.guiLeft + 9 + i * 14, this.guiTop + 86, 12, 12, (Component)Component.empty(), EMPTY, btn -> {
                if (this.clickedInput != null) {
                    this.addSetting(new RedstoneSwitchboardBlockEntity.SwitchboardSetting(this.clickedInput, this.inverterStates[finalIndex], DyeColor.byId((int)finalIndex)));
                    this.clickedInput = null;
                } else {
                    this.removeSetting(DyeColor.byId((int)finalIndex), true);
                }
            }));
        }
        ((RedstoneSwitchboardBlockEntity)this.blockEntity).settings.forEach(setting -> {
            this.inverterStates[setting.output().getId()] = setting.invert();
            this.addConnectionWidget((RedstoneSwitchboardBlockEntity.SwitchboardSetting)setting);
        });
    }

    private void addConnectionWidget(RedstoneSwitchboardBlockEntity.SwitchboardSetting setting) {
        this.addRenderableWidget((GuiEventListener)new ConnectionWidget(this, this.guiLeft, this.guiTop, setting));
    }

    private Optional<ConnectionWidget> findConnectionWidget(Predicate<ConnectionWidget> predicate) {
        for (Renderable widget : this.renderables) {
            ConnectionWidget connectionWidget;
            if (!(widget instanceof ConnectionWidget) || !predicate.test(connectionWidget = (ConnectionWidget)widget)) continue;
            return Optional.of(connectionWidget);
        }
        return Optional.empty();
    }

    private void addSetting(RedstoneSwitchboardBlockEntity.SwitchboardSetting newSetting) {
        this.findConnectionWidget(w -> w.setting.input() == newSetting.input()).ifPresent(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.findConnectionWidget(w -> w.setting.output() == newSetting.output()).ifPresent(x$0 -> this.removeWidget((GuiEventListener)x$0));
        ((RedstoneSwitchboardBlockEntity)this.blockEntity).addSetting(newSetting);
        this.addConnectionWidget(newSetting);
        PacketDistributor.sendToServer((CustomPacketPayload)new MessageBlockEntitySync(this.blockEntity, newSetting.writeToNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void removeSetting(DyeColor output, boolean selectInput) {
        this.findConnectionWidget(w -> w.setting.output() == output).ifPresent(widget -> {
            if (selectInput) {
                this.clickedInput = widget.setting.input();
            }
            this.removeWidget((GuiEventListener)widget);
        });
        ((RedstoneSwitchboardBlockEntity)this.blockEntity).removeSetting(output);
        CompoundTag msg = new CompoundTag();
        msg.putInt("remove", output.getId());
        PacketDistributor.sendToServer((CustomPacketPayload)new MessageBlockEntitySync(this.blockEntity, msg), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.clickedInput != null) {
            graphics.blitSprite(PLUG, this.guiLeft + 7 + this.clickedInput.getId() * 14, this.guiTop + 31, 16, 16);
            CableQuad.build(this, this.clickedInput, new Vec2((float)mouseX, (float)mouseY)).draw(graphics);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int modifier) {
        boolean ret = super.mouseClicked(mouseX, mouseY, modifier);
        if (!ret && this.clickedInput != null) {
            this.clickedInput = null;
            return true;
        }
        return ret;
    }

    @Override
    protected void drawGuiContainerForegroundLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.drawString(this.font, (Component)Component.translatable((String)"desc.immersiveengineering.info.blockSide.io.input"), this.guiLeft + 8, this.guiTop + 4, DyeColor.GRAY.getTextColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"desc.immersiveengineering.info.blockSide.io.output"), this.guiLeft + 8, this.guiTop + 74, DyeColor.GRAY.getTextColor());
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        if (mouseX > this.guiLeft + 8 && mouseX < this.guiLeft + 232 && (mouseY > this.guiTop + 14 && mouseY < this.guiTop + 48 || mouseY > this.guiTop + 84 && mouseY < this.guiTop + 132)) {
            int dyeIdx = (mouseX - this.guiLeft - 8) / 14;
            boolean output = mouseY > this.guiTop + 48;
            tooltip.add(Component.translatable((String)("gui.immersiveengineering.config.redstone_color_" + (output ? "output" : "input"))).append(" ").append((Component)Component.translatable((String)("color.minecraft." + DyeColor.byId((int)dyeIdx).getName()))).withStyle(ChatFormatting.GRAY));
            if (output) {
                tooltip.add(Component.translatable((String)("chat.immersiveengineering.info.rsSignal." + (this.inverterStates[dyeIdx] ? "invertedOn" : "invertedOff"))).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (!tooltip.isEmpty()) {
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private static class ConnectionWidget
    extends AbstractWidget {
        final RedstoneSwitchboardBlockEntity.SwitchboardSetting setting;
        final CableQuad quad;

        public ConnectionWidget(RedstoneSwitchboardScreen screen, int guiLeft, int guiTop, RedstoneSwitchboardBlockEntity.SwitchboardSetting setting) {
            super(guiLeft, guiTop, 240, 138, (Component)Component.empty());
            this.setting = setting;
            this.quad = CableQuad.build(screen, setting.input(), setting.output());
            this.active = false;
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.blitSprite(PLUG, this.getX() + 7 + this.setting.input().getId() * 14, this.getY() + 31, 16, 16);
            graphics.blitSprite(PLUG, this.getX() + 7 + this.setting.output().getId() * 14, this.getY() + 87, 16, 16);
            this.quad.draw(graphics);
        }

        protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
        }
    }

    private record CableQuad(Vec2 topLeft, Vec2 topRight, Vec2 botLeft, Vec2 botRight, int colour) {
        public static CableQuad build(Vec2 fromPos, Vec2 toPos, int color) {
            Vec3 dir = new Vec3((double)(toPos.x - fromPos.x), (double)(toPos.y - fromPos.y), 0.0);
            Vec3 orthL = dir.zRot(90.0f).normalize();
            Vec3 orthR = dir.zRot(-90.0f).normalize();
            Vec2 offsetL = new Vec2((float)(orthL.x * 2.5), (float)(orthL.y * 2.5));
            Vec2 offsetR = new Vec2((float)(orthR.x * 2.5), (float)(orthR.y * 2.5));
            return new CableQuad(fromPos.add(offsetL), fromPos.add(offsetR), toPos.add(offsetL), toPos.add(offsetR), color);
        }

        public static CableQuad build(RedstoneSwitchboardScreen screen, DyeColor input, Vec2 toPos) {
            return CableQuad.build(new Vec2((float)screen.guiLeft + 17.5f + (float)(input.getId() * 14), (float)(screen.guiTop + 42)), toPos, 0xFF000000 | input.getFireworkColor());
        }

        public static CableQuad build(RedstoneSwitchboardScreen screen, DyeColor input, DyeColor output) {
            return CableQuad.build(screen, input, new Vec2((float)screen.guiLeft + 17.5f + (float)(output.getId() * 14), (float)(screen.guiTop + 100)));
        }

        public void draw(GuiGraphics graphics) {
            Matrix4f matrix4f = graphics.pose().last().pose();
            VertexConsumer vertexconsumer = graphics.bufferSource().getBuffer(RenderType.debugQuads());
            vertexconsumer.addVertex(matrix4f, this.topLeft.x, this.topLeft.y, 1.0f).setColor(this.colour);
            vertexconsumer.addVertex(matrix4f, this.botLeft.x, this.botLeft.y, 1.0f).setColor(this.colour);
            vertexconsumer.addVertex(matrix4f, this.botRight.x, this.botRight.y, 1.0f).setColor(this.colour);
            vertexconsumer.addVertex(matrix4f, this.topRight.x, this.topRight.y, 1.0f).setColor(this.colour);
            graphics.flush();
        }
    }
}

