/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class CollectingVertexBuilder
implements VertexConsumer {
    protected final List<Vertex> vertices = new ArrayList<Vertex>();
    private final List<Vertex> pool = new ArrayList<Vertex>();
    private Vertex currentVertex = null;

    @Nonnull
    public VertexConsumer addVertex(float x, float y, float z) {
        if (this.currentVertex != null) {
            this.endVertex();
        }
        this.currentVertex = this.makeVertex();
        this.currentVertex.order.add(Element.POSITION);
        this.currentVertex.position[0] = x;
        this.currentVertex.position[1] = y;
        this.currentVertex.position[2] = z;
        return this;
    }

    @Nonnull
    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        this.currentVertex.order.add(Element.COLOR);
        this.currentVertex.color[0] = red;
        this.currentVertex.color[1] = green;
        this.currentVertex.color[2] = blue;
        this.currentVertex.color[3] = alpha;
        return this;
    }

    @Nonnull
    public VertexConsumer setUv(float u, float v) {
        this.currentVertex.order.add(Element.UV);
        this.currentVertex.uv[0] = u;
        this.currentVertex.uv[1] = v;
        return this;
    }

    @Nonnull
    public VertexConsumer setUv1(int u, int v) {
        this.currentVertex.order.add(Element.OVERLAY);
        this.currentVertex.overlay[0] = u;
        this.currentVertex.overlay[1] = v;
        return this;
    }

    @Nonnull
    public VertexConsumer setUv2(int u, int v) {
        this.currentVertex.order.add(Element.UV2);
        this.currentVertex.uv2[0] = u;
        this.currentVertex.uv2[1] = v;
        return this;
    }

    @Nonnull
    public VertexConsumer setNormal(float x, float y, float z) {
        this.currentVertex.order.add(Element.NORMAL);
        this.currentVertex.normal[0] = x;
        this.currentVertex.normal[1] = y;
        this.currentVertex.normal[2] = z;
        return this;
    }

    protected void endVertex() {
        if (this.currentVertex != null) {
            this.vertices.add(this.currentVertex);
        }
    }

    public void pipeAndClear(VertexConsumer out) {
        this.endVertex();
        for (Vertex v : this.vertices) {
            v.pipe(out);
        }
        this.clear();
    }

    protected void clear() {
        this.pool.addAll(this.vertices);
        this.currentVertex = null;
        this.vertices.clear();
    }

    private Vertex makeVertex() {
        if (!this.pool.isEmpty()) {
            Vertex result = this.pool.remove(this.pool.size() - 1);
            result.order.clear();
            return result;
        }
        return new Vertex();
    }

    protected static class Vertex {
        private final float[] position = new float[3];
        private final int[] color = new int[4];
        private final float[] uv = new float[2];
        private final int[] overlay = new int[2];
        private final int[] uv2 = new int[2];
        private final float[] normal = new float[3];
        private final List<Element> order = new ArrayList<Element>();

        protected Vertex() {
        }

        public void pipe(VertexConsumer out) {
            for (Element e : this.order) {
                switch (e.ordinal()) {
                    case 0: {
                        out.addVertex(this.position[0], this.position[1], this.position[2]);
                        break;
                    }
                    case 1: {
                        out.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
                        break;
                    }
                    case 2: {
                        out.setUv(this.uv[0], this.uv[1]);
                        break;
                    }
                    case 3: {
                        out.setUv1(this.overlay[0], this.overlay[1]);
                        break;
                    }
                    case 4: {
                        out.setUv2(this.uv2[0], this.uv2[1]);
                        break;
                    }
                    case 5: {
                        out.setNormal(this.normal[0], this.normal[1], this.normal[2]);
                    }
                }
            }
        }
    }

    protected static enum Element {
        POSITION,
        COLOR,
        UV,
        OVERLAY,
        UV2,
        NORMAL;

    }
}

