/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretChemBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretGunBlockEntity;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import blusunrize.immersiveengineering.common.items.BulletItem;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public abstract class TurretMenu
extends IEContainerMenu {
    public final TurretContext data;

    protected TurretMenu(TurretContext ctx) {
        super(ctx.ctx);
        int i;
        this.data = ctx;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)ctx.invPlayer, j + i * 9 + 9, 8 + j * 18, 109 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)ctx.invPlayer, i, 8 + i * 18, 167));
        }
        this.addGenericData(GenericContainerData.energy(ctx.energy));
        this.addGenericData(new GenericContainerData<List<String>>(GenericDataSerializers.STRINGS, ctx.targetList));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, ctx.whitelist));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, ctx.attackAnimals));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, ctx.attackPlayers));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, ctx.attackNeutrals));
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        if (nbt.contains("add", 8)) {
            this.data.targetList.get().add(nbt.getString("add"));
        }
        if (nbt.contains("remove", 3)) {
            this.data.targetList.get().remove(nbt.getInt("remove"));
        }
        if (nbt.contains("whitelist", 1)) {
            this.data.whitelist.set(nbt.getBoolean("whitelist"));
        }
        if (nbt.contains("attackAnimals", 1)) {
            this.data.attackAnimals.set(nbt.getBoolean("attackAnimals"));
        }
        if (nbt.contains("attackPlayers", 1)) {
            this.data.attackPlayers.set(nbt.getBoolean("attackPlayers"));
        }
        if (nbt.contains("attackNeutrals", 1)) {
            this.data.attackNeutrals.set(nbt.getBoolean("attackNeutrals"));
        }
        this.data.afterChange.run();
    }

    public record TurretContext(IEContainerMenu.MenuContext ctx, Inventory invPlayer, IMutableEnergyStorage energy, GetterAndSetter<List<String>> targetList, Runnable afterChange, GetterAndSetter<Boolean> whitelist, GetterAndSetter<Boolean> attackAnimals, GetterAndSetter<Boolean> attackPlayers, GetterAndSetter<Boolean> attackNeutrals) {
        public static TurretContext serverCtx(MenuType<?> type, int id, Inventory invPlayer, TurretBlockEntity<?> be) {
            return new TurretContext(IEContainerMenu.blockCtx(type, id, be), invPlayer, be.energyStorage, TurretContext.configSetter(be, TurretBlockEntity.TurretConfig::targetList, TurretBlockEntity.TurretConfig::withTargetList), be::resetTarget, TurretContext.configSetter(be, TurretBlockEntity.TurretConfig::whitelist, TurretBlockEntity.TurretConfig::withWhitelist), TurretContext.configSetter(be, TurretBlockEntity.TurretConfig::attackAnimals, TurretBlockEntity.TurretConfig::withAttackAnimals), TurretContext.configSetter(be, TurretBlockEntity.TurretConfig::attackPlayers, TurretBlockEntity.TurretConfig::withAttackPlayers), TurretContext.configSetter(be, TurretBlockEntity.TurretConfig::attackNeutrals, TurretBlockEntity.TurretConfig::withAttackNeutrals));
        }

        private static <T> GetterAndSetter<T> configSetter(TurretBlockEntity<?> be, Function<TurretBlockEntity.TurretConfig, T> get, BiFunction<TurretBlockEntity.TurretConfig, T, TurretBlockEntity.TurretConfig> with) {
            return new GetterAndSetter<Object>(() -> get.apply(be.config), t -> {
                be.config = (TurretBlockEntity.TurretConfig)with.apply(be.config, t);
            });
        }

        public static TurretContext clientCtx(MenuType<?> type, int id, Inventory invPlayer) {
            return new TurretContext(IEContainerMenu.clientCtx(type, id), invPlayer, new MutableEnergyStorage(16000), GetterAndSetter.standalone(List.of()), () -> {}, GetterAndSetter.standalone(false), GetterAndSetter.standalone(false), GetterAndSetter.standalone(false), GetterAndSetter.standalone(false));
        }
    }

    public static class GunTurretMenu
    extends TurretMenu {
        public final GetterAndSetter<Boolean> expelCasings;

        public static GunTurretMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, TurretGunBlockEntity be) {
            return new GunTurretMenu(TurretContext.serverCtx(type, id, invPlayer, be), (IItemHandler)new ItemStackHandler(be.getInventory()), new GetterAndSetter<Boolean>(() -> be.expelCasings, b -> {
                be.expelCasings = b;
            }));
        }

        public static GunTurretMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
            return new GunTurretMenu(TurretContext.clientCtx(type, id, invPlayer), (IItemHandler)new ItemStackHandler(2), GetterAndSetter.standalone(false));
        }

        private GunTurretMenu(TurretContext ctx, IItemHandler inv, GetterAndSetter<Boolean> expelCasings) {
            super(ctx);
            this.expelCasings = expelCasings;
            this.addSlot((Slot)new IESlot.Bullet(this, inv, 0, 134, 13, 64){

                @Override
                public boolean mayPlace(ItemStack itemStack) {
                    if (!super.mayPlace(itemStack)) {
                        return false;
                    }
                    BulletHandler.IBullet<?> bullet = ((BulletItem)itemStack.getItem()).getType();
                    return bullet != null && bullet.isValidForTurret();
                }
            });
            this.addSlot((Slot)new IESlot.NewOutput(inv, 1, 134, 49));
            this.ownSlotCount = 2;
            this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, expelCasings));
        }

        @Override
        public void receiveMessageFromScreen(CompoundTag nbt) {
            super.receiveMessageFromScreen(nbt);
            if (nbt.contains("expelCasings", 1)) {
                this.expelCasings.set(nbt.getBoolean("expelCasings"));
            }
        }
    }

    public static class ChemTurretMenu
    extends TurretMenu {
        public final FluidTank tank;
        public final GetterAndSetter<Boolean> ignite;

        public static ChemTurretMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, TurretChemBlockEntity be) {
            return new ChemTurretMenu(TurretContext.serverCtx(type, id, invPlayer, be), be.tank, new GetterAndSetter<Boolean>(() -> be.ignite, b -> {
                be.ignite = b;
            }));
        }

        public static ChemTurretMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
            return new ChemTurretMenu(TurretContext.clientCtx(type, id, invPlayer), new FluidTank(4000), GetterAndSetter.standalone(false));
        }

        private ChemTurretMenu(TurretContext ctx, FluidTank tank, GetterAndSetter<Boolean> ignite) {
            super(ctx);
            this.tank = tank;
            this.ignite = ignite;
            this.addGenericData(GenericContainerData.fluid(tank));
            this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, ignite));
        }

        @Override
        public void receiveMessageFromScreen(CompoundTag nbt) {
            super.receiveMessageFromScreen(nbt);
            if (nbt.contains("ignite", 1)) {
                this.ignite.set(nbt.getBoolean("ignite"));
            }
        }
    }
}

