/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.DieselToolItem;
import blusunrize.immersiveengineering.common.items.GrindingDiskItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.RockcutterItem;
import blusunrize.immersiveengineering.common.items.SawbladeItem;
import blusunrize.immersiveengineering.common.items.upgrades.ToolUpgrade;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class BuzzsawItem
extends DieselToolItem
implements IEItemInterfaces.IScrollwheel {
    public static final Collection<SawbladeItem> SAWBLADES = new ArrayList<SawbladeItem>(2);
    public static final String TYPE = "BUZZSAW";
    private static final Map<ItemAbility, SoundEvent> ACTION_SOUNDS = new HashMap<ItemAbility, SoundEvent>();
    private static final int MAX_HORIZONTAL_DISTANCE = 7;

    public BuzzsawItem() {
        super(new Item.Properties().stacksTo(1), TYPE, 5);
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        boolean hasQuiver = BuzzsawItem.hasQuiverUpgrade(stack);
        int mainHeadX = hasQuiver ? 88 : 98;
        ArrayList<IESlot.SlotItemHandlerIE> slots = new ArrayList<IESlot.SlotItemHandlerIE>(5);
        slots.add(new IESlot.WithPredicate(toolInventory, 0, mainHeadX, 22, BuzzsawItem::isSawblade, newBlade -> this.setHead(stack, (ItemStack)newBlade)));
        slots.add(new IESlot.Upgrades(container, toolInventory, 1, 88, 52, TYPE, stack, true, level, getPlayer));
        slots.add(new IESlot.Upgrades(container, toolInventory, 2, 108, 52, TYPE, stack, true, level, getPlayer));
        if (BuzzsawItem.hasQuiverUpgrade(stack)) {
            slots.add(new IESlot.WithPredicate(toolInventory, 3, 108, 12, BuzzsawItem::isSawblade));
            slots.add(new IESlot.WithPredicate(toolInventory, 4, 108, 32, BuzzsawItem::isSawblade));
        }
        return slots.toArray(new Slot[0]);
    }

    @Override
    public ItemStack getUpgradeAfterRemoval(ItemStack stack, ItemStack upgrade) {
        if (BuzzsawItem.isSpareBladeUpgrade(upgrade)) {
            ArrayList spares = new ArrayList();
            this.forEachSpareBlade(stack, (i, blade) -> spares.add(blade));
            upgrade.set(IEDataComponents.GENERIC_ITEMS, (Object)ItemContainerContents.fromItems(spares));
        }
        return upgrade;
    }

    @Override
    public void removeUpgrade(ItemStack stack, Player player, ItemStack upgrade) {
        if (BuzzsawItem.isSpareBladeUpgrade(upgrade)) {
            this.forEachSpareBlade(stack, (i, $) -> BuzzsawItem.setSawblade(stack, ItemStack.EMPTY, i));
        }
    }

    private void forEachSpareBlade(ItemStack stack, BiConsumer<Integer, ItemStack> onBlade) {
        for (int i = 1; i <= 2; ++i) {
            onBlade.accept(i, BuzzsawItem.getSawblade(stack, i));
        }
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (!(inv == null || inv.getStackInSlot(0).isEmpty() || inv.getStackInSlot(1).isEmpty() || inv.getStackInSlot(2).isEmpty())) {
            Utils.unlockIEAdvancement(player, "tools/upgrade_buzzsaw");
        }
    }

    @Override
    public void recalculateUpgrades(ItemStack stack, Level w, Player player) {
        super.recalculateUpgrades(stack, w, player);
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (inv instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)inv;
            for (int iUpgrade = 1; iUpgrade <= 2; ++iUpgrade) {
                ItemContainerContents upgradeInventory;
                ItemStack upgrade = inv.getStackInSlot(iUpgrade).copy();
                if (!BuzzsawItem.isSpareBladeUpgrade(upgrade) || (upgradeInventory = (ItemContainerContents)upgrade.remove(IEDataComponents.GENERIC_ITEMS)) == null) continue;
                for (int i = 1; i <= upgradeInventory.getSlots(); ++i) {
                    ItemStack blade = upgradeInventory.getStackInSlot(i - 1);
                    if (blade.isEmpty()) continue;
                    BuzzsawItem.setSawblade(stack, blade, i);
                }
                modifiable.setStackInSlot(iUpgrade, upgrade);
            }
        }
    }

    @Override
    public ItemStack getHead(ItemStack itemStack) {
        return BuzzsawItem.getSawblade(itemStack, 0);
    }

    public static ItemStack getSawblade(ItemStack itemStack, int spare) {
        IItemHandler cap = (IItemHandler)itemStack.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap == null) {
            return ItemStack.EMPTY;
        }
        int slot = spare == 0 ? 0 : 2 + spare;
        ItemStack sawblade = cap.getStackInSlot(slot);
        return !sawblade.isEmpty() && BuzzsawItem.isSawblade(sawblade) ? sawblade : ItemStack.EMPTY;
    }

    @Override
    public void setHead(ItemStack buzzsaw, ItemStack sawblade) {
        BuzzsawItem.setSawblade(buzzsaw, sawblade, 0);
    }

    public static void setSawblade(ItemStack buzzsaw, ItemStack sawblade, int spare) {
        int slot = spare == 0 ? 0 : 2 + spare;
        BuzzsawItem.makeInternalItemHandler(buzzsaw).setStackInSlot(slot, sawblade);
    }

    public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        SawbladeItem blade;
        Integer levelOverride;
        ItemStack sawblade = BuzzsawItem.getSawblade(stack, 0);
        Item item = sawblade.getItem();
        if (item instanceof SawbladeItem && (levelOverride = (blade = (SawbladeItem)item).getExtraEnchantments().get(enchantment.unwrapKey().orElseThrow())) != null) {
            return levelOverride;
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    public ItemEnchantments getAllEnchantments(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemStack sawblade = BuzzsawItem.getSawblade(stack, 0);
        ItemEnchantments superEnchants = super.getAllEnchantments(stack, lookup);
        Item item = sawblade.getItem();
        if (item instanceof SawbladeItem) {
            SawbladeItem blade = (SawbladeItem)item;
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(superEnchants);
            blade.getExtraEnchantments().forEach((enchantmentResourceKey, integer) -> lookup.get(enchantmentResourceKey).ifPresent(enchantmentReference -> mutable.upgrade((Holder)enchantmentReference, integer.intValue())));
            return mutable.toImmutable();
        }
        return superEnchants;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        list.add(IEItemFluidHandler.fluidItemInfoFlavor(this.getFluid(stack), this.getCapacity(stack, 2000)));
        if (this.getHead(stack).isEmpty()) {
            list.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.flavour.buzzsaw.noBlade"), ChatFormatting.GRAY));
        } else {
            int maxDmg = this.getMaxHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            ChatFormatting status = (double)quote < 0.1 ? ChatFormatting.RED : ((double)quote < 0.3 ? ChatFormatting.GOLD : ((double)quote < 0.6 ? ChatFormatting.YELLOW : ChatFormatting.GREEN));
            list.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.flavour.buzzsaw.bladeDamage"), ChatFormatting.GRAY).append(" ").append((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.percent", (Object[])new Object[]{(int)(quote * 100.0f)}), status)));
        }
    }

    @Override
    protected double getAttackDamage(ItemStack stack, ItemStack sawblade) {
        return ((SawbladeItem)sawblade.getItem()).getSawbladeDamage();
    }

    @Override
    public void onScrollwheel(ItemStack stack, Player playerEntity, boolean forward) {
        if (BuzzsawItem.hasQuiverUpgrade(stack)) {
            ItemStack sawblade = this.getHead(stack);
            ItemStack spare1 = BuzzsawItem.getSawblade(stack, 1);
            ItemStack spare2 = BuzzsawItem.getSawblade(stack, 2);
            if (forward) {
                this.setHead(stack, spare2);
                BuzzsawItem.setSawblade(stack, sawblade, 1);
                BuzzsawItem.setSawblade(stack, spare1, 2);
            } else {
                this.setHead(stack, spare1);
                BuzzsawItem.setSawblade(stack, spare2, 1);
                BuzzsawItem.setSawblade(stack, sawblade, 2);
            }
        }
    }

    @Override
    public boolean canToolBeUsed(ItemStack stack) {
        if (this.getHeadDamage(stack) >= this.getMaxHeadDamage(stack)) {
            return false;
        }
        return !this.getFluid(stack).isEmpty();
    }

    @Override
    public int getMaxHeadDamage(ItemStack stack) {
        ItemStack sawblade = this.getHead(stack);
        return !sawblade.isEmpty() ? sawblade.getMaxDamage() : 0;
    }

    @Override
    public int getHeadDamage(ItemStack stack) {
        ItemStack sawblade = this.getHead(stack);
        return !sawblade.isEmpty() ? sawblade.getDamageValue() : 0;
    }

    @Override
    public Holder<SoundEvent> getIdleSound(ItemStack stack) {
        return IESounds.buzzsaw_idle;
    }

    @Override
    public Holder<SoundEvent> getBusySound(ItemStack stack) {
        return IESounds.buzzsaw_busy;
    }

    @Override
    public Holder<SoundEvent> getFadingSound(ItemStack stack) {
        return IESounds.buzzsaw_fade;
    }

    @Override
    public Holder<SoundEvent> getAttackSound(ItemStack stack) {
        return IESounds.buzzsaw_attack;
    }

    @Override
    public Holder<SoundEvent> getHarvestSound(ItemStack stack) {
        Item headitem = this.getHead(stack).getItem();
        if (headitem instanceof GrindingDiskItem || headitem instanceof RockcutterItem) {
            return IESounds.buzzsaw_harvest_grind;
        }
        return IESounds.buzzsaw_harvest_saw;
    }

    @Override
    public boolean ableToMakeNoise(ItemStack stack) {
        return this.canToolBeUsed(stack);
    }

    @Override
    public boolean noisySameStack(ItemStack mainStack, ItemStack otherStack) {
        BuzzsawItem buzzsawItem;
        Item item = mainStack.getItem();
        return item instanceof BuzzsawItem && (buzzsawItem = (BuzzsawItem)item).equals(otherStack.getItem()) && this.getHead(mainStack).getItem().equals(this.getHead(otherStack).getItem());
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity living) {
        this.consumeDurability(stack, world, state, pos, living);
        if (!world.isClientSide && !living.isShiftKeyDown() && living instanceof ServerPlayer && this.canFellTree(stack) && this.canToolBeUsed(stack) && this.isTree(world, pos) && !state.is(IETags.buzzsawTreeBlacklist)) {
            this.fellTree(world, pos, (ServerPlayer)living, stack);
        }
        return true;
    }

    @Override
    protected int getToolDamageFromBlock(ItemStack stack, @Nullable BlockState state) {
        ItemStack sawblade = this.getHead(stack);
        Item item = sawblade.getItem();
        if (item instanceof SawbladeItem) {
            SawbladeItem sawbladeItem = (SawbladeItem)item;
            return sawbladeItem.getSawbladeDamageFromBlock(state == null || this.isEffective(stack, state));
        }
        return 0;
    }

    @Override
    protected void damageHead(ItemStack head, int amount, LivingEntity living) {
        head.hurtAndBreak(amount, living, EquipmentSlot.MAINHAND);
    }

    @Override
    protected void consumeDurability(ItemStack stack, Level world, @Nullable BlockState state, @Nullable BlockPos pos, LivingEntity living) {
        if (state == null || !state.is(BlockTags.LEAVES) || ApiUtils.RANDOM.nextInt(10) == 0) {
            super.consumeDurability(stack, world, state, pos, living);
        }
    }

    @Override
    public Tier getHarvestLevel(ItemStack stack, @Nullable Player player) {
        ItemStack sawblade = this.getHead(stack);
        if (!sawblade.isEmpty()) {
            return Tiers.DIAMOND;
        }
        return null;
    }

    @Override
    public boolean isEffective(ItemStack stack, BlockState state) {
        Predicate<BlockState> mineable = null;
        ItemStack sawblade = this.getHead(stack);
        if (sawblade.getItem() instanceof SawbladeItem) {
            mineable = ((SawbladeItem)sawblade.getItem()).getSawbladeMaterials();
        }
        return mineable != null && mineable.test(state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        ItemStack sawblade;
        if (this.isEffective(stack, state) && !(sawblade = this.getHead(stack)).isEmpty() && this.canToolBeUsed(stack)) {
            return ((SawbladeItem)sawblade.getItem()).getSawbladeSpeed();
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        ItemStack sawblade = this.getHead(stack);
        if (sawblade.getItem() instanceof SawbladeItem) {
            return ((SawbladeItem)sawblade.getItem()).getItemAbilities().contains(toolAction);
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack head = this.getHead(context.getItemInHand());
        Item item = head.getItem();
        if (!(item instanceof SawbladeItem)) {
            return InteractionResult.PASS;
        }
        SawbladeItem sawblade = (SawbladeItem)item;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Set<ItemAbility> toolActions = sawblade.getItemAbilities();
        for (ItemAbility action : toolActions) {
            BlockState transformed = state.getToolModifiedState(context, action, false);
            if (transformed == null) continue;
            SoundEvent sound = ACTION_SOUNDS.get(action);
            if (sound != null) {
                level.playSound(context.getPlayer(), pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!level.isClientSide) {
                level.setBlock(pos, transformed, 11);
                if (context.getPlayer() != null) {
                    this.damageHead(head, 1, (LivingEntity)context.getPlayer());
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private boolean isTree(Level world, BlockPos initialPos) {
        int logs = 0;
        boolean leafTop = false;
        BlockPos pos = initialPos;
        for (int y = 0; y < 32; ++y) {
            BlockState state = world.getBlockState(pos = pos.above());
            if (state.is(BlockTags.LOGS)) {
                ++logs;
                continue;
            }
            if (state.is(BlockTags.LEAVES)) {
                leafTop = true;
            }
            boolean foundLog = false;
            if (!leafTop) {
                boolean loop = true;
                for (int z = -1; z <= 1 && loop; ++z) {
                    for (int x = -1; x <= 1 && loop; ++x) {
                        state = world.getBlockState(pos.offset(x, 0, z));
                        if (!state.is(BlockTags.LOGS)) continue;
                        pos = pos.offset(x, 0, z);
                        foundLog = true;
                        ++logs;
                        loop = false;
                    }
                }
            }
            if (!foundLog) break;
        }
        return logs >= 3 && leafTop;
    }

    private boolean canFellTree(ItemStack stack) {
        ItemStack sawblade = this.getHead(stack);
        if (sawblade.getItem() instanceof SawbladeItem) {
            return ((SawbladeItem)sawblade.getItem()).canSawbladeFellTree();
        }
        return false;
    }

    private boolean fellTree(final Level world, BlockPos initialPos, final ServerPlayer player, final ItemStack stack) {
        int logs = 0;
        ArrayDeque<BlockPos> openList = new ArrayDeque<BlockPos>();
        final ArrayDeque<BlockPos> closedList = new ArrayDeque<BlockPos>();
        openList.add(initialPos);
        while (!openList.isEmpty() && closedList.size() < 512 && logs < 256) {
            BlockPos next = (BlockPos)openList.pollFirst();
            if (Math.abs(next.getX() - initialPos.getX()) > 7 || Math.abs(next.getZ() - initialPos.getZ()) > 7 || closedList.contains(next)) continue;
            BlockState state = world.getBlockState(next);
            if (state.is(BlockTags.LOGS)) {
                closedList.add(next);
                ++logs;
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        for (int x = -1; x <= 1; ++x) {
                            openList.add(next.offset(x, y, z));
                        }
                    }
                }
                continue;
            }
            if (!state.is(BlockTags.LEAVES)) continue;
            closedList.add(next);
            int trunkDist = state.getBlock() instanceof LeavesBlock ? (Integer)state.getValue((Property)LeavesBlock.DISTANCE) : 0;
            for (Direction dir : new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
                BlockPos adj = next.relative(dir);
                BlockState adjState = world.getBlockState(adj);
                if (adjState.is(BlockTags.LEAVES)) {
                    int adjDist;
                    int n = adjDist = adjState.getBlock() instanceof LeavesBlock ? (Integer)adjState.getValue((Property)LeavesBlock.DISTANCE) : 0;
                    if (adjDist < trunkDist) continue;
                }
                openList.add(adj);
            }
        }
        if (closedList.size() == 0) {
            return false;
        }
        NeoForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onTick(LevelTickEvent.Pre event) {
                if (event.getLevel() == world) {
                    BuzzsawItem.this.breakFromList(closedList, 5, world, player, stack);
                    if (closedList.isEmpty()) {
                        NeoForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            }
        });
        return true;
    }

    private void breakFromList(Deque<BlockPos> closedList, int maxAmount, Level world, ServerPlayer player, ItemStack stack) {
        int count = 0;
        while (count++ < maxAmount && !closedList.isEmpty()) {
            BlockPos pos = closedList.pollFirst();
            BlockState state = world.getBlockState(pos);
            BlockEvent.BreakEvent eventResult = CommonHooks.fireBlockBreak((Level)world, (GameType)player.gameMode.getGameModeForPlayer(), (ServerPlayer)player, (BlockPos)pos, (BlockState)state);
            if (eventResult.isCanceled()) continue;
            Block block = state.getBlock();
            if (state.isAir() || state.getDestroyProgress((Player)player, (BlockGetter)world, pos) == 0.0f) continue;
            if (player.getAbilities().instabuild) {
                if (block.onDestroyedByPlayer(state, world, pos, (Player)player, false, state.getFluidState())) {
                    block.destroy((LevelAccessor)world, pos, state);
                }
            } else {
                BlockEntity te = world.getBlockEntity(pos);
                this.consumeDurability(stack, world, state, pos, (LivingEntity)player);
                if (block.onDestroyedByPlayer(state, world, pos, (Player)player, true, state.getFluidState())) {
                    block.destroy((LevelAccessor)world, pos, state);
                    block.playerDestroy(world, (Player)player, pos, state, te, stack);
                }
            }
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
            player.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
        }
    }

    public static boolean hasQuiverUpgrade(ItemStack stack) {
        return IEItems.Tools.BUZZSAW.get().getUpgrades(stack).has(UpgradeEffect.SPAREBLADES);
    }

    public static boolean isSawblade(ItemStack stack) {
        Item item = stack.getItem();
        return item instanceof SawbladeItem && SAWBLADES.contains(item);
    }

    private static boolean isSpareBladeUpgrade(ItemStack upgrade) {
        return upgrade.getItem() != IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgrade.BUZZSAW_SPAREBLADES).asItem();
    }

    static {
        ACTION_SOUNDS.put(ItemAbilities.AXE_STRIP, SoundEvents.AXE_STRIP);
        ACTION_SOUNDS.put(ItemAbilities.AXE_SCRAPE, SoundEvents.AXE_SCRAPE);
        ACTION_SOUNDS.put(ItemAbilities.AXE_WAX_OFF, SoundEvents.AXE_WAX_OFF);
        ACTION_SOUNDS.put(ItemAbilities.SHEARS_CARVE, SoundEvents.PUMPKIN_CARVE);
    }
}

