/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.ShelfLogic;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerCopySlot;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ShelfMenu
extends IEContainerMenu {
    public static final int MAX_SLOTS = 216;
    public static final int COLUMN_WIDTH = 176;
    public static final int CRATE_SEGMENT = 69;
    public static final int INV_SEGMENT = 94;
    public final GetterAndSetter<List<ItemStack>> cratesFront;
    public final GetterAndSetter<List<ItemStack>> cratesBack;
    public final GetterAndSetter<Boolean> backside;

    public static ShelfMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, IEContainerMenu.MultiblockMenuContext<ShelfLogic.State> ctx) {
        ShelfLogic.State state = ctx.mbContext().getState();
        BlockPos pos = ctx.mbContext().getLevel().toRelative(ctx.clickedPos());
        return new ShelfMenu(ShelfMenu.multiblockCtx(type, id, ctx), state.getMenuItemHandler(pos), invPlayer, GetterAndSetter.getterOnly(() -> state.getCratesForMenu(pos, false)), GetterAndSetter.getterOnly(() -> state.getCratesForMenu(pos, true)), GetterAndSetter.standalone(false));
    }

    public static ShelfMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new ShelfMenu(ShelfMenu.clientCtx(type, id), (IItemHandlerModifiable)new ItemStackHandler(216), invPlayer, GetterAndSetter.standalone(List.of()), GetterAndSetter.standalone(List.of()), GetterAndSetter.standalone(false));
    }

    public ShelfMenu(IEContainerMenu.MenuContext ctx, IItemHandlerModifiable inventory, Inventory inventoryPlayer, GetterAndSetter<List<ItemStack>> cratesFront, GetterAndSetter<List<ItemStack>> cratesBack, GetterAndSetter<Boolean> backside) {
        super(ctx);
        int i;
        this.cratesFront = cratesFront;
        this.cratesBack = cratesBack;
        this.backside = backside;
        this.addGenericData(new GenericContainerData<List<ItemStack>>(GenericDataSerializers.ITEM_STACKS, cratesFront));
        this.addGenericData(new GenericContainerData<List<ItemStack>>(GenericDataSerializers.ITEM_STACKS, cratesBack));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, backside));
        for (int iCrate = 0; iCrate < 4; ++iCrate) {
            int x = iCrate % 2 * 176;
            int y = iCrate / 2 * 69;
            int crateIdx = iCrate;
            for (int iSlot = 0; iSlot < 27; ++iSlot) {
                int frontIndex = iCrate * 27 + iSlot;
                this.addSlot((Slot)new ShelfSlot((IItemHandler)inventory, frontIndex, 8 + x + iSlot % 9 * 18, 13 + y + iSlot / 9 * 18, crateIdx, () -> (Boolean)backside.get() == false, cratesFront));
                int backIndex = (4 + iCrate) * 27 + iSlot;
                this.addSlot((Slot)new ShelfSlot((IItemHandler)inventory, backIndex, 8 + x + iSlot % 9 * 18, 13 + y + iSlot / 9 * 18, crateIdx, backside, cratesBack));
            }
        }
        this.ownSlotCount = 216;
        int playerInvX = 88;
        int playerInvY = 138;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + playerInvX + j * 18, 13 + playerInvY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + playerInvX + i * 18, 71 + playerInvY));
        }
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        super.receiveMessageFromScreen(nbt);
        if (nbt.contains("backside", 1)) {
            this.backside.set(nbt.getBoolean("backside"));
        }
    }

    private static final class ShelfSlot
    extends ItemHandlerCopySlot {
        private final int crateIndex;
        private final Supplier<Boolean> isActive;
        private final Supplier<List<ItemStack>> getCrates;

        public ShelfSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, int crateIndex, Supplier<Boolean> isActive, Supplier<List<ItemStack>> getCrates) {
            super(itemHandler, index, xPosition, yPosition);
            this.crateIndex = crateIndex;
            this.isActive = isActive;
            this.getCrates = getCrates;
        }

        public boolean isActive() {
            if (!this.isActive.get().booleanValue()) {
                return false;
            }
            List<ItemStack> crates = this.getCrates.get();
            return this.crateIndex < crates.size() && !crates.get(this.crateIndex).isEmpty();
        }

        public boolean mayPlace(ItemStack stack) {
            return super.mayPlace(stack) && this.isActive();
        }
    }
}

