/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class MultiblockProcess<R extends MultiblockRecipe, CTX extends ProcessContext<R>> {
    private final ResourceLocation recipeId;
    private final BiFunction<Level, ResourceLocation, R> getRecipe;
    public int processTick;
    private LevelDependentData<R> levelData;
    public boolean clearProcess = false;
    private int extraProcessTicks = -1;

    public MultiblockProcess(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, R> getRecipe) {
        this.recipeId = recipeId;
        this.getRecipe = getRecipe;
        this.processTick = 0;
    }

    public MultiblockProcess(RecipeHolder<R> recipe) {
        this.recipeId = recipe.id();
        this.getRecipe = ($, $1) -> {
            throw new RuntimeException("A process initialized with a recipe should never query recipes");
        };
        this.processTick = 0;
        this.populateLevelData((MultiblockRecipe)recipe.value());
    }

    public MultiblockProcess(BiFunction<Level, ResourceLocation, R> getRecipe, CompoundTag data) {
        this(ResourceLocation.parse((String)data.getString("recipe")), getRecipe);
        this.processTick = data.getInt("process_processTick");
    }

    protected List<ItemStack> getRecipeItemOutputs(Level level, CTX context) {
        Object recipe = this.getLevelData((Level)level).recipe;
        if (recipe == null) {
            return List.of();
        }
        return recipe.getActualItemOutputs();
    }

    protected List<FluidStack> getRecipeFluidOutputs(Level level) {
        Object recipe = this.getLevelData((Level)level).recipe;
        if (recipe == null) {
            return List.of();
        }
        return recipe.getActualFluidOutputs();
    }

    public boolean canProcess(CTX context, Level level) {
        LevelDependentData<R> levelData = this.getLevelData(level);
        if (levelData.recipe == null) {
            return true;
        }
        if (context.getEnergy().extractEnergy(levelData.energyPerTick, true) == levelData.energyPerTick) {
            List<FluidStack> fluidOutputs;
            List<ItemStack> outputs = this.getRecipeItemOutputs(level, context);
            if (outputs != null) {
                for (ItemStack output : outputs) {
                    if (output.isEmpty() || this.canOutputItem(context, output)) continue;
                    return false;
                }
            }
            if ((fluidOutputs = ((MultiblockRecipe)levelData.recipe).getFluidOutputs()) != null) {
                for (FluidStack output : fluidOutputs) {
                    if (this.canOutputFluid(context, output)) continue;
                    return false;
                }
            }
            return context.additionalCanProcessCheck(this, level);
        }
        return false;
    }

    public void doProcessTick(CTX context, IMultiblockLevel level) {
        Level rawLevel = level.getRawLevel();
        LevelDependentData<R> levelData = this.getLevelData(rawLevel);
        if (levelData.recipe == null) {
            this.clearProcess = true;
            return;
        }
        context.getEnergy().extractEnergy(levelData.energyPerTick, false);
        ++this.processTick;
        if (this.extraProcessTicks < 0) {
            this.extraProcessTicks = levelData.recipe.getMultipleProcessTicks();
        }
        if (this.extraProcessTicks >= 0) {
            int averageExtraction;
            int averageInsertion = context.getEnergy().getAverageInsertion();
            if (averageInsertion < (averageExtraction = context.getEnergy().getAverageExtraction())) {
                this.extraProcessTicks = Math.max(0, this.extraProcessTicks - 1);
            } else if (averageInsertion > averageExtraction) {
                this.extraProcessTicks = Math.min(levelData.recipe.getMultipleProcessTicks(), this.extraProcessTicks + 1);
            }
            int possibleTicks = Math.min(Math.min(this.extraProcessTicks, levelData.maxTicks - this.processTick), Math.min(averageInsertion / levelData.energyPerTick, context.getEnergy().getEnergyStored() / levelData.energyPerTick));
            if (possibleTicks > 0) {
                context.getEnergy().extractEnergy(levelData.energyPerTick * possibleTicks, false);
                this.processTick += possibleTicks;
            }
        }
        if (this.processTick >= levelData.maxTicks) {
            this.processFinish(context, level);
        }
    }

    protected void processFinish(CTX context, IMultiblockLevel level) {
        List<FluidStack> fluidOutputs;
        Level rawLevel = level.getRawLevel();
        List<ItemStack> outputs = this.getRecipeItemOutputs(rawLevel, context);
        if (outputs != null) {
            for (ItemStack output : outputs) {
                this.outputItem(context, output, level);
            }
        }
        if ((fluidOutputs = this.getRecipeFluidOutputs(rawLevel)) != null) {
            for (FluidStack output : fluidOutputs) {
                this.outputFluid(context, output);
            }
        }
        context.onProcessFinish(this, level.getRawLevel());
        this.clearProcess = true;
    }

    public abstract void writeExtraDataToNBT(CompoundTag var1, HolderLookup.Provider var2);

    protected abstract boolean canOutputItem(CTX var1, ItemStack var2);

    protected abstract boolean canOutputFluid(CTX var1, FluidStack var2);

    protected abstract void outputItem(CTX var1, ItemStack var2, IMultiblockLevel var3);

    protected abstract void outputFluid(CTX var1, FluidStack var2);

    protected LevelDependentData<R> getLevelData(Level level) {
        if (this.levelData == null) {
            this.populateLevelData((MultiblockRecipe)this.getRecipe.apply(level, this.recipeId));
        }
        return this.levelData;
    }

    private void populateLevelData(R recipe) {
        if (recipe != null) {
            int maxTicks = ((MultiblockRecipe)recipe).getTotalProcessTime();
            int energyPerTick = ((MultiblockRecipe)recipe).getTotalProcessEnergy() / maxTicks;
            this.levelData = new LevelDependentData<R>(recipe, maxTicks, energyPerTick);
        } else {
            this.levelData = new LevelDependentData<Object>(null, 20, 0);
        }
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public int getMaxTicks(Level level) {
        return this.getLevelData((Level)level).maxTicks;
    }

    @Nullable
    public R getRecipe(Level level) {
        return this.getLevelData((Level)level).recipe;
    }

    protected record LevelDependentData<R extends MultiblockRecipe>(@Nullable R recipe, int maxTicks, int energyPerTick) {
    }
}

