/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ClocheRecipe
extends IESerializableRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<ClocheRecipe>> SERIALIZER;
    public final List<StackWithChance> outputs;
    public final Ingredient seed;
    public final Ingredient soil;
    public final int time;
    public final ClocheRenderFunction renderFunction;
    public static final CachedRecipeList<ClocheRecipe> RECIPES;
    private static final List<Pair<Ingredient, ResourceLocation>> soilTextureList;

    public ClocheRecipe(List<StackWithChance> outputs, Ingredient seed, Ingredient soil, int time, ClocheRenderFunction renderFunction) {
        super(outputs.get(0).stack(), IERecipeTypes.CLOCHE);
        this.outputs = outputs;
        this.seed = seed;
        this.soil = soil;
        this.time = time;
        this.renderFunction = renderFunction;
    }

    public ClocheRecipe(TagOutput output, Ingredient seed, Ingredient soil, int time, ClocheRenderFunction renderFunction) {
        this(List.of(new StackWithChance(output, 1.0f, new ICondition[0])), seed, soil, time, renderFunction);
    }

    public NonNullList<ItemStack> getOutputs(ItemStack seed, ItemStack soil) {
        NonNullList list = NonNullList.create();
        for (StackWithChance output : this.outputs) {
            ItemStack realStack = output.stack().get();
            if (realStack.isEmpty() || !(ApiUtils.RANDOM.nextFloat() < output.chance())) continue;
            list.add((Object)realStack);
        }
        return list;
    }

    public NonNullList<ItemStack> getTotalOutputs() {
        NonNullList list = NonNullList.createWithCapacity((int)this.outputs.size());
        for (StackWithChance output : this.outputs) {
            list.add((Object)output.stack().get());
        }
        return list;
    }

    public int getTime(ItemStack seed, ItemStack soil) {
        return this.time;
    }

    protected IERecipeSerializer<ClocheRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        return this.outputs.get(0).stack().get();
    }

    public static ClocheRecipe findRecipe(Level level, ItemStack seed, ItemStack soil, @Nullable ClocheRecipe hint) {
        if (seed.isEmpty() || soil.isEmpty()) {
            return null;
        }
        if (hint != null && hint.matches(seed, soil)) {
            return hint;
        }
        for (RecipeHolder<ClocheRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!((ClocheRecipe)recipe.value()).matches(seed, soil)) continue;
            return (ClocheRecipe)recipe.value();
        }
        return null;
    }

    public boolean matches(ItemStack seed, ItemStack soil) {
        return this.seed.test(seed) && this.soil.test(soil);
    }

    public static boolean isValidCombinationInMenu(ItemStack seed, ItemStack soil, Level level) {
        for (RecipeHolder<ClocheRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!seed.isEmpty() && !((ClocheRecipe)recipe.value()).seed.test(seed) || !soil.isEmpty() && !((ClocheRecipe)recipe.value()).soil.test(soil)) continue;
            return true;
        }
        return false;
    }

    public static void registerSoilTexture(Ingredient soil, ResourceLocation texture) {
        soilTextureList.add((Pair<Ingredient, ResourceLocation>)Pair.of((Object)soil, (Object)texture));
    }

    public static ResourceLocation getSoilTexture(ItemStack soil) {
        for (Pair<Ingredient, ResourceLocation> entry : soilTextureList) {
            if (!((Ingredient)entry.getFirst()).test(soil)) continue;
            return (ResourceLocation)entry.getSecond();
        }
        return null;
    }

    static {
        RECIPES = new CachedRecipeList<ClocheRecipe>(IERecipeTypes.CLOCHE);
        soilTextureList = new ArrayList<Pair<Ingredient, ResourceLocation>>();
    }
}

