/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes.builder;

import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.data.recipes.builder.BaseHelpers;
import blusunrize.immersiveengineering.data.recipes.builder.IERecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class SawmillRecipeBuilder
extends IERecipeBuilder<SawmillRecipeBuilder>
implements BaseHelpers.UnsizedItemInput<SawmillRecipeBuilder>,
BaseHelpers.ItemOutput<SawmillRecipeBuilder> {
    private Ingredient input;
    private TagOutput stripped = TagOutput.EMPTY;
    private final List<TagOutput> secondaryStripping = new ArrayList<TagOutput>();
    private TagOutput output;
    private final List<TagOutput> secondaryOutputs = new ArrayList<TagOutput>();
    private int energy;

    private SawmillRecipeBuilder() {
    }

    public static SawmillRecipeBuilder builder() {
        return new SawmillRecipeBuilder();
    }

    @Override
    public SawmillRecipeBuilder output(TagOutput output) {
        this.output = output;
        return this;
    }

    @Override
    public SawmillRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public SawmillRecipeBuilder setEnergy(int energy) {
        this.energy = energy;
        return this;
    }

    public SawmillRecipeBuilder addStripped(ItemLike stripped) {
        this.stripped = new TagOutput(stripped);
        return this;
    }

    public SawmillRecipeBuilder addStripSecondary(ItemLike secondary, int count) {
        this.secondaryStripping.add(new TagOutput(secondary, count));
        return this;
    }

    public SawmillRecipeBuilder addStripSecondary(TagKey<Item> stripped) {
        this.secondaryStripping.add(new TagOutput(stripped));
        return this;
    }

    public SawmillRecipeBuilder addSawSecondary(TagKey<Item> stripped) {
        this.secondaryOutputs.add(new TagOutput(stripped));
        return this;
    }

    public void build(RecipeOutput out, ResourceLocation name) {
        SawmillRecipe recipe = new SawmillRecipe(this.output, this.stripped, this.input, this.energy, new TagOutputList(this.secondaryStripping), new TagOutputList(this.secondaryOutputs));
        out.accept(name, (Recipe)recipe, null, this.getConditions());
    }
}

