/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes.builder;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.data.recipes.builder.BaseHelpers;
import blusunrize.immersiveengineering.data.recipes.builder.IERecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class MixerRecipeBuilder
extends IERecipeBuilder<MixerRecipeBuilder>
implements BaseHelpers.ItemInput<MixerRecipeBuilder> {
    private FluidStack fluidOutput;
    private SizedFluidIngredient fluidInput;
    private final List<IngredientWithSize> itemInputs = new ArrayList<IngredientWithSize>();
    private int energy;

    private MixerRecipeBuilder() {
    }

    public static MixerRecipeBuilder builder() {
        return new MixerRecipeBuilder();
    }

    @Override
    public MixerRecipeBuilder input(IngredientWithSize input) {
        this.itemInputs.add(input);
        return this;
    }

    public MixerRecipeBuilder setEnergy(int energy) {
        this.energy = energy;
        return this;
    }

    public MixerRecipeBuilder output(Fluid fluid, int amount) {
        this.fluidOutput = new FluidStack(fluid, amount);
        return this;
    }

    public MixerRecipeBuilder fluidInput(TagKey<Fluid> fluid, int amount) {
        this.fluidInput = SizedFluidIngredient.of(fluid, (int)amount);
        return this;
    }

    public void build(RecipeOutput out, ResourceLocation name) {
        MixerRecipe recipe = new MixerRecipe(this.fluidOutput, this.fluidInput, this.itemInputs, this.energy);
        out.accept(name, (Recipe)recipe, null, this.getConditions());
    }
}

