/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.models;

import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallback;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallbacks;
import blusunrize.immersiveengineering.client.models.obj.IEOBJLoader;
import blusunrize.immersiveengineering.data.models.ModelProviderUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class IEOBJBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private boolean dynamic = false;
    private ResourceLocation modelLocation = null;
    private IEOBJCallback<?> callback;
    private List<RenderType> layers;

    public static <T extends ModelBuilder<T>> IEOBJBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new IEOBJBuilder<T>(parent, existingFileHelper);
    }

    protected IEOBJBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(IEOBJLoader.LOADER_NAME, parent, existingFileHelper, false);
    }

    public IEOBJBuilder<T> modelLocation(ResourceLocation modelLocation) {
        this.modelLocation = modelLocation;
        return this;
    }

    public IEOBJBuilder<T> layer(RenderType ... layers) {
        if (this.layers == null) {
            this.layers = new ArrayList<RenderType>();
        }
        this.layers.addAll(Arrays.asList(layers));
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        Preconditions.checkNotNull(this.callback);
        Preconditions.checkNotNull((Object)this.modelLocation);
        json = super.toJson(json);
        json.addProperty("model", this.modelLocation.toString());
        if (this.dynamic) {
            json.addProperty("dynamic", Boolean.valueOf(true));
        }
        if (this.layers != null) {
            JsonArray types = new JsonArray();
            for (RenderType layer : this.layers) {
                types.add(ModelProviderUtils.getName(layer));
            }
            json.add("layers", (JsonElement)types);
        }
        json.addProperty("callbacks", IEOBJCallbacks.getName(this.callback).toString());
        return json;
    }

    public IEOBJBuilder<T> dynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public IEOBJBuilder<T> callback(IEOBJCallback<?> callback) {
        this.callback = callback;
        return this;
    }
}

