/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.manual.icon;

import blusunrize.immersiveengineering.common.wires.IEWireTypes;
import blusunrize.immersiveengineering.data.manual.icon.GameInitializationManager;
import blusunrize.immersiveengineering.data.manual.icon.ModelRenderer;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public record RenderedItemModelDataProvider(PackOutput output, ExistingFileHelper helper, Path itemOutputDirectory) implements DataProvider
{
    public CompletableFuture<?> run(CachedOutput pCache) {
        GameInitializationManager.getInstance().initialize(this.helper, this.output);
        IEWireTypes.setup();
        try (ModelRenderer itemRenderer = new ModelRenderer(256, 256, this.itemOutputDirectory.toFile());){
            Set<String> domainsToRender = Set.of("minecraft", "immersiveengineering");
            BuiltInRegistries.ITEM.stream().forEach(item -> {
                ResourceLocation name = BuiltInRegistries.ITEM.getKey(item);
                if (!domainsToRender.contains(name.getNamespace())) {
                    return;
                }
                ModelResourceLocation modelLocation = new ModelResourceLocation(name, "inventory");
                ItemStack stackToRender = item.getDefaultInstance();
                BakedModel model = Minecraft.getInstance().getModelManager().getModel(modelLocation);
                itemRenderer.renderModel(model, name.getNamespace() + "/" + name.getPath() + ".png", stackToRender);
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    public String getName() {
        return "Item Renderer";
    }
}

