/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.blockstates;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallback;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.client.models.obj.callback.block.BottlingMachineCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.ChunkLoaderCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.ClocheCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.ShelfCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.WorkbenchCallbacks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.data.blockstates.ExtendedBlockstateProvider;
import blusunrize.immersiveengineering.data.models.NongeneratedModels;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class MultiblockStates
extends ExtendedBlockstateProvider {
    private static final List<Vec3i> CUBE_THREE = BlockPos.betweenClosedStream((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1).map(BlockPos::immutable).collect(Collectors.toList());
    private static final List<Vec3i> CUBE_TWO = BlockPos.betweenClosedStream((int)0, (int)0, (int)-1, (int)1, (int)1, (int)0).map(BlockPos::immutable).collect(Collectors.toList());
    public final Map<Block, ModelFile> unsplitModels = new HashMap<Block, ModelFile>();
    public ModelFile blastFurnaceOff;
    public ModelFile blastFurnaceOn;
    public ModelFile cokeOvenOff;
    public ModelFile cokeOvenOn;
    public ModelFile alloySmelterOff;
    public ModelFile alloySmelterOn;

    public MultiblockStates(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createStoneMultiblocks();
        this.createMetalMultiblocks();
        this.createMultiblock((Supplier<? extends Block>)IEBlocks.MetalDevices.CLOCHE, this.splitDynamic((NongeneratedModels.NongeneratedModel)this.ieObjBuilder("block/metal_device/cloche.obj.ie", this.innerModels).callback((IEOBJCallback<?>)ClocheCallbacks.INSTANCE).layer(RenderType.solid(), RenderType.translucent()).end(), COLUMN_THREE));
        this.createMultiblock((Supplier<? extends Block>)IEBlocks.MetalDevices.TESLA_COIL, this.split(this.innerObj("block/metal_device/teslacoil.obj"), (List<Vec3i>)ImmutableList.of((Object)BlockPos.ZERO, (Object)new BlockPos(0, 0, -1))), null, (EnumProperty<Direction>)IEProperties.FACING_ALL, null);
        this.createMultiblock((Supplier<? extends Block>)IEBlocks.MetalDevices.BLAST_FURNACE_PREHEATER, this.split(this.innerObj("block/metal_device/blastfurnace_preheater.obj"), COLUMN_THREE));
    }

    private void createStoneMultiblocks() {
        this.blastFurnaceOff = this.cubeThree("blast_furnace_off", this.modLoc("block/multiblocks/blast_furnace"), this.modLoc("block/multiblocks/blast_furnace_off"));
        this.blastFurnaceOn = this.cubeThree("blast_furnace_on", this.modLoc("block/multiblocks/blast_furnace"), this.modLoc("block/multiblocks/blast_furnace_on"));
        this.cokeOvenOff = this.cubeThree("coke_oven_off", this.modLoc("block/multiblocks/coke_oven"), this.modLoc("block/multiblocks/coke_oven_off"));
        this.cokeOvenOn = this.cubeThree("coke_oven_on", this.modLoc("block/multiblocks/coke_oven"), this.modLoc("block/multiblocks/coke_oven_on"));
        this.alloySmelterOff = this.cubeTwo("alloy_smelter_off", this.modLoc("block/multiblocks/alloy_smelter_top"), this.modLoc("block/multiblocks/alloy_smelter_bottom"), this.modLoc("block/multiblocks/alloy_smelter_side"), this.modLoc("block/multiblocks/alloy_smelter_off"));
        this.alloySmelterOn = this.cubeTwo("alloy_smelter_on", this.modLoc("block/multiblocks/alloy_smelter_top"), this.modLoc("block/multiblocks/alloy_smelter_bottom"), this.modLoc("block/multiblocks/alloy_smelter_side"), this.modLoc("block/multiblocks/alloy_smelter_on"));
        this.createMultiblock(IEMultiblockLogic.COKE_OVEN.block(), this.cokeOvenOff, this.cokeOvenOn, (Property<Boolean>)IEProperties.ACTIVE);
        this.createMultiblock(IEMultiblockLogic.ALLOY_SMELTER.block(), this.alloySmelterOff, this.alloySmelterOn, (Property<Boolean>)IEProperties.ACTIVE);
        this.createMultiblock(IEMultiblockLogic.BLAST_FURNACE.block(), this.blastFurnaceOff, this.blastFurnaceOn, (Property<Boolean>)IEProperties.ACTIVE);
    }

    private void createMetalMultiblocks() {
        this.createMultiblock(this.innerObj("block/metal_multiblock/sawmill.obj"), IEMultiblocks.SAWMILL);
        this.createMultiblock(this.innerObj("block/metal_multiblock/excavator.obj"), IEMultiblocks.EXCAVATOR);
        this.createMultiblock(this.innerObj("block/metal_multiblock/crusher.obj"), IEMultiblocks.CRUSHER);
        this.createMultiblock(this.innerObj("block/metal_multiblock/metal_press.obj"), IEMultiblocks.METAL_PRESS);
        this.createMultiblock(this.innerObj("block/metal_multiblock/assembler.obj"), IEMultiblocks.ASSEMBLER);
        this.createMultiblock(this.innerObj("block/metal_multiblock/arc_furnace.obj"), IEMultiblocks.ARC_FURNACE);
        this.createMultiblock(this.innerObj("block/blastfurnace_advanced.obj"), IEMultiblocks.ADVANCED_BLAST_FURNACE);
        this.createMultiblock(this.innerObj("block/metal_multiblock/tank.obj", RenderType.cutoutMipped()), IEMultiblocks.SHEETMETAL_TANK);
        this.createMultiblock(this.innerObj("block/metal_multiblock/silo.obj"), IEMultiblocks.SILO);
        this.createDynamicMultiblock((NongeneratedModels.NongeneratedModel)this.ieObjBuilder("block/metal_multiblock/shelf.obj.ie", this.innerModels).callback((IEOBJCallback<?>)ShelfCallbacks.INSTANCE).end(), IEMultiblocks.SHELF);
        this.createDynamicMultiblock((NongeneratedModels.NongeneratedModel)this.ieObjBuilder("block/metal_multiblock/bottling_machine.obj.ie", this.innerModels).callback((IEOBJCallback<?>)BottlingMachineCallbacks.INSTANCE).layer(RenderType.solid(), RenderType.translucent()).end(), IEMultiblocks.BOTTLING_MACHINE);
        this.createMultiblock(this.innerObj("block/metal_multiblock/fermenter.obj"), IEMultiblocks.FERMENTER);
        this.createMultiblock(this.innerObj("block/metal_multiblock/squeezer.obj"), IEMultiblocks.SQUEEZER);
        this.createMultiblock(this.innerObj("block/metal_multiblock/mixer.obj"), IEMultiblocks.MIXER);
        this.createMultiblock(this.innerObj("block/metal_multiblock/refinery.obj"), IEMultiblocks.REFINERY);
        this.createMultiblock(this.innerObj("block/metal_multiblock/diesel_generator.obj", RenderType.cutoutMipped()), IEMultiblocks.DIESEL_GENERATOR);
        this.createMultiblock(IEMultiblockLogic.LIGHTNING_ROD.block(), this.split(this.innerObj("block/metal_multiblock/lightningrod.obj"), (TemplateMultiblock)IEMultiblocks.LIGHTNING_ROD));
        this.createMultiblock((Supplier<? extends Block>)IEBlocks.WoodenDevices.WORKBENCH, this.splitDynamic((NongeneratedModels.NongeneratedModel)this.ieObjBuilder("block/wooden_device/workbench.obj.ie", this.innerModels).callback((IEOBJCallback<?>)WorkbenchCallbacks.INSTANCE).end(), (List<Vec3i>)ImmutableList.of((Object)ModWorkbenchBlockEntity.MASTER_POS, (Object)ModWorkbenchBlockEntity.DUMMY_POS)), null, null);
        this.createMultiblock((Supplier<? extends Block>)IEBlocks.WoodenDevices.CIRCUIT_TABLE, this.split(this.innerObj("block/wooden_device/circuit_table.obj"), (List<Vec3i>)ImmutableList.of((Object)ModWorkbenchBlockEntity.MASTER_POS, (Object)ModWorkbenchBlockEntity.DUMMY_POS)), null, null);
        this.createMultiblock((Supplier<? extends Block>)IEBlocks.MetalDevices.SAMPLE_DRILL, this.split(this.innerObj("block/metal_device/core_drill.obj", RenderType.cutout()), (List<Vec3i>)ImmutableList.of((Object)BlockPos.ZERO, (Object)BlockPos.ZERO.above(), (Object)BlockPos.ZERO.above(2))), null, null);
        this.createMultiblock(this.innerObj("block/metal_multiblock/auto_workbench.obj"), IEMultiblocks.AUTO_WORKBENCH);
        this.createMultiblock((NongeneratedModels.NongeneratedModel)this.innerObj("block/metal_multiblock/radio_tower.obj", RenderType.cutout()).ao(false), IEMultiblocks.RADIO_TOWER);
        this.createDynamicMultiblock((NongeneratedModels.NongeneratedModel)this.ieObjBuilder("block/metal_multiblock/chunk_loader.obj.ie", this.innerModels).callback((IEOBJCallback<?>)ChunkLoaderCallbacks.INSTANCE).layer(RenderType.solid(), RenderType.cutout(), RenderType.translucent()).end(), IEMultiblocks.CHUNK_LOADER);
    }

    @Nonnull
    public String getName() {
        return "Multiblock models/block states";
    }

    private ModelFile cubeTwo(String name, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation front) {
        NongeneratedModels.NongeneratedModel baseModel = this.obj(name, ImmersiveEngineering.rl((String)"block/stone_multiblocks/cube_two.obj"), (Map<String, ResourceLocation>)ImmutableMap.builder().put((Object)"side", (Object)side).put((Object)"top", (Object)top).put((Object)"bottom", (Object)bottom).put((Object)"front", (Object)front).build(), this.innerModels);
        return this.splitModel(name + "_split", baseModel, CUBE_TWO, false);
    }

    private ModelFile cubeThree(String name, ResourceLocation def, ResourceLocation front) {
        NongeneratedModels.NongeneratedModel baseModel = this.obj(name, ImmersiveEngineering.rl((String)"block/stone_multiblocks/cube_three.obj"), (Map<String, ResourceLocation>)ImmutableMap.of((Object)"side", (Object)def, (Object)"front", (Object)front), this.innerModels);
        return this.splitModel(name + "_split", baseModel, CUBE_THREE, false);
    }

    private void createMultiblock(NongeneratedModels.NongeneratedModel unsplitModel, IETemplateMultiblock multiblock) {
        this.createMultiblock(unsplitModel, multiblock, false);
    }

    private void createDynamicMultiblock(NongeneratedModels.NongeneratedModel unsplitModel, IETemplateMultiblock multiblock) {
        this.createMultiblock(unsplitModel, multiblock, true);
    }

    private void createMultiblock(NongeneratedModels.NongeneratedModel unsplitModel, IETemplateMultiblock multiblock, boolean dynamic) {
        ModelFile mainModel = this.split(unsplitModel, (TemplateMultiblock)multiblock, false, dynamic);
        if (multiblock.getBlock().getStateDefinition().getProperties().contains(IEProperties.MIRRORED)) {
            this.createMultiblock(() -> ((IETemplateMultiblock)multiblock).getBlock(), mainModel, this.split(this.mirror(unsplitModel, this.innerModels), (TemplateMultiblock)multiblock, true, dynamic), (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, (Property<Boolean>)IEProperties.MIRRORED);
        } else {
            this.createMultiblock(() -> ((IETemplateMultiblock)multiblock).getBlock(), mainModel, null, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, null);
        }
    }

    private void createMultiblock(Supplier<? extends Block> b, ModelFile masterModel) {
        this.createMultiblock(b, masterModel, null, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, null);
    }

    private void createMultiblock(Supplier<? extends Block> b, ModelFile masterModel, @Nullable ModelFile mirroredModel, @Nullable Property<Boolean> mirroredState) {
        this.createMultiblock(b, masterModel, mirroredModel, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, mirroredState);
    }

    private void createMultiblock(Supplier<? extends Block> b, ModelFile masterModel, @Nullable ModelFile mirroredModel, EnumProperty<Direction> facing, @Nullable Property<Boolean> mirroredState) {
        this.unsplitModels.put(b.get(), masterModel);
        Preconditions.checkArgument((mirroredModel == null == (mirroredState == null) ? 1 : 0) != 0);
        VariantBlockStateBuilder builder = this.getVariantBuilder(b.get());
        boolean[] possibleMirrorStates = mirroredState != null ? new boolean[]{false, true} : new boolean[1];
        for (boolean mirrored : possibleMirrorStates) {
            for (Direction dir : facing.getPossibleValues()) {
                int angleY;
                int angleX;
                if (facing.getPossibleValues().contains(Direction.UP)) {
                    angleX = -90 * dir.getStepY();
                    angleY = dir.getAxis() != Direction.Axis.Y ? this.getAngle(dir, 180) : 0;
                } else {
                    angleY = this.getAngle(dir, 180);
                    angleX = 0;
                }
                ModelFile model = mirrored ? mirroredModel : masterModel;
                VariantBlockStateBuilder.PartialBlockstate partialState = builder.partialState().with(facing, (Comparable)dir);
                if (mirroredState != null) {
                    partialState = partialState.with(mirroredState, (Comparable)Boolean.valueOf(mirrored));
                }
                partialState.setModels(new ConfiguredModel[]{new ConfiguredModel(model, angleX, angleY, true)});
            }
        }
    }

    private ModelFile split(NongeneratedModels.NongeneratedModel loc, TemplateMultiblock mb) {
        return this.split(loc, mb, false);
    }

    private ModelFile split(NongeneratedModels.NongeneratedModel loc, TemplateMultiblock mb, boolean mirror) {
        return this.split(loc, mb, mirror, false);
    }

    private ModelFile split(NongeneratedModels.NongeneratedModel loc, TemplateMultiblock mb, boolean mirror, boolean dynamic) {
        UnaryOperator transform = UnaryOperator.identity();
        if (mirror) {
            this.loadTemplateFor(mb);
            Vec3i size = mb.getSize(null);
            transform = p -> new BlockPos(size.getX() - p.getX() - 1, p.getY(), p.getZ());
        }
        return this.split(loc, mb, transform, dynamic);
    }

    private ModelFile split(NongeneratedModels.NongeneratedModel name, TemplateMultiblock multiblock, UnaryOperator<BlockPos> transform, boolean dynamic) {
        this.loadTemplateFor(multiblock);
        BlockPos offset = multiblock.getMasterFromOriginOffset();
        Stream<Vec3i> partsStream = multiblock.getTemplate(null).blocksWithoutAir().stream().map(info -> info.pos()).map(transform).map(arg_0 -> MultiblockStates.lambda$split$2((Vec3i)offset, arg_0));
        return this.split(name, partsStream.collect(Collectors.toList()), dynamic);
    }

    private void loadTemplateFor(TemplateMultiblock multiblock) {
        ResourceLocation name = multiblock.getUniqueName();
        if (TemplateMultiblock.SYNCED_CLIENT_TEMPLATES.containsKey(name)) {
            return;
        }
        String filePath = "structure/" + name.getPath() + ".nbt";
        int slash = filePath.indexOf(47);
        String prefix = filePath.substring(0, slash);
        ResourceLocation shortLoc = ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)filePath.substring(slash + 1));
        try {
            Resource resource = this.existingFileHelper.getResource(shortLoc, PackType.SERVER_DATA, "", prefix);
            try (InputStream input = resource.open();){
                CompoundTag nbt = NbtIo.readCompressed((InputStream)input, (NbtAccounter)NbtAccounter.unlimitedHeap());
                StructureTemplate template = new StructureTemplate();
                template.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), nbt);
                TemplateMultiblock.SYNCED_CLIENT_TEMPLATES.put(name, template);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed on " + String.valueOf(name), e);
        }
    }

    private static /* synthetic */ Vec3i lambda$split$2(Vec3i offset, BlockPos p) {
        return p.subtract(offset);
    }
}

