/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockAdvancementTrigger;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class AdvancementBuilder {
    public static String page = null;
    private final Advancement.Builder builder = Advancement.Builder.recipeAdvancement();
    private final String name;
    private ItemStack icon;
    private ResourceLocation background = null;
    private AdvancementType frame = AdvancementType.TASK;
    private boolean hidden = false;
    private boolean quiet = false;

    private AdvancementBuilder(String name) {
        assert (page != null);
        this.name = name;
    }

    public static void setPage(String page) {
        AdvancementBuilder.page = page;
    }

    public static AdvancementBuilder hiddenRoot() {
        return new AdvancementBuilder(page + "_root");
    }

    public static AdvancementBuilder root(String bg) {
        return new AdvancementBuilder(page + "_root").background(IEApi.ieLoc((String)("textures/" + bg + ".png")));
    }

    public static AdvancementBuilder child(String name, AdvancementHolder parent) {
        return new AdvancementBuilder(name).parent(parent);
    }

    public AdvancementBuilder getItem(ItemLike item) {
        return this.icon(item).hasItems(item);
    }

    public AdvancementBuilder placeBlock(IEBlocks.BlockEntry<?> block) {
        return this.icon((ItemLike)block).addCriterion("place_block", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)block.get()));
    }

    public AdvancementBuilder multiblock(IETemplateMultiblock multiblock) {
        return this.icon((ItemLike)multiblock.getBlock()).addCriterion("form_multiblock", MultiblockAdvancementTrigger.create((ResourceLocation)multiblock.getUniqueName(), (ItemPredicate)ItemPredicate.Builder.item().of(new ItemLike[]{IEItems.Tools.HAMMER}).build()));
    }

    private AdvancementBuilder parent(AdvancementHolder parent) {
        this.builder.parent(parent);
        return this;
    }

    private AdvancementBuilder background(ResourceLocation background) {
        this.background = background;
        return this;
    }

    public AdvancementBuilder icon(ItemStack icon) {
        this.icon = icon;
        return this;
    }

    public AdvancementBuilder icon(ItemLike icon) {
        return this.icon(new ItemStack(icon));
    }

    public AdvancementBuilder goal() {
        this.frame = AdvancementType.GOAL;
        return this;
    }

    public AdvancementBuilder challenge() {
        this.frame = AdvancementType.CHALLENGE;
        return this;
    }

    public AdvancementBuilder hidden() {
        this.hidden = true;
        return this;
    }

    public AdvancementBuilder quiet() {
        this.quiet = true;
        return this;
    }

    public AdvancementBuilder loot(String lootPath) {
        this.builder.rewards(new AdvancementRewards(0, List.of(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)IEApi.ieLoc((String)("advancements/" + lootPath)))), List.of(), Optional.empty()));
        return this;
    }

    public AdvancementBuilder addCriterion(String key, Criterion<?> criterion) {
        this.builder.addCriterion(key, criterion);
        return this;
    }

    public AdvancementBuilder orRequirements() {
        this.builder.requirements(AdvancementRequirements.Strategy.OR);
        return this;
    }

    public AdvancementBuilder hasItems(ItemLike ... items) {
        return this.addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(items).build()}));
    }

    public <T extends ItemSubPredicate> AdvancementBuilder hasItemWithPredicate(ItemLike item, ItemSubPredicate.Type<T> type, T subPredicate) {
        return this.addCriterion("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{item}).withSubPredicate(type, subPredicate).build()}));
    }

    public AdvancementBuilder placeBlocks(Collection<? extends IEBlocks.BlockEntry<?>> blocks) {
        blocks.stream().sorted(Comparator.comparing(IEBlocks.BlockEntry::getId)).forEachOrdered(block -> this.addCriterion(block.getId().getPath(), ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)block.get())));
        return this;
    }

    public AdvancementBuilder talkToVillagers(ResourceLocation ... professions) {
        Arrays.stream(professions).sorted(Comparator.comparing(ResourceLocation::getPath)).forEachOrdered(prof -> {
            CompoundTag villagerData = new CompoundTag();
            villagerData.putString("profession", prof.toString());
            CompoundTag entityNBT = new CompoundTag();
            entityNBT.put("VillagerData", (Tag)villagerData);
            ContextAwarePredicate isRightVillager = EntityPredicate.wrap((EntityPredicate)EntityPredicate.Builder.entity().of(EntityType.VILLAGER).nbt(new NbtPredicate(entityNBT)).build());
            this.addCriterion("meet_" + prof.getPath(), PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity(Optional.empty(), (ItemPredicate.Builder)ItemPredicate.Builder.item(), Optional.of(isRightVillager)));
        });
        return this;
    }

    public AdvancementBuilder codeTriggered() {
        return this.addCriterion("code_trigger", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()));
    }

    private Advancement.Builder withDisplay() {
        if (this.icon == null) {
            return this.builder;
        }
        return this.builder.display(new DisplayInfo(this.icon, (Component)Component.translatable((String)("advancement.immersiveengineering." + this.name)), (Component)Component.translatable((String)("advancement.immersiveengineering." + this.name + ".desc")), Optional.ofNullable(this.background), this.frame, !this.quiet, !this.quiet, this.hidden));
    }

    public void saveForManual(Consumer<AdvancementHolder> consumer) {
        this.builder.display(new DisplayInfo(new ItemStack((ItemLike)IEItems.Tools.MANUAL), CommonComponents.EMPTY, CommonComponents.EMPTY, Optional.empty(), AdvancementType.TASK, true, false, true)).save(consumer, "immersiveengineering:" + page + "/" + this.name);
    }

    public AdvancementHolder save(Consumer<AdvancementHolder> consumer) {
        return this.withDisplay().save(consumer, "immersiveengineering:" + page + "/" + this.name);
    }
}

