/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.ShelfLogic;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import blusunrize.immersiveengineering.mixin.accessors.ContainerAccess;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ShelfMenu
extends IEContainerMenu {
    public static final int MAX_SLOTS = 108;
    public static final int COLUMN_WIDTH = 176;
    public static final int CRATE_SEGMENT = 69;
    public static final int INV_SEGMENT = 94;
    private final Inventory inventoryPlayer;
    public final GetterAndSetter<List<ItemStack>> crates;
    public final GetterAndSetter<Boolean> backside;

    public static ShelfMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, IEContainerMenu.MultiblockMenuContext<ShelfLogic.State> ctx) {
        ShelfLogic.State state = ctx.mbContext().getState();
        BlockPos pos = ctx.mbContext().getLevel().toRelative(ctx.clickedPos());
        GetterAndSetter<Boolean> backside = GetterAndSetter.standalone(false);
        return new ShelfMenu(ShelfMenu.multiblockCtx(type, id, ctx), invPlayer, GetterAndSetter.getterOnly(() -> state.getCrates(pos, (Boolean)backside.get())), backside);
    }

    public static ShelfMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new ShelfMenu(ShelfMenu.clientCtx(type, id), invPlayer, GetterAndSetter.standalone(List.of()), GetterAndSetter.standalone(false));
    }

    public ShelfMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, GetterAndSetter<List<ItemStack>> crates, GetterAndSetter<Boolean> backside) {
        super(ctx);
        this.inventoryPlayer = inventoryPlayer;
        this.crates = crates;
        this.backside = backside;
        this.rebindSlots();
        this.addGenericData(new GenericContainerData<List<ItemStack>>(GenericDataSerializers.ITEM_STACKS, crates));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, backside));
    }

    @Override
    public void receiveSync(List<Pair<Integer, GenericDataSerializers.DataPair<?>>> synced) {
        super.receiveSync(synced);
        this.rebindSlots();
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        super.receiveMessageFromScreen(nbt);
        if (nbt.contains("backside", 1)) {
            this.backside.set(nbt.getBoolean("backside"));
        }
        this.rebindSlots();
    }

    public void rebindSlots() {
        int i;
        this.slots.clear();
        ((ContainerAccess)((Object)this)).getLastSlots().clear();
        ((ContainerAccess)((Object)this)).getRemoteSlots().clear();
        this.ownSlotCount = 0;
        int iCrate = 0;
        for (final ItemStack crate : this.crates.get()) {
            NonNullList crateItems = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
            ItemContainerContents contents = (ItemContainerContents)crate.get(DataComponents.CONTAINER);
            if (contents != null) {
                contents.copyInto(crateItems);
            }
            ItemStackHandler crateInventory = new ItemStackHandler(this, crateItems){

                protected void onContentsChanged(int slot) {
                    crate.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.stacks));
                }
            };
            int x = iCrate % 2 * 176;
            int y = iCrate / 2 * 69;
            for (int iSlot = 0; iSlot < crateInventory.getSlots(); ++iSlot) {
                this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)crateInventory, iSlot, 8 + x + iSlot % 9 * 18, 13 + y + iSlot / 9 * 18){

                    public boolean mayPlace(ItemStack stack) {
                        return IEApi.isAllowedInCrate(stack);
                    }
                });
            }
            ++iCrate;
            this.ownSlotCount += crateInventory.getSlots();
        }
        while (this.ownSlotCount < 108) {
            this.addSlot(new IESlot.AlwaysEmptySlot(this));
            ++this.ownSlotCount;
        }
        int playerInvX = (iCrate = Math.max(iCrate, 1)) > 1 ? 88 : 0;
        int playerInvY = (iCrate + 1) / 2 * 69;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.inventoryPlayer, j + i * 9 + 9, 8 + playerInvX + j * 18, 13 + playerInvY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.inventoryPlayer, i, 8 + playerInvX + i * 18, 71 + playerInvY));
        }
        ImmersiveEngineering.proxy.reInitGui();
    }
}

