/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.items.PowerpackItem;
import blusunrize.immersiveengineering.common.register.IEPotions;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;

@EventBusSubscriber(modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class CrateItem
extends BlockItemIE {
    public CrateItem(Block b, Item.Properties props) {
        super(b, props);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        ItemContainerContents items = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (items != null && items.nonEmptyItems().iterator().hasNext()) {
            return null;
        }
        return EquipmentSlot.CHEST;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isCrouching() && itemSlot == PowerpackItem.CHEST_SLOT) {
            MobEffectInstance effect = player.getEffect(IEPotions.INCOGNITO);
            if (effect != null && effect.getAmplifier() < 1 && effect.getDuration() < 20) {
                player.addEffect(new MobEffectInstance(IEPotions.INCOGNITO, -1, 1, false, false, true));
            } else if (effect == null && player.getDeltaMovement().x == 0.0 && player.getDeltaMovement().z == 0.0) {
                player.addEffect(new MobEffectInstance(IEPotions.INCOGNITO, 60, 0, false, false, true));
            }
        }
    }

    @SubscribeEvent
    public static void adjustVisibility(LivingEvent.LivingVisibilityEvent event) {
        MobEffectInstance effect = event.getEntity().getEffect(IEPotions.INCOGNITO);
        if (effect == null) {
            return;
        }
        if (effect.getAmplifier() > 0) {
            event.modifyVisibility(0.0);
        } else {
            event.modifyVisibility(0.125);
        }
    }

    @SubscribeEvent
    public static void preventTargeting(LivingChangeTargetEvent event) {
        LivingEntity livingEntity;
        if (event.getTargetType() == LivingChangeTargetEvent.LivingTargetType.MOB_TARGET && (livingEntity = event.getEntity()) instanceof Mob) {
            LivingEntity effect;
            Player player;
            Mob mob = (Mob)livingEntity;
            livingEntity = event.getOriginalAboutToBeSetTarget();
            if (livingEntity instanceof Player && (livingEntity = (player = (Player)livingEntity).getEffect(IEPotions.INCOGNITO)) instanceof MobEffectInstance && (effect = livingEntity).getAmplifier() > 0) {
                event.setNewAboutToBeSetTarget(null);
            }
        }
    }
}

