/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes.builder;

import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.data.recipes.builder.IERecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class RefineryRecipeBuilder
extends IERecipeBuilder<RefineryRecipeBuilder> {
    private FluidStack output;
    private SizedFluidIngredient input0;
    private SizedFluidIngredient input1;
    private Ingredient catalyst = Ingredient.EMPTY;
    private int energy;

    private RefineryRecipeBuilder() {
    }

    public static RefineryRecipeBuilder builder() {
        return new RefineryRecipeBuilder();
    }

    public RefineryRecipeBuilder output(Fluid output, int amount) {
        return this.output(new FluidStack(output, amount));
    }

    public RefineryRecipeBuilder setEnergy(int energy) {
        this.energy = energy;
        return this;
    }

    public RefineryRecipeBuilder output(FluidStack output) {
        this.output = output;
        return this;
    }

    public RefineryRecipeBuilder catalyst(TagKey<Item> catalyst) {
        this.catalyst = Ingredient.of(catalyst);
        return this;
    }

    public RefineryRecipeBuilder input(TagKey<Fluid> fluid, int amount) {
        return this.input(SizedFluidIngredient.of(fluid, (int)amount));
    }

    public RefineryRecipeBuilder input(SizedFluidIngredient input) {
        if (this.input0 == null) {
            this.input0 = input;
        } else {
            this.input1 = input;
        }
        return this;
    }

    public void build(RecipeOutput out, ResourceLocation name) {
        RefineryRecipe recipe = new RefineryRecipe(this.output, this.input0, this.input1, this.catalyst, this.energy);
        out.accept(name, (Recipe)recipe, null, this.getConditions());
    }
}

