/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.client.utils.ClocheRenderFunctions;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.data.recipes.IERecipeProvider;
import blusunrize.immersiveengineering.data.recipes.builder.ClocheFertilizerBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.ClocheRecipeBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;

public class ClocheRecipes
extends IERecipeProvider {
    public ClocheRecipes(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> provider) {
        super(p_248933_, provider);
    }

    protected void buildRecipes(RecipeOutput out) {
        this.fertilizers(out);
        this.simpleCrops(out);
        this.stemCrops(out);
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.TORCHFLOWER)).seed((ItemLike)Items.TORCHFLOWER_SEEDS).soil((ItemLike)Blocks.DIRT).setTime(1200).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionCrop(Blocks.TORCHFLOWER_CROP)).build(out, this.toRL("cloche/torchflower"));
        this.stackingCrops(out);
        this.mushrooms(out);
        this.flowers(out);
        this.plants(out);
    }

    private void fertilizers(RecipeOutput out) {
        ((ClocheFertilizerBuilder)ClocheFertilizerBuilder.builder(1.1f).input((TagKey<Item>)IETags.sulfurDust)).build(out, this.toRL("fertilizer/sulfur"));
        ((ClocheFertilizerBuilder)ClocheFertilizerBuilder.builder(1.3f).input((TagKey<Item>)IETags.slag)).build(out, this.toRL("fertilizer/slag"));
        ((ClocheFertilizerBuilder)ClocheFertilizerBuilder.builder(1.2f).input((TagKey<Item>)IETags.saltpeterDust)).build(out, this.toRL("fertilizer/saltpeter"));
        ((ClocheFertilizerBuilder)ClocheFertilizerBuilder.builder(1.3f).input((ItemLike)Items.BONE_MEAL)).build(out, this.toRL("fertilizer/bonemeal"));
        ((ClocheFertilizerBuilder)ClocheFertilizerBuilder.builder(1.6f).input((ItemLike)IEItems.Misc.FERTILIZER)).build(out, this.toRL("fertilizer/fertilizer"));
    }

    private void plants(RecipeOutput out) {
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Blocks.SHORT_GRASS)).seed((ItemLike)Blocks.SHORT_GRASS).soil((ItemLike)Blocks.COARSE_DIRT).setTime(480).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionGeneric(Blocks.SHORT_GRASS)).build(out, this.toRL("cloche/" + Blocks.SHORT_GRASS.builtInRegistryHolder().key().location().getPath()));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Blocks.FERN)).seed((ItemLike)Blocks.FERN).soil((ItemLike)Blocks.COARSE_DIRT).setTime(480).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionGeneric(Blocks.FERN)).build(out, this.toRL("cloche/" + Blocks.FERN.builtInRegistryHolder().key().location().getPath()));
    }

    private void flowers(RecipeOutput out) {
        this.flower(out, Blocks.RED_TULIP);
        this.flower(out, Blocks.ORANGE_TULIP);
        this.flower(out, Blocks.WHITE_TULIP);
        this.flower(out, Blocks.PINK_TULIP);
        this.flower(out, Blocks.DANDELION);
        this.flower(out, Blocks.POPPY);
        this.flower(out, Blocks.OXEYE_DAISY);
        this.flower(out, Blocks.AZURE_BLUET);
        this.flower(out, Blocks.ALLIUM);
        this.flower(out, Blocks.LILY_OF_THE_VALLEY);
        this.flower(out, Blocks.CORNFLOWER);
        this.flower(out, Blocks.BLUE_ORCHID, (ItemLike)Blocks.MUD);
        this.doubleFlower(out, Blocks.LILAC);
        this.doubleFlower(out, Blocks.SUNFLOWER);
        this.doubleFlower(out, Blocks.ROSE_BUSH);
        this.doubleFlower(out, Blocks.PEONY);
        this.flower(out, Blocks.WITHER_ROSE, (ItemLike)Blocks.SOUL_SOIL);
    }

    private void flower(RecipeOutput out, Block flowerBlock, ItemLike soil) {
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)flowerBlock)).seed((ItemLike)flowerBlock).soil(soil).setTime(480).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionGeneric(flowerBlock)).build(out, this.toRL("cloche/" + flowerBlock.builtInRegistryHolder().key().location().getPath()));
    }

    private void doubleFlower(RecipeOutput out, Block flowerBlock, ItemLike soil) {
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)flowerBlock)).seed((ItemLike)flowerBlock).soil(soil).setTime(480).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionDoubleFlower(flowerBlock)).build(out, this.toRL("cloche/" + flowerBlock.builtInRegistryHolder().key().location().getPath()));
    }

    private void flower(RecipeOutput out, Block flowerBlock) {
        this.flower(out, flowerBlock, (ItemLike)Blocks.DIRT);
    }

    private void doubleFlower(RecipeOutput out, Block flowerBlock) {
        this.doubleFlower(out, flowerBlock, (ItemLike)Blocks.DIRT);
    }

    private void mushrooms(RecipeOutput out) {
        Ingredient shroomSoil = Ingredient.of((ItemLike[])new ItemLike[]{Blocks.MYCELIUM, Blocks.PODZOL});
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.RED_MUSHROOM)).seed((ItemLike)Items.RED_MUSHROOM).soil(shroomSoil).setTime(480).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionGeneric(Blocks.RED_MUSHROOM)).build(out, this.toRL("cloche/red_mushroom"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.BROWN_MUSHROOM)).seed((ItemLike)Items.BROWN_MUSHROOM).soil(shroomSoil).setTime(480).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionGeneric(Blocks.BROWN_MUSHROOM)).build(out, this.toRL("cloche/brown_mushroom"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.WARPED_FUNGUS)).seed((ItemLike)Items.WARPED_FUNGUS).soil((ItemLike)Blocks.WARPED_NYLIUM).setTime(560).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionGeneric(Blocks.WARPED_FUNGUS)).build(out, this.toRL("cloche/warped_fungus"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.CRIMSON_FUNGUS)).seed((ItemLike)Items.CRIMSON_FUNGUS).soil((ItemLike)Blocks.CRIMSON_NYLIUM).setTime(560).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionGeneric(Blocks.CRIMSON_FUNGUS)).build(out, this.toRL("cloche/crimson_fungus"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.MOSS_BLOCK)).seed((ItemLike)Items.MOSS_BLOCK).soil((TagKey<Item>)Tags.Items.COBBLESTONES).setTime(1200).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionGeneric(Blocks.MOSS_CARPET)).build(out, this.toRL("cloche/moss"));
    }

    private void stackingCrops(RecipeOutput out) {
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.SUGAR_CANE)).seed((ItemLike)Items.SUGAR_CANE).soil((TagKey<Item>)Tags.Items.SANDS).setTime(560).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionStacking(Blocks.SUGAR_CANE)).build(out, this.toRL("cloche/sugar_cane"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.CACTUS)).seed((ItemLike)Items.CACTUS).soil((TagKey<Item>)Tags.Items.SANDS).setTime(560).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionStacking(Blocks.CACTUS)).build(out, this.toRL("cloche/cactus"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.BAMBOO)).seed((ItemLike)Items.BAMBOO).soil((ItemLike)Blocks.DIRT).setTime(560).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionStacking(Blocks.BAMBOO)).build(out, this.toRL("cloche/bamboo"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.CHORUS_FRUIT)).seed((ItemLike)Items.CHORUS_FLOWER).soil((ItemLike)Blocks.END_STONE).setTime(480).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionChorus()).build(out, this.toRL("cloche/chorus_fruit"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)IEItems.Ingredients.HEMP_FIBER)).output((ItemLike)IEItems.Misc.HEMP_SEEDS, 0.5f, new ICondition[0]).seed((ItemLike)IEItems.Misc.HEMP_SEEDS).soil((ItemLike)Blocks.DIRT).setTime(800).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionDoubleCrop(IEBlocks.Misc.HEMP_PLANT.get(), 3)).build(out, this.toRL("cloche/hemp"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.PITCHER_PLANT)).seed((ItemLike)Items.PITCHER_POD).soil((ItemLike)Blocks.DIRT).setTime(1200).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionDoubleCrop(Blocks.PITCHER_CROP, 3)).build(out, this.toRL("cloche/pitcher_plant"));
    }

    private void stemCrops(RecipeOutput out) {
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.PUMPKIN)).seed((ItemLike)Items.PUMPKIN_SEEDS).soil((ItemLike)Blocks.DIRT).setTime(800).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionStem(Blocks.PUMPKIN, Blocks.PUMPKIN_STEM, Blocks.ATTACHED_PUMPKIN_STEM)).build(out, this.toRL("cloche/pumpkin"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output((ItemLike)Items.MELON)).seed((ItemLike)Items.MELON_SEEDS).soil((ItemLike)Blocks.DIRT).setTime(800).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionStem(Blocks.MELON, Blocks.MELON_STEM, Blocks.ATTACHED_MELON_STEM)).build(out, this.toRL("cloche/melon"));
    }

    private void simpleCrops(RecipeOutput out) {
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output(Items.WHEAT, 2)).output((ItemLike)Items.WHEAT_SEEDS, 0.25f, new ICondition[0]).seed((ItemLike)Items.WHEAT_SEEDS).soil((ItemLike)Blocks.DIRT).setTime(640).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionCrop(Blocks.WHEAT)).build(out, this.toRL("cloche/wheat"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output(new ItemStack((ItemLike)Items.POTATO, 2))).seed((ItemLike)Items.POTATO).soil((ItemLike)Blocks.DIRT).setTime(800).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionCrop(Blocks.POTATOES)).build(out, this.toRL("cloche/potato"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output(new ItemStack((ItemLike)Items.CARROT, 2))).seed((ItemLike)Items.CARROT).soil((ItemLike)Blocks.DIRT).setTime(800).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionCrop(Blocks.CARROTS)).build(out, this.toRL("cloche/carrot"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output(new ItemStack((ItemLike)Items.BEETROOT, 2))).output((ItemLike)Items.BEETROOT_SEEDS, 0.25f, new ICondition[0]).seed((ItemLike)Items.BEETROOT_SEEDS).soil((ItemLike)Blocks.DIRT).setTime(800).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionCrop(Blocks.BEETROOTS)).build(out, this.toRL("cloche/beetroot"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output(new ItemStack((ItemLike)Items.NETHER_WART, 2))).seed((ItemLike)Items.NETHER_WART).soil((ItemLike)Blocks.SOUL_SAND).setTime(800).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionCrop(Blocks.NETHER_WART)).build(out, this.toRL("cloche/nether_wart"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output(new ItemStack((ItemLike)Items.SWEET_BERRIES, 2))).seed((ItemLike)Items.SWEET_BERRIES).soil((ItemLike)Blocks.DIRT).setTime(560).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionCrop(Blocks.SWEET_BERRY_BUSH)).build(out, this.toRL("cloche/sweet_berries"));
        ((ClocheRecipeBuilder)ClocheRecipeBuilder.builder().output(new ItemStack((ItemLike)Items.GLOW_BERRIES, 1))).seed((ItemLike)Items.GLOW_BERRIES).soil((ItemLike)Blocks.MOSS_BLOCK).setTime(640).setRender((ClocheRenderFunction)new ClocheRenderFunctions.RenderFunctionCrop(Blocks.CAVE_VINES)).build(out, this.toRL("cloche/glow_berries"));
    }
}

