/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.manual;

import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.data.manual.TagExports;
import blusunrize.immersiveengineering.data.manual.icon.RenderedItemModelDataProvider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.util.Unit;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ManualDataGenerator {
    private static final String README_CONTENTS = "Minecraft's item icons (as found in `icons/minecraft` are used inaccordance with Mojang's [Asset Usage Guidelines](https://www.minecraft.net/en-us/terms#terms-brand_guidelines)\n";

    public static void addProviders(DataGenerator gen, ExistingFileHelper exHelper) {
        String outputTo = System.getenv("ie_manual_datagen_path");
        if (outputTo == null) {
            IELogger.logger.info("Skipping manual exports since the output directory is not set");
            return;
        }
        try {
            Path mainOutput = Path.of(outputTo, new String[0]);
            Files.createDirectories(mainOutput, new FileAttribute[0]);
            Path readme = mainOutput.resolve("README.md");
            try (BufferedWriter readmeWriter = Files.newBufferedWriter(readme, StandardCharsets.UTF_8, new OpenOption[0]);){
                readmeWriter.write(README_CONTENTS, 0, README_CONTENTS.length());
            }
            PackOutput output = gen.getPackOutput();
            gen.addProvider(true, (DataProvider)new RenderedItemModelDataProvider(output, exHelper, mainOutput.resolve("icons")));
            gen.addProvider(true, (DataProvider)new TagExports(output, exHelper, mainOutput.resolve("tags")));
        }
        catch (IOException xcp) {
            throw new RuntimeException(xcp);
        }
    }

    public static ReloadableResourceManager makeFullResourceManager(PackType type, PackOutput output, ExistingFileHelper helper) {
        MultiPackResourceManager nonGeneratedManager = (MultiPackResourceManager)ObfuscationReflectionHelper.getPrivateValue(ExistingFileHelper.class, (Object)helper, (String)(type == PackType.CLIENT_RESOURCES ? "clientResources" : "serverData"));
        List allSources = nonGeneratedManager.listPacks().collect(Collectors.toList());
        allSources.add(new PathPackResources(new PackLocationInfo("generated", (Component)Component.literal((String)"generated"), PackSource.BUILT_IN, Optional.empty()), output.getOutputFolder()));
        ReloadableResourceManager resourceManager = new ReloadableResourceManager(type);
        resourceManager.createReload((Executor)Util.backgroundExecutor(), (Executor)Minecraft.getInstance(), CompletableFuture.completedFuture(Unit.INSTANCE), allSources);
        return resourceManager;
    }
}

