/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.mixin.accessors.PaletteAccess;
import blusunrize.immersiveengineering.mixin.accessors.TemplateAccess;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageMultiblockSync(List<SyncedTemplate> templates) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageMultiblockSync> ID = IMessage.createType("multiblock_sync");
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageMultiblockSync> CODEC = SyncedTemplate.CODEC.apply(ByteBufCodecs.list()).map(MessageMultiblockSync::new, MessageMultiblockSync::templates);

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            for (SyncedTemplate synced : this.templates) {
                StructureTemplate template = new StructureTemplate();
                TemplateAccess access = (TemplateAccess)template;
                access.setSize((Vec3i)synced.size);
                access.getPalettes().add(synced.parts);
                TemplateMultiblock.SYNCED_CLIENT_TEMPLATES.put(synced.name, template);
            }
            ImmersiveEngineering.proxy.resetManual();
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public record SyncedTemplate(BlockPos size, ResourceLocation name, StructureTemplate.Palette parts) {
        private static final StreamCodec<RegistryFriendlyByteBuf, StructureTemplate.StructureBlockInfo> BLOCK_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, StructureTemplate.StructureBlockInfo::pos, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), StructureTemplate.StructureBlockInfo::state, (StreamCodec)ByteBufCodecs.OPTIONAL_COMPOUND_TAG, s -> Optional.ofNullable(s.nbt()), (pos, block, nbt) -> new StructureTemplate.StructureBlockInfo(pos, block, (CompoundTag)nbt.orElse(null)));
        private static final StreamCodec<RegistryFriendlyByteBuf, StructureTemplate.Palette> PALETTE_CODEC = BLOCK_CODEC.apply(ByteBufCodecs.list()).map(PaletteAccess::construct, StructureTemplate.Palette::blocks);
        public static final StreamCodec<RegistryFriendlyByteBuf, SyncedTemplate> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncedTemplate::size, (StreamCodec)ResourceLocation.STREAM_CODEC, SyncedTemplate::name, PALETTE_CODEC, SyncedTemplate::parts, SyncedTemplate::new);

        public SyncedTemplate(StructureTemplate template, ResourceLocation name) {
            this(new BlockPos(template.getSize()), name, ((TemplateAccess)template).getPalettes().get(0));
        }
    }
}

