/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.common.blocks.wooden.WoodenCrateBlockEntity;
import blusunrize.immersiveengineering.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageCrateName(BlockPos pos, String name) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageCrateName> ID = IMessage.createType("crate_name");
    public static final StreamCodec<ByteBuf, MessageCrateName> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, MessageCrateName::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, MessageCrateName::name, MessageCrateName::new);

    public MessageCrateName(BlockEntity tile, String name) {
        this(tile.getBlockPos(), name);
    }

    @Override
    public void process(IPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                BlockEntity tile;
                Level world = context.player().level();
                if (world.isAreaLoaded(this.pos, 1) && (tile = world.getBlockEntity(this.pos)) instanceof WoodenCrateBlockEntity) {
                    WoodenCrateBlockEntity crate = (WoodenCrateBlockEntity)tile;
                    crate.setCustomName((Component)Component.literal((String)this.name));
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

