/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.codec.StreamCodec;

public class FastEither<L, R> {
    private final L left;
    private final R right;

    private FastEither(L left, R right) {
        Preconditions.checkState((boolean)(left != null ^ right != null));
        this.left = left;
        this.right = right;
    }

    public static <L, R> FastEither<L, R> fromDFU(Either<L, R> l) {
        return (FastEither)l.map(FastEither::left, FastEither::right);
    }

    public static <L, R> FastEither<L, R> left(L l) {
        return new FastEither<L, Object>(l, null);
    }

    public static <L, R> FastEither<L, R> right(R r) {
        return new FastEither<Object, R>(null, r);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public L leftNonnull() {
        return (L)Preconditions.checkNotNull(this.left);
    }

    public R rightNonnull() {
        return (R)Preconditions.checkNotNull(this.right);
    }

    public Optional<R> rightOptional() {
        return Optional.ofNullable(this.right);
    }

    public Optional<L> leftOptional() {
        return Optional.ofNullable(this.left);
    }

    public <T> T map(Function<L, T> left, Function<R, T> right) {
        if (this.isLeft()) {
            return left.apply(this.leftNonnull());
        }
        return right.apply(this.rightNonnull());
    }

    public void consume(Consumer<L> left, Consumer<R> right) {
        if (this.isLeft()) {
            left.accept(this.leftNonnull());
        } else {
            right.accept(this.rightNonnull());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FastEither that = (FastEither)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public Either<L, R> toDFU() {
        return this.map(Either::left, Either::right);
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, FastEither<L, R>> streamCodec(StreamCodec<? super B, L> leftCodec, StreamCodec<? super B, R> rightCodec) {
        return StreamCodec.of((buffer, either) -> either.consume(left -> {
            buffer.writeBoolean(true);
            leftCodec.encode(buffer, left);
        }, right -> {
            buffer.writeBoolean(false);
            rightCodec.encode(buffer, right);
        }), buffer -> buffer.readBoolean() ? FastEither.left(leftCodec.decode(buffer)) : FastEither.right(rightCodec.decode(buffer)));
    }
}

