/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.generic.owners;

import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.AssemblerLogic;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.Callback;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackEnvironment;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerCallable;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.IndexArgument;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.impl.InventoryCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.impl.MBEnergyCallbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.impl.TankCallbacks;
import net.minecraft.world.item.ItemStack;

public class AssemblerCallbacks
extends Callback<AssemblerLogic.State> {
    public AssemblerCallbacks() {
        this.addAdditional(MBEnergyCallbacks.INSTANCE, s -> s.energy);
        this.addAdditional(InventoryCallbacks.fromHandler(AssemblerLogic.State::getInventory, 0, 18, "input"));
        this.addAdditional(InventoryCallbacks.fromHandler(AssemblerLogic.State::getInventory, 18, 3, "buffer"));
        for (int i = 0; i < 3; ++i) {
            int finalI = i;
            this.addAdditional(new TankCallbacks<AssemblerLogic.State>(te -> te.tanks[finalI], "tank " + (i + 1)));
        }
    }

    @ComputerCallable
    public boolean isValidRecipe(CallbackEnvironment<AssemblerLogic.State> env, @IndexArgument int recipe) {
        this.checkRecipeIndex(recipe);
        return !((ItemStack)env.object().patterns[recipe].inv.get(9)).isEmpty();
    }

    @ComputerCallable
    public ItemStack getRecipeInputStack(CallbackEnvironment<AssemblerLogic.State> env, @IndexArgument int recipe, @IndexArgument int slot) {
        this.checkRecipeIndex(recipe);
        if (slot < 0 || slot >= 9) {
            throw new IllegalArgumentException("Recipe input stacks are 1-9");
        }
        return (ItemStack)env.object().patterns[recipe].inv.get(slot);
    }

    private void checkRecipeIndex(int javaIndex) {
        if (javaIndex >= 3 || javaIndex < 0) {
            throw new IllegalArgumentException("Only recipes 1-3 are available");
        }
    }
}

