/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.dynregistry;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.RobotWolfItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.world.FeatureMineralVein;
import blusunrize.immersiveengineering.common.world.IECountPlacement;
import blusunrize.immersiveengineering.common.world.IEHeightProvider;
import blusunrize.immersiveengineering.common.world.IEOreFeature;
import blusunrize.immersiveengineering.common.world.IEWorldGen;
import blusunrize.immersiveengineering.data.DamageTypeProvider;
import blusunrize.immersiveengineering.data.dynregistry.BannerTags;
import blusunrize.immersiveengineering.data.dynregistry.DamageTypeTagProvider;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistryPatchGenerator;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;
import org.jetbrains.annotations.NotNull;

public class WorldGenerationProvider {
    public static List<DataProvider> makeProviders(PackOutput output, CompletableFuture<HolderLookup.Provider> vanillaRegistries, ExistingFileHelper exFiles) {
        EnumMap<IEServerConfig.Ores.VeinType, FeatureRegistration> oreFeatures = new EnumMap<IEServerConfig.Ores.VeinType, FeatureRegistration>(IEServerConfig.Ores.VeinType.class);
        for (IEServerConfig.Ores.VeinType type : IEServerConfig.Ores.VeinType.VALUES) {
            FeatureRegistration typeReg = new FeatureRegistration(ImmersiveEngineering.rl((String)type.getVeinName()));
            oreFeatures.put(type, typeReg);
        }
        Registrations registrations = new Registrations(oreFeatures, new FeatureRegistration(ImmersiveEngineering.rl((String)"mineral_veins"), null));
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.CONFIGURED_FEATURE, ctx -> WorldGenerationProvider.bootstrapConfiguredFeatures(ctx, registrations));
        registryBuilder.add(Registries.PLACED_FEATURE, ctx -> WorldGenerationProvider.bootstrapPlacedFeatures((BootstrapContext<PlacedFeature>)ctx, registrations));
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, ctx -> WorldGenerationProvider.bootstrapBiomeModifiers((BootstrapContext<BiomeModifier>)ctx, registrations));
        registryBuilder.add(Registries.DAMAGE_TYPE, DamageTypeProvider::bootstrap);
        registryBuilder.add(Registries.BANNER_PATTERN, BannerTags::bootstrap);
        registryBuilder.add(Registries.WOLF_VARIANT, context -> {
            ResourceLocation base_texture = RobotWolfItem.REGISTRY_KEY.withPrefix("entity/wolf/");
            context.register(ResourceKey.create((ResourceKey)Registries.WOLF_VARIANT, (ResourceLocation)RobotWolfItem.REGISTRY_KEY), (Object)new WolfVariant(base_texture, base_texture.withSuffix("_tame"), base_texture.withSuffix("_angry"), HolderSet.empty()));
        });
        CompletableFuture<HolderLookup.Provider> combinedRegistries = WorldGenerationProvider.append(vanillaRegistries, registryBuilder);
        return List.of(new DatapackBuiltinEntriesProvider(output, vanillaRegistries, registryBuilder, Set.of("immersiveengineering")), new DamageTypeTagProvider(output, combinedRegistries, exFiles), new BannerTags(output, combinedRegistries, exFiles));
    }

    private static void bootstrapConfiguredFeatures(BootstrapContext<ConfiguredFeature<?, ?>> ctx, Registrations registrations) {
        TagMatchTest replaceDeepslate = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        TagMatchTest replaceStone = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        for (Map.Entry<IEServerConfig.Ores.VeinType, FeatureRegistration> entry : registrations.oreFeatures.entrySet()) {
            IEServerConfig.Ores.VeinType type = entry.getKey();
            EnumMetals metal = entry.getKey().metal;
            ImmutableList targetList = ImmutableList.of((Object)OreConfiguration.target((RuleTest)replaceStone, (BlockState)((IEBlocks.BlockEntry)IEBlocks.Metals.ORES.get(metal)).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)replaceDeepslate, (BlockState)((IEBlocks.BlockEntry)IEBlocks.Metals.DEEPSLATE_ORES.get(metal)).defaultBlockState()));
            entry.getValue().registerConfigured(ctx, new ConfiguredFeature((Feature)((IEOreFeature)IEWorldGen.IE_CONFIG_ORE.get()), (FeatureConfiguration)new IEOreFeature.IEOreFeatureConfig((List)targetList, type)));
        }
        registrations.mineralVeins.registerConfigured(ctx, new ConfiguredFeature((Feature)((FeatureMineralVein)IEWorldGen.MINERAL_VEIN_FEATURE.get()), (FeatureConfiguration)new NoneFeatureConfiguration()));
    }

    private static void bootstrapPlacedFeatures(BootstrapContext<PlacedFeature> ctx, Registrations registrations) {
        for (Map.Entry<IEServerConfig.Ores.VeinType, FeatureRegistration> entry : registrations.oreFeatures.entrySet()) {
            IEServerConfig.Ores.VeinType type = entry.getKey();
            List<IECountPlacement> placements = List.of(HeightRangePlacement.of((HeightProvider)new IEHeightProvider(type)), InSquarePlacement.spread(), new IECountPlacement(type));
            entry.getValue().registerPlaced(ctx, placements);
        }
        registrations.mineralVeins.registerPlaced(ctx, List.of());
    }

    private static void bootstrapBiomeModifiers(BootstrapContext<BiomeModifier> ctx, Registrations registrations) {
        HolderGetter biomeReg = ctx.lookup(Registries.BIOME);
        for (FeatureRegistration entry : registrations.allFeatures) {
            Object biomes = entry.inBiomes != null ? biomeReg.getOrThrow(entry.inBiomes) : new AnyHolderSet(new DummyRegistryLookup(biomeReg, Registries.BIOME));
            BiomeModifiers.AddFeaturesBiomeModifier modifier = new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes, (HolderSet)HolderSet.direct((Holder[])new Holder[]{entry.placed}), GenerationStep.Decoration.UNDERGROUND_ORES);
            ctx.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)entry.name), (Object)modifier);
        }
    }

    private static CompletableFuture<HolderLookup.Provider> append(CompletableFuture<HolderLookup.Provider> original, RegistrySetBuilder builder) {
        return RegistryPatchGenerator.createLookup(original, (RegistrySetBuilder)builder).thenApply(RegistrySetBuilder.PatchedRegistries::full);
    }

    private static class FeatureRegistration {
        public Holder.Reference<ConfiguredFeature<?, ?>> configured;
        public Holder.Reference<PlacedFeature> placed;
        public final ResourceLocation name;
        @Nullable
        public final TagKey<Biome> inBiomes;

        private FeatureRegistration(ResourceLocation name) {
            this(name, (TagKey<Biome>)BiomeTags.IS_OVERWORLD);
        }

        private FeatureRegistration(ResourceLocation name, @Nullable TagKey<Biome> inBiomes) {
            this.name = name;
            this.inBiomes = inBiomes;
        }

        private void registerConfigured(BootstrapContext<ConfiguredFeature<?, ?>> ctx, ConfiguredFeature<?, ?> configured) {
            this.configured = ctx.register(ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)this.name), configured);
        }

        private void registerPlaced(BootstrapContext<PlacedFeature> ctx, List<PlacementModifier> placement) {
            this.placed = ctx.register(ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)this.name), (Object)new PlacedFeature(this.configured, placement));
        }
    }

    private record Registrations(List<FeatureRegistration> allFeatures, Map<IEServerConfig.Ores.VeinType, FeatureRegistration> oreFeatures, FeatureRegistration mineralVeins) {
        public Registrations(Map<IEServerConfig.Ores.VeinType, FeatureRegistration> oreFeatures, FeatureRegistration mineralVeins) {
            this((List)Util.make(new ArrayList<FeatureRegistration>(oreFeatures.values()), l -> l.add(mineralVeins)), oreFeatures, mineralVeins);
        }
    }

    private record DummyRegistryLookup<T>(HolderGetter<T> getter, ResourceKey<? extends Registry<? extends T>> key) implements HolderLookup.RegistryLookup<T>
    {
        @NotNull
        public Lifecycle registryLifecycle() {
            return Lifecycle.stable();
        }

        @NotNull
        public Stream<Holder.Reference<T>> listElements() {
            return Stream.empty();
        }

        @NotNull
        public Stream<HolderSet.Named<T>> listTags() {
            return Stream.empty();
        }

        @NotNull
        public Optional<Holder.Reference<T>> get(@NotNull ResourceKey<T> p_255645_) {
            return Optional.empty();
        }

        @NotNull
        public Optional<HolderSet.Named<T>> get(@NotNull TagKey<T> p_256283_) {
            return Optional.empty();
        }

        public boolean canSerializeIn(@NotNull HolderOwner<T> p_255875_) {
            return true;
        }
    }
}

