/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.crafting.PotionHelper;
import blusunrize.immersiveengineering.common.fluids.IEFluid;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.data.recipes.IERecipeProvider;
import blusunrize.immersiveengineering.data.recipes.builder.AlloyRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.ArcFurnaceRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.BlastFurnaceRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.BottlingMachineRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.CokeOvenRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.CrusherRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.FermenterRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.MetalPressRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.MixerRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.RefineryRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.SawmillRecipeBuilder;
import blusunrize.immersiveengineering.data.recipes.builder.SqueezerRecipeBuilder;
import blusunrize.immersiveengineering.data.resources.RecipeWoods;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;

public class MultiblockRecipes
extends IERecipeProvider {
    private static final int half_bucket = 500;
    private static final int quarter_bucket = 250;
    private static final int eighth_bucket = 125;

    public MultiblockRecipes(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> provider) {
        super(p_248933_, provider);
    }

    protected void buildRecipes(RecipeOutput out) {
        this.alloySmelter(out);
        this.arcFurnace(out);
        this.blastfurnace(out);
        this.bottling(out);
        this.cokeoven(out);
        this.crusher(out);
        this.fermenter(out);
        this.metalPress(out);
        this.mixer(out);
        this.sawmill(out);
        this.squeezer(out);
        this.refinery(out);
    }

    private void alloySmelter(RecipeOutput out) {
        ((AlloyRecipeBuilder)((AlloyRecipeBuilder)AlloyRecipeBuilder.builder().output(new ItemStack((ItemLike)IEBlocks.StoneDecoration.INSULATING_GLASS.asItem(), 2))).input(new IngredientWithSize(Tags.Items.GLASS_BLOCKS, 2)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).dust)).build(out, this.toRL("alloysmelter/" + this.toPath((ItemLike)IEBlocks.StoneDecoration.INSULATING_GLASS)));
    }

    private void metalPress(RecipeOutput out) {
        ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder().input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).ingot)).mold((ItemLike)IEItems.Molds.MOLD_BULLET_CASING).output(new ItemStack((ItemLike)IEItems.Ingredients.EMPTY_CASING, 2))).setEnergy(2400).build(out, this.toRL("metalpress/bullet_casing"));
        ItemStack electrode = new ItemStack((ItemLike)IEItems.Misc.GRAPHITE_ELECTRODE);
        electrode.setDamageValue((Integer)IEServerConfig.MACHINES.arcfurnace_electrodeDamage.getDefault() / 2);
        ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder().input((TagKey<Item>)Tags.Items.INGOTS_NETHERITE)).mold((ItemLike)IEItems.Molds.MOLD_ROD).output((ItemLike)IEItems.Ingredients.STICK_NETHERITE, 2)).setEnergy(2400).build(out, this.toRL("metalpress/rod_netherite"));
        ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder().input((ItemLike)Items.MELON)).mold((ItemLike)IEItems.Molds.MOLD_UNPACKING).output(new ItemStack((ItemLike)Items.MELON_SLICE, 9))).setEnergy(3200).build(out, this.toRL("metalpress/melon"));
        ((MetalPressRecipeBuilder)((MetalPressRecipeBuilder)MetalPressRecipeBuilder.builder().input((ItemLike)Items.BLAZE_POWDER, 5)).mold((ItemLike)IEItems.Molds.MOLD_ROD).output((ItemLike)Items.BLAZE_ROD)).setEnergy(3200).build(out, this.toRL("metalpress/blaze_rod"));
    }

    private void arcFurnace(RecipeOutput out) {
        ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)ArcFurnaceRecipeBuilder.builder().output((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot, 1)).input((TagKey<Item>)Tags.Items.INGOTS_IRON)).additive((TagKey<Item>)IETags.coalCokeDust).slag((TagKey<Item>)IETags.slag, 1).setTime(400).setEnergy(204800).build(out, this.toRL("arcfurnace/steel"));
        ((ArcFurnaceRecipeBuilder)((ArcFurnaceRecipeBuilder)ArcFurnaceRecipeBuilder.builder().output(Items.NETHERITE_SCRAP, 2)).input((ItemLike)Items.ANCIENT_DEBRIS)).slag((TagKey<Item>)IETags.slag, 1).setTime(100).setEnergy(512000).build(out, this.toRL("arcfurnace/netherite_scrap"));
        ((ArcFurnaceRecipeBuilder)ArcFurnaceRecipeBuilder.builder().output(IEBlocks.StoneDecoration.INSULATING_GLASS.asItem(), 2)).input(new IngredientWithSize(Tags.Items.GLASS_BLOCKS, 2)).additive((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.IRON).dust).setTime(100).setEnergy(51200).build(out, this.toRL("arcfurnace/" + this.toPath((ItemLike)IEBlocks.StoneDecoration.INSULATING_GLASS)));
    }

    private void bottling(RecipeOutput out) {
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)Items.WET_SPONGE)).input((ItemLike)Items.SPONGE)).fluidInput((TagKey<Fluid>)FluidTags.WATER, 1000).build(out, this.toRL("bottling/sponge"));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)Items.MUD)).input((ItemLike)Items.DIRT)).fluidInput((TagKey<Fluid>)FluidTags.WATER, 250).build(out, this.toRL("bottling/mud"));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)Items.EXPOSED_COPPER)).input((ItemLike)Items.COPPER_BLOCK)).fluidInput((TagKey<Fluid>)IETags.fluidRedstoneAcid, 125).build(out, this.toRL("bottling/copper_aging"));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)Items.WEATHERED_COPPER)).input((ItemLike)Items.EXPOSED_COPPER)).fluidInput((TagKey<Fluid>)IETags.fluidRedstoneAcid, 125).build(out, this.toRL("bottling/copper_aging"));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)Items.OXIDIZED_COPPER)).input((ItemLike)Items.WEATHERED_COPPER)).fluidInput((TagKey<Fluid>)IETags.fluidRedstoneAcid, 125).build(out, this.toRL("bottling/copper_aging"));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)IEItems.Ingredients.ERSATZ_LEATHER.get())).output((ItemLike)IEItems.Molds.MOLD_PLATE)).input((ItemLike)IEItems.Molds.MOLD_PLATE)).input((TagKey<Item>)IETags.fabricHemp)).fluidInput((TagKey<Fluid>)IETags.fluidPlantoil, 125).build(out, this.toRL("bottling/" + this.toPath((ItemLike)IEItems.Ingredients.ERSATZ_LEATHER)));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)IEItems.Ingredients.DUROPLAST_PLATE.get())).output((ItemLike)IEItems.Molds.MOLD_PLATE)).input((ItemLike)IEItems.Molds.MOLD_PLATE)).fluidInput((TagKey<Fluid>)IETags.fluidResin, 250).build(out, this.toRL("bottling/duroplast_plate"));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)IEBlocks.StoneDecoration.DUROPLAST, 4)).output((ItemLike)IEItems.Molds.MOLD_PACKING_4)).input((ItemLike)IEItems.Molds.MOLD_PACKING_4)).fluidInput((TagKey<Fluid>)IETags.fluidResin, 4000).build(out, this.toRL("bottling/duroplast_block"));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)IEItems.Ingredients.EMPTY_SHELL, 2)).output((ItemLike)IEItems.Molds.MOLD_BULLET_CASING)).input((ItemLike)IEItems.Molds.MOLD_BULLET_CASING)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).nugget, 3)).fluidInput((TagKey<Fluid>)IETags.fluidResin, 250).build(out, this.toRL("bottling/" + this.toPath(BulletHandler.emptyShell)));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)IEItems.Tools.GRINDINGDISK.get())).output((ItemLike)IEItems.Molds.MOLD_GEAR)).input((ItemLike)IEItems.Molds.MOLD_GEAR)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).dust, 6)).input((TagKey<Item>)IETags.fiberHemp, 8)).fluidInput((TagKey<Fluid>)IETags.fluidResin, 500).build(out, this.toRL("bottling/" + this.toPath((ItemLike)IEItems.Tools.GRINDINGDISK)));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)IEItems.Ingredients.PLATE_HOP_GRAPHITE)).output((ItemLike)IEItems.Molds.MOLD_PLATE)).input((ItemLike)IEItems.Molds.MOLD_PLATE)).input((TagKey<Item>)IETags.hopGraphiteDust)).fluidInput((TagKey<Fluid>)IETags.fluidCreosote, 250).build(out, this.toRL("bottling/" + this.toPath((ItemLike)IEItems.Ingredients.PLATE_HOP_GRAPHITE)));
        ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)IEItems.Misc.GRAPHITE_ELECTRODE)).output((ItemLike)IEItems.Molds.MOLD_ROD)).input((ItemLike)IEItems.Molds.MOLD_ROD)).input((TagKey<Item>)IETags.hopGraphiteDust, 4)).fluidInput((TagKey<Fluid>)IETags.fluidCreosote, 1000).build(out, this.toRL("bottling/" + this.toPath((ItemLike)IEItems.Misc.GRAPHITE_ELECTRODE)));
        HashMap<Block, Block> vanillaConcrete = new HashMap<Block, Block>();
        vanillaConcrete.put(Blocks.WHITE_CONCRETE_POWDER, Blocks.WHITE_CONCRETE);
        vanillaConcrete.put(Blocks.ORANGE_CONCRETE_POWDER, Blocks.ORANGE_CONCRETE);
        vanillaConcrete.put(Blocks.MAGENTA_CONCRETE_POWDER, Blocks.MAGENTA_CONCRETE);
        vanillaConcrete.put(Blocks.LIGHT_BLUE_CONCRETE_POWDER, Blocks.LIGHT_BLUE_CONCRETE);
        vanillaConcrete.put(Blocks.YELLOW_CONCRETE_POWDER, Blocks.YELLOW_CONCRETE);
        vanillaConcrete.put(Blocks.LIME_CONCRETE_POWDER, Blocks.LIME_CONCRETE);
        vanillaConcrete.put(Blocks.PINK_CONCRETE_POWDER, Blocks.PINK_CONCRETE);
        vanillaConcrete.put(Blocks.GRAY_CONCRETE_POWDER, Blocks.GRAY_CONCRETE);
        vanillaConcrete.put(Blocks.LIGHT_GRAY_CONCRETE_POWDER, Blocks.LIGHT_GRAY_CONCRETE);
        vanillaConcrete.put(Blocks.CYAN_CONCRETE_POWDER, Blocks.CYAN_CONCRETE);
        vanillaConcrete.put(Blocks.PURPLE_CONCRETE_POWDER, Blocks.PURPLE_CONCRETE);
        vanillaConcrete.put(Blocks.BLUE_CONCRETE_POWDER, Blocks.BLUE_CONCRETE);
        vanillaConcrete.put(Blocks.BROWN_CONCRETE_POWDER, Blocks.BROWN_CONCRETE);
        vanillaConcrete.put(Blocks.GREEN_CONCRETE_POWDER, Blocks.GREEN_CONCRETE);
        vanillaConcrete.put(Blocks.RED_CONCRETE_POWDER, Blocks.RED_CONCRETE);
        vanillaConcrete.put(Blocks.BLACK_CONCRETE_POWDER, Blocks.BLACK_CONCRETE);
        vanillaConcrete.forEach((powder, concrete) -> ((BottlingMachineRecipeBuilder)((BottlingMachineRecipeBuilder)BottlingMachineRecipeBuilder.builder().output((ItemLike)concrete)).input((ItemLike)powder)).fluidInput((TagKey<Fluid>)FluidTags.WATER, 125).build(out, this.toRL("bottling/" + this.toPath((ItemLike)powder))));
    }

    private void crusher(RecipeOutput out) {
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((ItemLike)Items.COBBLED_DEEPSLATE)).input((ItemLike)Items.DEEPSLATE)).setEnergy(2000).build(out, this.toRL("crusher/deepslate"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((ItemLike)Items.COBBLESTONE)).input((ItemLike)Items.STONE)).setEnergy(1600).build(out, this.toRL("crusher/stone"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((ItemLike)Items.GRAVEL)).input((TagKey<Item>)Tags.Items.COBBLESTONES)).setEnergy(1600).build(out, this.toRL("crusher/cobblestone"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((ItemLike)Items.SAND)).addSecondary(Items.FLINT, 0.1f, new ICondition[0]).input((TagKey<Item>)Tags.Items.GRAVELS)).setEnergy(1600).build(out, this.toRL("crusher/gravel"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((ItemLike)IEBlocks.StoneDecoration.SLAG_GRAVEL.asItem())).input((TagKey<Item>)IETags.slag)).setEnergy(1600).build(out, this.toRL("crusher/slag"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((ItemLike)IEBlocks.StoneDecoration.SLAG_GRAVEL.asItem())).input((ItemLike)IEBlocks.StoneDecoration.SLAG_BRICK)).setEnergy(1600).build(out, this.toRL("crusher/slag_brick"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((ItemLike)Items.SAND)).input((TagKey<Item>)Tags.Items.GLASS_BLOCKS)).setEnergy(3200).build(out, this.toRL("crusher/glass"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.SAND, 2)).addSecondary((TagKey<Item>)IETags.saltpeterDust, 0.5f, new ICondition[0]).input((TagKey<Item>)Tags.Items.SANDSTONE_UNCOLORED_BLOCKS)).setEnergy(3200).build(out, this.toRL("crusher/sandstone"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.RED_SAND, 2)).addSecondary((TagKey<Item>)IETags.saltpeterDust, 0.5f, new ICondition[0]).input((TagKey<Item>)Tags.Items.SANDSTONE_RED_BLOCKS)).setEnergy(3200).build(out, this.toRL("crusher/red_sandstone"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.CLAY_BALL, 4)).input((TagKey<Item>)IETags.getItemTag((TagKey)IETags.clayBlock))).setEnergy(1600).build(out, this.toRL("crusher/clay"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((ItemLike)Items.DIRT)).input((ItemLike)Items.COARSE_DIRT)).setEnergy(1600).build(out, this.toRL("crusher/coarse_dirt"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.AMETHYST_SHARD, 4)).input((ItemLike)Items.AMETHYST_BLOCK)).setEnergy(3200).build(out, this.toRL("crusher/amethyst"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.QUARTZ, 4)).input((ItemLike)Items.QUARTZ_BLOCK)).setEnergy(3200).build(out, this.toRL("crusher/quartz"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.GLOWSTONE_DUST, 4)).input((ItemLike)Blocks.GLOWSTONE)).setEnergy(3200).build(out, this.toRL("crusher/glowstone"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.PRISMARINE_SHARD, 4)).input((ItemLike)Blocks.PRISMARINE)).setEnergy(3200).build(out, this.toRL("crusher/prismarine"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.PRISMARINE_SHARD, 8)).input((ItemLike)Blocks.DARK_PRISMARINE)).setEnergy(3200).build(out, this.toRL("crusher/dark_prismarine"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.PRISMARINE_SHARD, 9)).input((ItemLike)Blocks.PRISMARINE_BRICKS)).setEnergy(3200).build(out, this.toRL("crusher/prismarine_brick"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.BLAZE_POWDER, 4)).addSecondary((TagKey<Item>)IETags.sulfurDust, 0.5f, new ICondition[0]).input((TagKey<Item>)Tags.Items.RODS_BLAZE)).setEnergy(1600).build(out, this.toRL("crusher/blaze_powder"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.BONE_MEAL, 6)).input((ItemLike)Items.BONE)).setEnergy(1600).build(out, this.toRL("crusher/bone_meal"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((TagKey<Item>)IETags.coalCokeDust, 1)).input((TagKey<Item>)IETags.coalCoke)).setEnergy(2400).build(out, this.toRL("crusher/coke"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((TagKey<Item>)IETags.coalCokeDust, 9)).input((TagKey<Item>)IETags.getItemTag((TagKey)IETags.coalCokeBlock))).setEnergy(4800).build(out, this.toRL("crusher/coke_block"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((TagKey<Item>)IETags.hopGraphiteDust, 1)).input((TagKey<Item>)IETags.hopGraphiteIngot)).setEnergy(2400).build(out, this.toRL("crusher/graphite_ingot"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((TagKey<Item>)IETags.hopGraphiteDust, 1)).input((TagKey<Item>)IETags.hopGraphitePlate)).setEnergy(2400).build(out, this.toRL("crusher/graphite_plate"));
        TagKey coal_dust = TagUtils.createItemWrapper((ResourceLocation)IETags.getDust((String)"coal"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((TagKey<Item>)coal_dust, 1)).addCondition(MultiblockRecipes.getTagCondition(coal_dust))).input((ItemLike)Items.COAL)).setEnergy(2400).build(out, this.toRL("crusher/coal"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((TagKey<Item>)coal_dust, 9)).addCondition(MultiblockRecipes.getTagCondition(coal_dust))).input((ItemLike)Items.COAL_BLOCK)).setEnergy(4800).build(out, this.toRL("crusher/coal_block"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.STRING, 4)).input((TagKey<Item>)ItemTags.WOOL)).setEnergy(3200).build(out, this.toRL("crusher/wool"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.GOLD).dust, 2)).input((ItemLike)Items.NETHER_GOLD_ORE)).setEnergy(4200).build(out, this.toRL("crusher/nether_gold"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(Items.NETHER_WART, 9)).input((ItemLike)Items.NETHER_WART_BLOCK)).setEnergy(1600).build(out, this.toRL("crusher/nether_wart"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(new ItemStack((ItemLike)Items.BLACK_DYE, 1))).addSecondary(Items.GRAY_DYE, 0.2f, new ICondition[0]).input((ItemLike)Items.CHARCOAL)).setEnergy(1600).build(out, this.toRL("crusher/black_dye"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(new ItemStack((ItemLike)Items.BLUE_DYE, 2))).addSecondary(Items.LIGHT_GRAY_DYE, 0.1f, new ICondition[0]).input((TagKey<Item>)Tags.Items.GEMS_LAPIS)).setEnergy(1600).build(out, this.toRL("crusher/blue_dye"));
        ((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder().output(new ItemStack((ItemLike)Items.WHITE_DYE, 2))).addSecondary(Items.LIGHT_GRAY_DYE, 0.1f, new ICondition[0]).input((ItemLike)Items.BONE_MEAL)).setEnergy(1600).build(out, this.toRL("crusher/white_dye"));
    }

    private void sawmill(RecipeOutput out) {
        for (RecipeWoods recipeWoods : RecipeWoods.values()) {
            SawmillRecipeBuilder sawmillBuilder;
            if (recipeWoods.getLog() != null) {
                sawmillBuilder = ((SawmillRecipeBuilder)((SawmillRecipeBuilder)SawmillRecipeBuilder.builder().output(recipeWoods.getPlank(), recipeWoods.plankCount())).input(recipeWoods.getLog())).setEnergy(1600);
                if (recipeWoods.getStripped() != null) {
                    sawmillBuilder.addStripped(recipeWoods.getStripped());
                    if (recipeWoods.produceSawdust()) {
                        sawmillBuilder.addStripSecondary((TagKey<Item>)IETags.sawdust);
                    }
                }
                if (recipeWoods.produceSawdust()) {
                    sawmillBuilder.addSawSecondary((TagKey<Item>)IETags.sawdust);
                }
                sawmillBuilder.build(out, this.toRL("sawmill/" + recipeWoods.getName() + "_log"));
            }
            if (recipeWoods.getWood() != null) {
                sawmillBuilder = ((SawmillRecipeBuilder)((SawmillRecipeBuilder)SawmillRecipeBuilder.builder().output(recipeWoods.getPlank(), recipeWoods.plankCount())).input(recipeWoods.getWood())).setEnergy(1600);
                if (recipeWoods.getStrippedWood() != null) {
                    sawmillBuilder.addStripped(recipeWoods.getStrippedWood());
                    if (recipeWoods.produceSawdust()) {
                        sawmillBuilder.addStripSecondary((TagKey<Item>)IETags.sawdust);
                    }
                }
                if (recipeWoods.produceSawdust()) {
                    sawmillBuilder.addSawSecondary((TagKey<Item>)IETags.sawdust);
                }
                sawmillBuilder.build(out, this.toRL("sawmill/" + recipeWoods.getName() + "_wood"));
            }
            if (recipeWoods.getStripped() != null) {
                sawmillBuilder = ((SawmillRecipeBuilder)SawmillRecipeBuilder.builder().output(recipeWoods.getPlank(), recipeWoods.plankCount())).setEnergy(800);
                if (recipeWoods.getWood() != null) {
                    sawmillBuilder.input(Ingredient.of((ItemLike[])new ItemLike[]{recipeWoods.getStripped(), recipeWoods.getStrippedWood()}));
                } else {
                    sawmillBuilder.input(recipeWoods.getStripped());
                }
                if (recipeWoods.produceSawdust()) {
                    sawmillBuilder.addSawSecondary((TagKey<Item>)IETags.sawdust);
                }
                sawmillBuilder.build(out, this.toRL("sawmill/stripped_" + recipeWoods.getName() + "_log"));
            }
            if (recipeWoods.getDoor() != null) {
                sawmillBuilder = ((SawmillRecipeBuilder)((SawmillRecipeBuilder)SawmillRecipeBuilder.builder().output(recipeWoods.getPlank(), 1)).input(recipeWoods.getDoor())).setEnergy(800);
                if (recipeWoods.produceSawdust()) {
                    sawmillBuilder.addSawSecondary((TagKey<Item>)IETags.sawdust);
                }
                sawmillBuilder.build(out, this.toRL("sawmill/" + recipeWoods.getName() + "_door"));
            }
            if (recipeWoods.getStairs() != null) {
                sawmillBuilder = ((SawmillRecipeBuilder)((SawmillRecipeBuilder)SawmillRecipeBuilder.builder().output(recipeWoods.getPlank(), 1)).input(recipeWoods.getStairs())).setEnergy(1600);
                if (recipeWoods.produceSawdust()) {
                    sawmillBuilder.addStripSecondary((TagKey<Item>)IETags.sawdust);
                }
                sawmillBuilder.build(out, this.toRL("sawmill/" + recipeWoods.getName() + "_stairs"));
            }
            if (recipeWoods.getSlab() == null) continue;
            sawmillBuilder = ((SawmillRecipeBuilder)((SawmillRecipeBuilder)SawmillRecipeBuilder.builder().output(recipeWoods.getSlab(), 2)).input(recipeWoods.getPlank())).setEnergy(800);
            if (recipeWoods.produceSawdust()) {
                sawmillBuilder.addStripSecondary((TagKey<Item>)IETags.sawdust);
            }
            sawmillBuilder.build(out, this.toRL("sawmill/" + recipeWoods.getName() + "_slab"));
        }
        for (RecipeWoods recipeWoods : TreatedWoodStyles.values()) {
            IEBlocks.BlockEntry plank = (IEBlocks.BlockEntry)IEBlocks.WoodenDecoration.TREATED_WOOD.get((Object)recipeWoods);
            ((SawmillRecipeBuilder)((SawmillRecipeBuilder)SawmillRecipeBuilder.builder().output((ItemLike)IEBlocks.TO_SLAB.get(plank.getId()), 2)).input((ItemLike)plank.get())).setEnergy(800).addStripSecondary((TagKey<Item>)IETags.sawdust).build(out, this.toRL("sawmill/treated_wood_" + recipeWoods.name().toLowerCase(Locale.ROOT) + "_slab"));
            ((SawmillRecipeBuilder)((SawmillRecipeBuilder)SawmillRecipeBuilder.builder().output((ItemLike)plank.get(), 1)).input((ItemLike)IEBlocks.TO_STAIRS.get(plank.getId()))).setEnergy(1600).addStripSecondary((TagKey<Item>)IETags.sawdust).build(out, this.toRL("sawmill/treated_wood_" + recipeWoods.name().toLowerCase(Locale.ROOT) + "_stairs"));
        }
        ((SawmillRecipeBuilder)((SawmillRecipeBuilder)SawmillRecipeBuilder.builder().output(Items.OAK_PLANKS, 4)).input((ItemLike)Items.BOOKSHELF)).addStripSecondary((TagKey<Item>)IETags.sawdust).addStripSecondary((ItemLike)Items.BOOK, 3).setEnergy(1600).build(out, this.toRL("sawmill/bookshelf"));
    }

    private void squeezer(RecipeOutput out) {
        IEFluid plantOil = IEFluids.PLANTOIL.getStill();
        ((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder().output((Fluid)plantOil, 80).input((ItemLike)Items.WHEAT_SEEDS)).setEnergy(6400).build(out, this.toRL("squeezer/wheat_seeds"));
        ((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder().output((Fluid)plantOil, 60).input((ItemLike)Items.BEETROOT_SEEDS)).setEnergy(6400).build(out, this.toRL("squeezer/beetroot_seeds"));
        ((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder().output((Fluid)plantOil, 40).input((ItemLike)Items.PUMPKIN_SEEDS)).setEnergy(6400).build(out, this.toRL("squeezer/pumpkin_seeds"));
        ((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder().output((Fluid)plantOil, 20).input((ItemLike)Items.MELON_SEEDS)).setEnergy(6400).build(out, this.toRL("squeezer/melon_seeds"));
        ((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder().output((Fluid)plantOil, 120).input((ItemLike)IEItems.Misc.HEMP_SEEDS)).setEnergy(6400).build(out, this.toRL("squeezer/hemp_seeds"));
        ((SqueezerRecipeBuilder)SqueezerRecipeBuilder.builder().output(new IngredientWithSize(IETags.hopGraphiteDust))).input(new IngredientWithSize(IETags.coalCokeDust, 8)).setEnergy(19200).build(out, this.toRL("squeezer/graphite_dust"));
    }

    private void fermenter(RecipeOutput out) {
        IEFluid ethanol = IEFluids.ETHANOL.getStill();
        ((FermenterRecipeBuilder)FermenterRecipeBuilder.builder().output((Fluid)ethanol, 80).input((ItemLike)Items.SUGAR_CANE)).setEnergy(6400).build(out, this.toRL("fermenter/sugar_cane"));
        ((FermenterRecipeBuilder)FermenterRecipeBuilder.builder().output((Fluid)ethanol, 20).input((ItemLike)Items.MELON_SLICE)).setEnergy(6400).build(out, this.toRL("fermenter/melon_slice"));
        ((FermenterRecipeBuilder)FermenterRecipeBuilder.builder().output((Fluid)ethanol, 80).input((ItemLike)Items.APPLE)).setEnergy(6400).build(out, this.toRL("fermenter/apple"));
        ((FermenterRecipeBuilder)FermenterRecipeBuilder.builder().output((Fluid)ethanol, 80).input((TagKey<Item>)Tags.Items.CROPS_POTATO)).setEnergy(6400).build(out, this.toRL("fermenter/potato"));
        ((FermenterRecipeBuilder)FermenterRecipeBuilder.builder().output((Fluid)ethanol, 40).input((TagKey<Item>)Tags.Items.CROPS_BEETROOT)).setEnergy(6400).build(out, this.toRL("fermenter/beetroot"));
        ((FermenterRecipeBuilder)FermenterRecipeBuilder.builder().output((Fluid)ethanol, 50).input((ItemLike)Items.SWEET_BERRIES)).setEnergy(6400).build(out, this.toRL("fermenter/sweet_berries"));
        ((FermenterRecipeBuilder)FermenterRecipeBuilder.builder().output((Fluid)ethanol, 100).input((ItemLike)Items.GLOW_BERRIES)).setEnergy(6400).build(out, this.toRL("fermenter/glow_berries"));
        ((FermenterRecipeBuilder)((FermenterRecipeBuilder)FermenterRecipeBuilder.builder().output((Fluid)ethanol, 250).output((ItemLike)Items.GLASS_BOTTLE)).input((ItemLike)Items.HONEY_BOTTLE)).setEnergy(6400).build(out, this.toRL("fermenter/honey"));
    }

    private void refinery(RecipeOutput out) {
        RefineryRecipeBuilder.builder().output((Fluid)IEFluids.BIODIESEL.getStill(), 16).catalyst((TagKey<Item>)IETags.saltpeterDust).input((TagKey<Fluid>)IETags.fluidPlantoil, 8).input((TagKey<Fluid>)IETags.fluidEthanol, 8).setEnergy(80).build(out, this.toRL("refinery/biodiesel"));
        RefineryRecipeBuilder.builder().output((Fluid)IEFluids.HIGH_POWER_BIODIESEL.getStill(), 100).input((TagKey<Fluid>)IETags.fluidBiodiesel, 95).input(PotionHelper.getFluidIngredientForType((Holder)Potions.STRENGTH, (int)5, null)).setEnergy(80).build(out, this.toRL("refinery/high_power_biodiesel"));
        RefineryRecipeBuilder.builder().output((Fluid)IEFluids.ACETALDEHYDE.getStill(), 8).catalyst((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).plate).input((TagKey<Fluid>)IETags.fluidEthanol, 8).setEnergy(120).build(out, this.toRL("refinery/acetaldehyde"));
        RefineryRecipeBuilder.builder().output((Fluid)IEFluids.PHENOLIC_RESIN.getStill(), 8).input((TagKey<Fluid>)IETags.fluidAcetaldehyde, 12).input((TagKey<Fluid>)IETags.fluidCreosote, 8).setEnergy(240).build(out, this.toRL("refinery/resin"));
    }

    private void mixer(RecipeOutput out) {
        IEFluid concrete = IEFluids.CONCRETE.getStill();
        ((MixerRecipeBuilder)((MixerRecipeBuilder)MixerRecipeBuilder.builder().output((Fluid)concrete, 500).fluidInput((TagKey<Fluid>)FluidTags.WATER, 500).input(new IngredientWithSize(Tags.Items.SANDS, 2)).input((TagKey<Item>)Tags.Items.GRAVELS)).input((TagKey<Item>)IETags.clay)).setEnergy(3200).build(out, this.toRL("mixer/concrete"));
        ((MixerRecipeBuilder)((MixerRecipeBuilder)MixerRecipeBuilder.builder().output((Fluid)IEFluids.HERBICIDE.getStill(), 500).fluidInput((TagKey<Fluid>)IETags.fluidEthanol, 500).input((TagKey<Item>)IETags.sulfurDust)).input((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.COPPER).dust)).setEnergy(3200).build(out, this.toRL("mixer/herbicide"));
        ((MixerRecipeBuilder)MixerRecipeBuilder.builder().output((Fluid)IEFluids.REDSTONE_ACID.getStill(), 250).fluidInput((TagKey<Fluid>)FluidTags.WATER, 250).input((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).setEnergy(1600).build(out, this.toRL("mixer/redstone_acid"));
    }

    private void blastfurnace(RecipeOutput out) {
        out.accept(this.toRL("blastfurnace/fuel_coke"), (Recipe)new BlastFurnaceFuel(Ingredient.of((TagKey)IETags.coalCoke), 1200), null);
        out.accept(this.toRL("blastfurnace/fuel_coke_block"), (Recipe)new BlastFurnaceFuel(Ingredient.of((TagKey)IETags.getItemTag((TagKey)IETags.coalCokeBlock)), 12000), null);
        out.accept(this.toRL("blastfurnace/fuel_charcoal"), (Recipe)new BlastFurnaceFuel(Ingredient.of((TagKey)IETags.charCoal), 300), null);
        TagKey charCoalBlocks = TagUtils.createItemWrapper((ResourceLocation)IETags.getStorageBlock((String)"charcoal"));
        out.accept(this.toRL("blastfurnace/fuel_charcoal_block"), (Recipe)new BlastFurnaceFuel(Ingredient.of((TagKey)charCoalBlocks), 3000), null, new ICondition[]{MultiblockRecipes.getTagCondition(charCoalBlocks.location())});
        ((BlastFurnaceRecipeBuilder)((BlastFurnaceRecipeBuilder)BlastFurnaceRecipeBuilder.builder().output((TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot, 1)).input((TagKey<Item>)Tags.Items.INGOTS_IRON)).slag((TagKey<Item>)IETags.slag, 1).setTime(1200).build(out, this.toRL("blastfurnace/steel"));
        ((BlastFurnaceRecipeBuilder)((BlastFurnaceRecipeBuilder)BlastFurnaceRecipeBuilder.builder().output((TagKey<Item>)IETags.getItemTag((TagKey)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).storage), 1)).input((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON)).slag((TagKey<Item>)IETags.slag, 9).setTime(10800).build(out, this.toRL("blastfurnace/steel_block"));
    }

    private void cokeoven(RecipeOutput out) {
        ((CokeOvenRecipeBuilder)((CokeOvenRecipeBuilder)CokeOvenRecipeBuilder.builder().output((TagKey<Item>)IETags.coalCoke, 1)).input((ItemLike)Items.COAL, 16)).creosoteAmount(500).setTime(6000).build(out, this.toRL("cokeoven/coke"));
        ((CokeOvenRecipeBuilder)((CokeOvenRecipeBuilder)CokeOvenRecipeBuilder.builder().output((TagKey<Item>)IETags.getItemTag((TagKey)IETags.coalCokeBlock), 1)).input((ItemLike)Blocks.COAL_BLOCK, 2)).creosoteAmount(5000).setTime(6000).build(out, this.toRL("cokeoven/coke_block"));
        ((CokeOvenRecipeBuilder)((CokeOvenRecipeBuilder)CokeOvenRecipeBuilder.builder().output((ItemLike)Items.CHARCOAL)).input((TagKey<Item>)ItemTags.LOGS_THAT_BURN, 8)).creosoteAmount(250).setTime(3000).build(out, this.toRL("cokeoven/charcoal"));
    }
}

