/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.blockstates;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallback;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.models.ModelConfigurableSides;
import blusunrize.immersiveengineering.client.models.obj.callback.block.CagelampCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.ChuteCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.LanternCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.LogicUnitCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.PipeCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.PostCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.StructuralArmCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.TurretCallbacks;
import blusunrize.immersiveengineering.client.render.tile.TurretRenderer;
import blusunrize.immersiveengineering.common.blocks.cloth.StripCurtainBlock;
import blusunrize.immersiveengineering.common.blocks.generic.CatwalkBlock;
import blusunrize.immersiveengineering.common.blocks.generic.CatwalkStairsBlock;
import blusunrize.immersiveengineering.common.blocks.generic.WallmountBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalLadderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.metal.WarningSignBlock;
import blusunrize.immersiveengineering.common.blocks.plant.HempBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.BlueprintShelfBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.SawdustBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.fluids.IEFluid;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.data.DataGenUtils;
import blusunrize.immersiveengineering.data.blockstates.ExtendedBlockstateProvider;
import blusunrize.immersiveengineering.data.models.ConveyorModelBuilder;
import blusunrize.immersiveengineering.data.models.ModelProviderUtils;
import blusunrize.immersiveengineering.data.models.NongeneratedModels;
import blusunrize.immersiveengineering.data.models.SideConfigBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.loaders.CompositeModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStates
extends ExtendedBlockstateProvider {
    private static final ResourceLocation ALU_FENCE_TEXTURE = ImmersiveEngineering.rl((String)"block/metal/storage_aluminum");
    private static final ResourceLocation STEEL_FENCE_TEXTURE = ImmersiveEngineering.rl((String)"block/metal/storage_steel");
    private static final ResourceLocation TREATED_FENCE_TEXTURE = ImmersiveEngineering.rl((String)"block/wooden_decoration/treated_wood_horizontal");
    private final ConfiguredModel EMPTY_MODEL;

    public BlockStates(PackOutput output, ExistingFileHelper exHelper) {
        super(output, exHelper);
        this.EMPTY_MODEL = new ConfiguredModel((ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/ie_empty"), this.existingFileHelper));
    }

    private void postBlock(Supplier<? extends Block> b, ResourceLocation texture) {
        ResourceLocation model = ImmersiveEngineering.rl((String)"block/wooden_device/wooden_post.obj.ie");
        ImmutableList.Builder parts = ImmutableList.builder();
        parts.add((Object)new Vec3i(0, 0, 0)).add((Object)new Vec3i(0, 1, 0)).add((Object)new Vec3i(0, 2, 0)).add((Object)new Vec3i(0, 3, 0));
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            parts.add((Object)new BlockPos(0, 3, 0).relative(d));
        }
        NongeneratedModels.NongeneratedModel baseModel = (NongeneratedModels.NongeneratedModel)((NongeneratedModels.NongeneratedModel)this.ieObjBuilder(this.name(b), model, this.innerModels).callback((IEOBJCallback<?>)PostCallbacks.INSTANCE).end()).texture("texture", texture);
        BlockModelBuilder builder = this.splitModel(this.name(b) + "_split", baseModel, (List<Vec3i>)parts.build(), true);
        this.getVariantBuilder(b.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builder)});
    }

    protected void registerStatesAndModels() {
        for (EnumMetals enumMetals : EnumMetals.values()) {
            String name = enumMetals.tagName();
            if (!enumMetals.isVanillaMetal()) {
                BlockModelBuilder storageModel;
                if (enumMetals.shouldAddOre()) {
                    this.cubeAll((Supplier)IEBlocks.Metals.ORES.get(enumMetals), this.modLoc("block/metal/ore_" + name));
                    this.cubeAll((Supplier)IEBlocks.Metals.DEEPSLATE_ORES.get(enumMetals), this.modLoc("block/metal/deepslate_ore_" + name));
                    this.cubeAll((Supplier)IEBlocks.Metals.RAW_ORES.get(enumMetals), this.modLoc("block/metal/raw_" + name));
                }
                ResourceLocation resourceLocation = this.modLoc("block/metal/storage_" + name);
                IEBlocks.BlockEntry storage = (IEBlocks.BlockEntry)IEBlocks.Metals.STORAGE.get(enumMetals);
                String storageName = this.name((Supplier<? extends Block>)storage);
                if (enumMetals == EnumMetals.URANIUM) {
                    ResourceLocation side = this.modLoc("block/metal/storage_" + name + "_side");
                    ResourceLocation top = this.modLoc("block/metal/storage_" + name + "_top");
                    storageModel = (BlockModelBuilder)this.models().cubeBottomTop(storageName, side, top, top);
                    this.slabFor((Supplier<? extends Block>)storage, side, top, top);
                } else {
                    storageModel = (BlockModelBuilder)this.models().cubeAll(storageName, resourceLocation);
                    this.slabFor((Supplier<? extends Block>)storage, resourceLocation);
                }
                this.simpleBlockAndItem((Supplier<? extends Block>)storage, (ModelFile)storageModel);
            }
            ResourceLocation resourceLocation = this.modLoc("block/metal/sheetmetal_" + name);
            this.cubeAll((Supplier)IEBlocks.Metals.SHEETMETAL.get(enumMetals), resourceLocation);
            this.slabFor((Supplier)IEBlocks.Metals.SHEETMETAL.get(enumMetals), resourceLocation);
        }
        for (EnumMetals enumMetals : DyeColor.values()) {
            ResourceLocation sheetmetalName = this.modLoc("block/metal/sheetmetal_" + enumMetals.getName());
            this.cubeAll((Supplier)IEBlocks.MetalDecoration.COLORED_SHEETMETAL.get(enumMetals), sheetmetalName);
            this.slabFor((Supplier)IEBlocks.MetalDecoration.COLORED_SHEETMETAL.get(enumMetals), sheetmetalName);
        }
        this.fenceBlock((Supplier<? extends FenceBlock>)IEBlocks.WoodenDecoration.TREATED_FENCE, TREATED_FENCE_TEXTURE);
        this.fenceBlock((Supplier<? extends FenceBlock>)IEBlocks.MetalDecoration.STEEL_FENCE, STEEL_FENCE_TEXTURE);
        this.fenceBlock((Supplier<? extends FenceBlock>)IEBlocks.MetalDecoration.ALU_FENCE, ALU_FENCE_TEXTURE);
        this.fenceGateBlock((Supplier<? extends FenceGateBlock>)IEBlocks.WoodenDecoration.TREATED_FENCE_GATE, TREATED_FENCE_TEXTURE);
        this.fenceGateBlock((Supplier<? extends FenceGateBlock>)IEBlocks.MetalDecoration.STEEL_FENCE_GATE, STEEL_FENCE_TEXTURE);
        this.fenceGateBlock((Supplier<? extends FenceGateBlock>)IEBlocks.MetalDecoration.ALU_FENCE_GATE, ALU_FENCE_TEXTURE);
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.COKEBRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/cokebrick"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.BLASTBRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/blastbrick"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.BLASTBRICK_REINFORCED, ImmersiveEngineering.rl((String)"block/stone_decoration/blastbrick_reinforced"));
        this.multiEightCubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.SLAG_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/slag_brick/slag_brick"));
        this.multiEightCubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CLINKER_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/clinker_brick/clinker_brick"));
        this.simpleBlockAndItem((Supplier<? extends Block>)IEBlocks.StoneDecoration.CLINKER_BRICK_SILL, new ConfiguredModel((ModelFile)this.models().cubeBottomTop("clinker_brick_sill", this.modLoc("block/stone_decoration/clinker_brick/clinker_brick_sill_side"), this.modLoc("block/stone_decoration/clinker_brick/clinker_brick0"), this.modLoc("block/stone_decoration/clinker_brick/clinker_brick_sill_top"))));
        this.multiEightCubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.SLAG_GRAVEL, ImmersiveEngineering.rl((String)"block/stone_decoration/slag_gravel/slag_gravel"));
        this.multiEightCubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.GRIT_SAND, ImmersiveEngineering.rl((String)"block/stone_decoration/grit_sand/grit_sand"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.COKE, ImmersiveEngineering.rl((String)"block/stone_decoration/coke"));
        this.multiEightCubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete/concrete"));
        this.multiEightCubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_brick/concrete_brick"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_BRICK_CRACKED, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_brick_cracked"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_CHISELED, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_chiseled"));
        this.cubeSideVertical((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_PILLAR, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_pillar"), ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_tile/concrete_tile0"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_LEADED, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_leaded"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_REINFORCED, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_reinforced"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_REINFORCED_TILE, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_reinforced_tile"));
        this.multiEightCubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_TILE, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_tile/concrete_tile"));
        this.multiEightCubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete/hempcrete"));
        this.multiEightCubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete_brick/hempcrete_brick"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE_BRICK_CRACKED, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete_brick_cracked"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE_CHISELED, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete_chiseled"));
        this.cubeSideVertical((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE_PILLAR, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete_pillar"), ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete/hempcrete0"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.INSULATING_GLASS, ImmersiveEngineering.rl((String)"block/stone_decoration/insulating_glass"), RenderType.translucent());
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.SLAG_GLASS, ImmersiveEngineering.rl((String)"block/stone_decoration/slag_glass"), RenderType.translucent());
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.ALLOYBRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/alloybrick"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.DUROPLAST, ImmersiveEngineering.rl((String)"block/stone_decoration/duroplast"), RenderType.translucent());
        for (EnumMetals enumMetals : TreatedWoodStyles.values()) {
            this.cubeAll((Supplier)IEBlocks.WoodenDecoration.TREATED_WOOD.get(enumMetals), ImmersiveEngineering.rl((String)("block/wooden_decoration/treated_wood_" + enumMetals.name().toLowerCase(Locale.ENGLISH))));
        }
        this.cubeAll((Supplier<? extends Block>)IEBlocks.WoodenDecoration.FIBERBOARD, ImmersiveEngineering.rl((String)"block/wooden_decoration/fiberboard"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.WoodenDecoration.BASIC_ENGINEERING, ImmersiveEngineering.rl((String)"block/wooden_decoration/basic_engineering"));
        this.cubeSideVertical((Supplier<? extends Block>)IEBlocks.MetalDecoration.LV_COIL, ImmersiveEngineering.rl((String)"block/metal_decoration/coil_lv_side"), ImmersiveEngineering.rl((String)"block/metal_decoration/coil_lv_top"));
        this.cubeSideVertical((Supplier<? extends Block>)IEBlocks.MetalDecoration.MV_COIL, ImmersiveEngineering.rl((String)"block/metal_decoration/coil_mv_side"), ImmersiveEngineering.rl((String)"block/metal_decoration/coil_mv_top"));
        this.cubeSideVertical((Supplier<? extends Block>)IEBlocks.MetalDecoration.HV_COIL, ImmersiveEngineering.rl((String)"block/metal_decoration/coil_hv_side"), ImmersiveEngineering.rl((String)"block/metal_decoration/coil_hv_top"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.MetalDecoration.ENGINEERING_RS, ImmersiveEngineering.rl((String)"block/metal_decoration/redstone_engineering"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.MetalDecoration.ENGINEERING_HEAVY, ImmersiveEngineering.rl((String)"block/metal_decoration/heavy_engineering"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.MetalDecoration.ENGINEERING_LIGHT, ImmersiveEngineering.rl((String)"block/metal_decoration/light_engineering"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.MetalDecoration.ENGINEERING_RESONANZ, ImmersiveEngineering.rl((String)"block/metal_decoration/resonanz_engineering"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.MetalDecoration.GENERATOR, ImmersiveEngineering.rl((String)"block/metal_decoration/generator"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.MetalDecoration.RADIATOR, ImmersiveEngineering.rl((String)"block/metal_decoration/radiator"));
        this.scaffold((Supplier<? extends Block>)IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING, ImmersiveEngineering.rl((String)"block/wooden_decoration/scaffolding"), ImmersiveEngineering.rl((String)"block/wooden_decoration/scaffolding_top"));
        ResourceLocation aluSide = ImmersiveEngineering.rl((String)"block/metal_decoration/aluminum_scaffolding");
        ResourceLocation steelSide = ImmersiveEngineering.rl((String)"block/metal_decoration/steel_scaffolding");
        for (MetalScaffoldingType metalScaffoldingType : MetalScaffoldingType.values()) {
            String suffix = "_" + metalScaffoldingType.name().toLowerCase(Locale.ENGLISH);
            ResourceLocation aluTop = ImmersiveEngineering.rl((String)("block/metal_decoration/aluminum_scaffolding_top" + suffix));
            ResourceLocation steelTop = ImmersiveEngineering.rl((String)("block/metal_decoration/steel_scaffolding_top" + suffix));
            this.scaffold((Supplier)IEBlocks.MetalDecoration.ALU_SCAFFOLDING.get(metalScaffoldingType), aluSide, aluTop);
            this.scaffold((Supplier)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(metalScaffoldingType), steelSide, steelTop);
            this.slabFor((Supplier)IEBlocks.MetalDecoration.ALU_SCAFFOLDING.get(metalScaffoldingType), aluSide, aluTop, aluSide, RenderType.cutout());
            this.slabFor((Supplier)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(metalScaffoldingType), steelSide, steelTop, steelSide, RenderType.cutout());
            this.stairsFor((Supplier)IEBlocks.MetalDecoration.ALU_SCAFFOLDING.get(metalScaffoldingType), aluSide, aluTop, aluSide, RenderType.cutout());
            this.stairsFor((Supplier)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(metalScaffoldingType), steelSide, steelTop, steelSide, RenderType.cutout());
        }
        this.slabFor((Supplier<? extends Block>)IEBlocks.StoneDecoration.COKEBRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/cokebrick"));
        this.slabFor((Supplier<? extends Block>)IEBlocks.StoneDecoration.BLASTBRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/blastbrick"));
        this.slabFor((Supplier<? extends Block>)IEBlocks.StoneDecoration.BLASTBRICK_REINFORCED, ImmersiveEngineering.rl((String)"block/stone_decoration/blastbrick_reinforced"));
        this.slabForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.SLAG_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/slag_brick/slag_brick"));
        this.slabForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CLINKER_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/clinker_brick/clinker_brick"));
        this.slabFor((Supplier<? extends Block>)IEBlocks.StoneDecoration.COKE, ImmersiveEngineering.rl((String)"block/stone_decoration/coke"));
        this.slabForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete/concrete"));
        this.slabForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_brick/concrete_brick"));
        this.slabForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_TILE, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_tile/concrete_tile"));
        this.slabFor((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_LEADED, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_leaded"));
        this.slabFor((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_REINFORCED, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_reinforced"));
        this.slabFor((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_REINFORCED_TILE, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_reinforced_tile"));
        this.slabForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete/hempcrete"));
        this.slabForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete_brick/hempcrete_brick"));
        this.slabFor((Supplier<? extends Block>)IEBlocks.StoneDecoration.INSULATING_GLASS, ImmersiveEngineering.rl((String)"block/stone_decoration/insulating_glass"), RenderType.translucent());
        this.slabFor((Supplier<? extends Block>)IEBlocks.StoneDecoration.ALLOYBRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/alloybrick"));
        for (MetalScaffoldingType metalScaffoldingType : TreatedWoodStyles.values()) {
            this.slabFor((Supplier)IEBlocks.WoodenDecoration.TREATED_WOOD.get(metalScaffoldingType), ImmersiveEngineering.rl((String)("block/wooden_decoration/treated_wood_" + metalScaffoldingType.name().toLowerCase(Locale.ENGLISH))));
        }
        this.stairsForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.SLAG_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/slag_brick/slag_brick"));
        this.stairsForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CLINKER_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/clinker_brick/clinker_brick"));
        this.stairsForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete/hempcrete"));
        this.stairsForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete_brick/hempcrete_brick"));
        this.stairsForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete/concrete"));
        this.stairsForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_brick/concrete_brick"));
        this.stairsForMultiEightAll((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_TILE, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_tile/concrete_tile"));
        this.stairsFor((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_LEADED, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_leaded"));
        for (MetalScaffoldingType metalScaffoldingType : TreatedWoodStyles.values()) {
            this.stairsFor((Supplier)IEBlocks.WoodenDecoration.TREATED_WOOD.get(metalScaffoldingType), ImmersiveEngineering.rl((String)("block/wooden_decoration/treated_wood_" + metalScaffoldingType.name().toLowerCase(Locale.ENGLISH))));
        }
        this.wallForMultiEight((Supplier<? extends Block>)IEBlocks.StoneDecoration.SLAG_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/slag_brick/slag_brick"), ImmersiveEngineering.rl((String)"block/stone_decoration/slag_brick/slag_brick_wall"), ImmersiveEngineering.rl((String)"block/stone_decoration/slag_brick/slag_brick_top"));
        this.wallForMultiEight((Supplier<? extends Block>)IEBlocks.StoneDecoration.CLINKER_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/clinker_brick/clinker_brick"), ImmersiveEngineering.rl((String)"block/stone_decoration/clinker_brick/clinker_brick_wall"), ImmersiveEngineering.rl((String)"block/stone_decoration/clinker_brick/clinker_brick_top"));
        this.wallForMultiEight((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete/hempcrete"), ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete/hempcrete"), ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete/hempcrete"));
        this.wallForMultiEight((Supplier<? extends Block>)IEBlocks.StoneDecoration.HEMPCRETE_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete_brick/hempcrete_brick"), ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete_brick/hempcrete_brick"), ImmersiveEngineering.rl((String)"block/stone_decoration/hempcrete_brick/hempcrete_brick"));
        this.wallForMultiEight((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete/concrete"), ImmersiveEngineering.rl((String)"block/stone_decoration/concrete/concrete"), ImmersiveEngineering.rl((String)"block/stone_decoration/concrete/concrete"));
        this.wallForMultiEight((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_BRICK, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_brick/concrete_brick"), ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_brick/concrete_brick"), ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_brick/concrete_brick"));
        this.wallForMultiEight((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_TILE, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_tile/concrete_tile"), ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_tile/concrete_tile"), ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_tile/concrete_tile"));
        this.wallForSingle((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_LEADED, ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_leaded"), ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_leaded"), ImmersiveEngineering.rl((String)"block/stone_decoration/concrete_leaded_wall_top"));
        this.postBlock((Supplier<? extends Block>)IEBlocks.WoodenDecoration.TREATED_POST, ImmersiveEngineering.rl((String)"block/wooden_decoration/post"));
        this.postBlock((Supplier<? extends Block>)IEBlocks.MetalDecoration.STEEL_POST, ImmersiveEngineering.rl((String)"block/metal_decoration/steel_post"));
        this.postBlock((Supplier<? extends Block>)IEBlocks.MetalDecoration.ALU_POST, ImmersiveEngineering.rl((String)"block/metal_decoration/aluminum_post"));
        this.simpleBlock((Block)IEMultiblockLogic.BUCKET_WHEEL.block().get(), new ConfiguredModel[]{this.emptyWithParticles("block/bucket_wheel", "block/multiblocks/bucket_wheel")});
        this.simpleBlock(IEBlocks.MetalDevices.FLUID_PIPE.get(), (ModelFile)this.ieObjBuilder("block/metal_device/fluid_pipe.obj.ie").callback((IEOBJCallback<?>)PipeCallbacks.INSTANCE).layer(RenderType.cutout()).end());
        TurretRenderer.MODEL_FILE_BY_BLOCK.forEach(this::turret);
        for (Map.Entry entry : IEBlocks.MetalDevices.CHUTES.entrySet()) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.ieObjBuilder("block/metal_device/chute_" + ((EnumMetals)entry.getKey()).tagName(), ImmersiveEngineering.rl((String)"block/metal_device/chute.obj.ie")).callback((IEOBJCallback<?>)ChuteCallbacks.INSTANCE).end()).texture("texture", ImmersiveEngineering.rl((String)("block/metal/sheetmetal_" + ((EnumMetals)entry.getKey()).tagName())))).texture("particle", ImmersiveEngineering.rl((String)("block/metal/sheetmetal_" + ((EnumMetals)entry.getKey()).tagName())));
            this.simpleBlock(((IEBlocks.BlockEntry)entry.getValue()).get(), (ModelFile)model);
        }
        for (Map.Entry entry : IEBlocks.MetalDevices.DYED_CHUTES.entrySet()) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.ieObjBuilder("block/metal_device/chute_colored_" + ((DyeColor)entry.getKey()).getName(), ImmersiveEngineering.rl((String)"block/metal_device/chute.obj.ie")).callback((IEOBJCallback<?>)ChuteCallbacks.INSTANCE).end()).texture("texture", ImmersiveEngineering.rl((String)("block/metal/sheetmetal_" + ((DyeColor)entry.getKey()).getName())))).texture("particle", ImmersiveEngineering.rl((String)("block/metal/sheetmetal_" + ((DyeColor)entry.getKey()).getName())));
            this.simpleBlock(((IEBlocks.BlockEntry)entry.getValue()).get(), (ModelFile)model);
        }
        this.simpleBlock(IEBlocks.Misc.FAKE_LIGHT.get(), new ConfiguredModel[]{this.EMPTY_MODEL});
        this.createMultistateSingleModel((Supplier<? extends Block>)IEBlocks.WoodenDevices.WINDMILL, this.emptyWithParticles("block/windmill", "block/wooden_device/windmill"));
        this.createMultistateSingleModel((Supplier<? extends Block>)IEBlocks.WoodenDevices.WATERMILL, this.emptyWithParticles("block/watermill", "block/wooden_device/watermill"));
        this.createMultistateSingleModel((Supplier<? extends Block>)IEBlocks.MetalDecoration.LANTERN, new ConfiguredModel((ModelFile)this.ieObjBuilder("block/lantern.obj.ie").callback((IEOBJCallback<?>)LanternCallbacks.INSTANCE).end()));
        BlockModelBuilder offModel = (BlockModelBuilder)((BlockModelBuilder)this.ieObjBuilder("block/cagelamp_off", ImmersiveEngineering.rl((String)"block/cagelamp.obj")).callback((IEOBJCallback<?>)CagelampCallbacks.INSTANCE).end()).texture("texture", this.modLoc("block/metal_decoration/cagelamp"));
        BlockModelBuilder blockModelBuilder = (BlockModelBuilder)((BlockModelBuilder)this.ieObjBuilder("block/cagelamp_on", ImmersiveEngineering.rl((String)"block/cagelamp.obj")).callback((IEOBJCallback<?>)CagelampCallbacks.INSTANCE).end()).texture("texture", this.modLoc("block/metal_decoration/cagelamp_on"));
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDecoration.CAGELAMP, (VariantBlockStateBuilder.PartialBlockstate state) -> state.getSetStates().get(IEProperties.ACTIVE) == Boolean.TRUE ? onModel : offModel, (Property<Direction>)IEProperties.FACING_ALL, List.of(IEProperties.ACTIVE), 270, 0);
        ModelFile noneModel = this.createMetalLadder("metal_ladder", null, null, null);
        ModelFile modelFile = this.createMetalLadder("metal_ladder_alu", ImmersiveEngineering.rl((String)"block/metal_decoration/aluminum_scaffolding_open"), ImmersiveEngineering.rl((String)"block/metal_decoration/aluminum_scaffolding"), null);
        ModelFile aluModelOpen = this.createMetalLadder("metal_ladder_alu_open", ImmersiveEngineering.rl((String)"block/metal_decoration/aluminum_scaffolding_open_u"), ImmersiveEngineering.rl((String)"block/metal_decoration/aluminum_scaffolding"), ImmersiveEngineering.rl((String)"block/metal_decoration/aluminum_scaffolding_open_sides"));
        ModelFile modelFile2 = this.createMetalLadder("metal_ladder_steel", ImmersiveEngineering.rl((String)"block/metal_decoration/steel_scaffolding_open"), ImmersiveEngineering.rl((String)"block/metal_decoration/steel_scaffolding"), null);
        ModelFile steelModelOpen = this.createMetalLadder("metal_ladder_steel_open", ImmersiveEngineering.rl((String)"block/metal_decoration/steel_scaffolding_open_u"), ImmersiveEngineering.rl((String)"block/metal_decoration/steel_scaffolding"), ImmersiveEngineering.rl((String)"block/metal_decoration/steel_scaffolding_open_sides"));
        IEBlocks.BlockEntry steel = (IEBlocks.BlockEntry)IEBlocks.MetalDecoration.METAL_LADDER.get(MetalLadderBlock.CoverType.STEEL);
        IEBlocks.BlockEntry alu = (IEBlocks.BlockEntry)IEBlocks.MetalDecoration.METAL_LADDER.get(MetalLadderBlock.CoverType.ALU);
        IEBlocks.BlockEntry none = (IEBlocks.BlockEntry)IEBlocks.MetalDecoration.METAL_LADDER.get(MetalLadderBlock.CoverType.NONE);
        this.createDirectionalBlock((Supplier<? extends Block>)none, (Property<Direction>)LadderBlock.FACING, noneModel);
        this.createLadderBlock((Supplier<? extends Block>)alu, modelFile, aluModelOpen);
        this.createLadderBlock((Supplier<? extends Block>)steel, modelFile2, steelModelOpen);
        this.itemModel((Supplier<? extends Block>)alu, modelFile);
        this.itemModel((Supplier<? extends Block>)steel, modelFile2);
        this.createWallmount((Supplier<? extends Block>)IEBlocks.WoodenDevices.TREATED_WALLMOUNT, ImmersiveEngineering.rl((String)"block/wooden_device/wallmount"));
        ModelBuilder turntableModel = this.models().cubeBottomTop("turntable", this.modLoc("block/wooden_device/turntable"), this.modLoc("block/wooden_device/turntable_bottom"), this.modLoc("block/wooden_device/turntable_top"));
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.WoodenDevices.TURNTABLE, (ModelFile)turntableModel, (Property<Direction>)IEProperties.FACING_ALL, (List<Property<?>>)ImmutableList.of(), -90, 0);
        this.itemModel((Supplier<? extends Block>)IEBlocks.WoodenDevices.TURNTABLE, (ModelFile)turntableModel);
        this.createWallmount((Supplier<? extends Block>)IEBlocks.MetalDecoration.ALU_WALLMOUNT, ImmersiveEngineering.rl((String)"block/metal_decoration/aluminum_wallmount"));
        this.createWallmount((Supplier<? extends Block>)IEBlocks.MetalDecoration.STEEL_WALLMOUNT, ImmersiveEngineering.rl((String)"block/metal_decoration/steel_wallmount"));
        this.createStructuralArm("block/metal_decoration/steel_scaffolding", (Supplier<? extends Block>)IEBlocks.MetalDecoration.STEEL_SLOPE);
        this.createStructuralArm("block/metal_decoration/aluminum_scaffolding", (Supplier<? extends Block>)IEBlocks.MetalDecoration.ALU_SLOPE);
        Object windowModel = ((BlockModelBuilder)this.models().withExistingParent("treated_window", this.modLoc("block/window_thick"))).texture("frame", "immersiveengineering:block/wooden_decoration/treated_wood_vertical");
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.WoodenDecoration.WINDOW, (ModelFile)windowModel, (Property<Direction>)IEProperties.FACING_ALL, List.of(), 0, 180);
        this.itemModel((Supplier<? extends Block>)IEBlocks.WoodenDecoration.WINDOW, (ModelFile)windowModel);
        windowModel = ((BlockModelBuilder)this.models().withExistingParent("steel_window", this.modLoc("block/window_thin"))).texture("frame", "immersiveengineering:block/metal/storage_steel");
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDecoration.STEEL_WINDOW, (ModelFile)windowModel, (Property<Direction>)IEProperties.FACING_ALL, List.of(), 0, 180);
        this.itemModel((Supplier<? extends Block>)IEBlocks.MetalDecoration.STEEL_WINDOW, (ModelFile)windowModel);
        windowModel = ((BlockModelBuilder)this.models().withExistingParent("alu_window", this.modLoc("block/window_thin"))).texture("frame", "immersiveengineering:block/metal/storage_aluminum");
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDecoration.ALU_WINDOW, (ModelFile)windowModel, (Property<Direction>)IEProperties.FACING_ALL, List.of(), 0, 180);
        this.itemModel((Supplier<? extends Block>)IEBlocks.MetalDecoration.ALU_WINDOW, (ModelFile)windowModel);
        windowModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("reinforced_window", this.modLoc("block/window_thick"))).texture("glass", "immersiveengineering:block/panzerglass")).texture("frame", "minecraft:block/netherite_block");
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDecoration.REINFORCED_WINDOW, (ModelFile)windowModel, (Property<Direction>)IEProperties.FACING_ALL, List.of(), 0, 180);
        this.itemModel((Supplier<? extends Block>)IEBlocks.MetalDecoration.REINFORCED_WINDOW, (ModelFile)windowModel);
        this.createCatwalk((Supplier<? extends Block>)IEBlocks.WoodenDecoration.CATWALK, "immersiveengineering:block/wooden_decoration/scaffolding_top", "immersiveengineering:block/wooden_decoration/scaffolding");
        this.createCatwalkStairs((Supplier<? extends Block>)IEBlocks.WoodenDecoration.CATWALK_STAIRS, "immersiveengineering:block/wooden_decoration/scaffolding_top", "immersiveengineering:block/wooden_decoration/scaffolding");
        this.createCatwalk((Supplier<? extends Block>)IEBlocks.MetalDecoration.STEEL_CATWALK, "immersiveengineering:block/metal_decoration/steel_scaffolding_top_grate_top", "immersiveengineering:block/metal_decoration/steel_scaffolding");
        this.createCatwalkStairs((Supplier<? extends Block>)IEBlocks.MetalDecoration.STEEL_CATWALK_STAIRS, "immersiveengineering:block/metal_decoration/steel_scaffolding_top_grate_top", "immersiveengineering:block/metal_decoration/steel_scaffolding");
        this.createCatwalk((Supplier<? extends Block>)IEBlocks.MetalDecoration.ALU_CATWALK, "immersiveengineering:block/metal_decoration/aluminum_scaffolding_top_grate_top", "immersiveengineering:block/metal_decoration/aluminum_scaffolding");
        this.createCatwalkStairs((Supplier<? extends Block>)IEBlocks.MetalDecoration.ALU_CATWALK_STAIRS, "immersiveengineering:block/metal_decoration/aluminum_scaffolding_top_grate_top", "immersiveengineering:block/metal_decoration/aluminum_scaffolding");
        this.createDoor((Supplier<? extends DoorBlock>)IEBlocks.WoodenDecoration.DOOR, "block/wooden_decoration/treated_door");
        this.createDoor((Supplier<? extends DoorBlock>)IEBlocks.WoodenDecoration.DOOR_FRAMED, "block/wooden_decoration/treated_door_framed");
        this.createDoor((Supplier<? extends DoorBlock>)IEBlocks.MetalDecoration.STEEL_DOOR, "block/metal_decoration/steel_door");
        this.createTrapdoor((Supplier<? extends TrapDoorBlock>)IEBlocks.WoodenDecoration.TRAPDOOR, "block/wooden_decoration/treated_trapdoor");
        this.createTrapdoor((Supplier<? extends TrapDoorBlock>)IEBlocks.WoodenDecoration.TRAPDOOR_FRAMED, "block/wooden_decoration/treated_trapdoor_framed");
        this.createTrapdoor((Supplier<? extends TrapDoorBlock>)IEBlocks.MetalDecoration.STEEL_TRAPDOOR, "block/metal_decoration/steel_trapdoor");
        this.createSigns(IEBlocks.WoodenDecoration.SIGN, "block/wooden_decoration/treated_wood_horizontal");
        this.createSigns(IEBlocks.MetalDecoration.STEEL_SIGN, "block/metal/storage_steel");
        this.createSigns(IEBlocks.MetalDecoration.ALU_SIGN, "block/metal/storage_aluminum");
        for (Map.Entry entry : IEBlocks.MetalDecoration.WARNING_SIGNS.entrySet()) {
            Direction[] name = ((WarningSignBlock.WarningSignIcon)entry.getKey()).getSerializedName();
            ModelBuilder modelBuilder = ((BlockModelBuilder)this.models().withExistingParent("warning_sign_" + (String)name, this.modLoc("block/warning_sign"))).texture("icon", ImmersiveEngineering.rl((String)("block/metal_decoration/sign/icon_" + (String)name)));
            this.createHorizontalRotatedBlock((Supplier)entry.getValue(), (ModelFile)modelBuilder);
        }
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.StoneDecoration.CORESAMPLE, (ModelFile)this.obj("block/coresample.obj"));
        ResourceLocation concreteTexture = ImmersiveEngineering.rl((String)"block/stone_decoration/concrete/concrete0");
        this.simpleBlockAndItem((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_SHEET, (ModelFile)this.models().carpet("concrete_sheet", concreteTexture));
        this.simpleBlockAndItem((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_QUARTER, this.quarter("concrete_quarter", concreteTexture));
        this.simpleBlockAndItem((Supplier<? extends Block>)IEBlocks.StoneDecoration.CONCRETE_THREE_QUARTER, this.threeQuarter("concrete_three_quarter", concreteTexture));
        this.simpleBlock(IEBlocks.StoneDecoration.CONCRETE_SPRAYED.get(), (ModelFile)this.obj("block/sprayed_concrete.obj", RenderType.cutout()));
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.WoodenDevices.CRAFTING_TABLE, (ModelFile)this.obj("block/wooden_device/craftingtable.obj"));
        MultiPartBlockStateBuilder multiPartBlockStateBuilder = this.getMultipartBuilder(IEBlocks.WoodenDevices.BLUEPRINT_SHELF.get());
        for (Direction d : Direction.values()) {
            int rotX = d.getAxis() == Direction.Axis.Y ? -90 : 0;
            int rotY = d.getAxis() == Direction.Axis.Y ? 0 : this.getAngle(d, 180);
            ((MultiPartBlockStateBuilder.PartBuilder)multiPartBlockStateBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/blueprint_shelf/frame"))).rotationX(rotX).rotationY(rotY).addModel()).condition((Property)IEProperties.FACING_ALL, (Comparable[])new Direction[]{d}).end();
            for (int i = 0; i < BlueprintShelfBlock.BLUEPRINT_SLOT_FILLED.length; ++i) {
                ((MultiPartBlockStateBuilder.PartBuilder)multiPartBlockStateBuilder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/blueprint_shelf/blueprint_" + i))).rotationX(rotX).rotationY(rotY).addModel()).condition((Property)IEProperties.FACING_ALL, (Comparable[])new Direction[]{d}).condition((Property)BlueprintShelfBlock.BLUEPRINT_SLOT_FILLED[i], (Comparable[])new Boolean[]{true}).end();
            }
        }
        this.itemModel((Supplier<? extends Block>)IEBlocks.WoodenDevices.BLUEPRINT_SHELF, (ModelFile)this.models().getExistingFile(this.modLoc("block/blueprint_shelf/frame")));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.WoodenDevices.CRATE, this.modLoc("block/wooden_device/crate"));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.WoodenDevices.REINFORCED_CRATE, this.modLoc("block/wooden_device/reinforced_crate"));
        ModelBuilder modelBuilder = this.models().cubeBottomTop("gunpowder_barrel", ImmersiveEngineering.rl((String)"block/wooden_device/gunpowder_barrel"), ImmersiveEngineering.rl((String)"block/wooden_device/barrel_up_none"), ImmersiveEngineering.rl((String)"block/wooden_device/gunpowder_barrel_top"));
        this.createMultistateSingleModel((Supplier<? extends Block>)IEBlocks.WoodenDevices.GUNPOWDER_BARREL, new ConfiguredModel((ModelFile)modelBuilder));
        this.itemModel((Supplier<? extends Block>)IEBlocks.WoodenDevices.GUNPOWDER_BARREL, (ModelFile)modelBuilder);
        this.simpleBlockAndItem((Supplier<? extends Block>)IEBlocks.WoodenDevices.SORTER, this.createRouterModel(ImmersiveEngineering.rl((String)"block/wooden_device/sorter"), "router"));
        ModelBuilder modelBuilder2 = this.models().cubeBottomTop("item_batcher", this.modLoc("block/wooden_device/item_batcher"), this.modLoc("block/wooden_device/item_batcher_in"), this.modLoc("block/wooden_device/item_batcher_out"));
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.WoodenDevices.ITEM_BATCHER, (ModelFile)modelBuilder2, (Property<Direction>)IEProperties.FACING_ALL, (List<Property<?>>)ImmutableList.of(), -90, 0);
        this.itemModel((Supplier<? extends Block>)IEBlocks.WoodenDevices.ITEM_BATCHER, (ModelFile)modelBuilder2);
        this.simpleBlockAndItem((Supplier<? extends Block>)IEBlocks.WoodenDevices.FLUID_SORTER, this.createRouterModel(ImmersiveEngineering.rl((String)"block/wooden_device/fluid_sorter"), "fluid_router"));
        this.simpleBlockAndItem((Supplier<? extends Block>)IEBlocks.WoodenDevices.WOODEN_BARREL, (ModelFile)((SideConfigBuilder)((BlockModelBuilder)this.models().getBuilder("wooden_devices/barrel")).customLoader(SideConfigBuilder::begin)).type(ModelConfigurableSides.Type.VERTICAL).baseName(this.modLoc("block/wooden_device/barrel")).end());
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.WoodenDevices.LOGIC_UNIT, (ModelFile)this.ieObjBuilder("block/wooden_device/logic_unit.obj.ie").callback((IEOBJCallback<?>)LogicUnitCallbacks.INSTANCE).layer(RenderType.solid(), RenderType.translucent()).end());
        ModelBuilder modelBuilder3 = this.models().cubeBottomTop("machine_interface", this.modLoc("block/wooden_device/machine_interface"), this.modLoc("block/wooden_device/machine_interface_back"), this.modLoc("block/wooden_device/machine_interface_front"));
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.WoodenDevices.MACHINE_INTERFACE, (ModelFile)modelBuilder3, (Property<Direction>)IEProperties.FACING_HORIZONTAL, (List<Property<?>>)ImmutableList.of(), -90, 0);
        this.itemModel((Supplier<? extends Block>)IEBlocks.WoodenDevices.MACHINE_INTERFACE, (ModelFile)modelBuilder3);
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.Cloth.STRIP_CURTAIN, (VariantBlockStateBuilder.PartialBlockstate state) -> new ModelFile.ExistingModelFile(ImmersiveEngineering.rl((String)(state.getSetStates().get(StripCurtainBlock.CEILING_ATTACHED) == Boolean.FALSE ? "block/stripcurtain" : "block/stripcurtain_middle")), this.existingFileHelper), (List<Property<?>>)ImmutableList.of((Object)StripCurtainBlock.CEILING_ATTACHED));
        this.cubeAll((Supplier<? extends Block>)IEBlocks.Cloth.CUSHION, this.modLoc("block/cushion"));
        this.createMultistateSingleModel((Supplier<? extends Block>)IEBlocks.Cloth.SHADER_BANNER, this.EMPTY_MODEL);
        this.createMultistateSingleModel((Supplier<? extends Block>)IEBlocks.Cloth.SHADER_BANNER_WALL, this.EMPTY_MODEL);
        this.simpleBlockAndItem((Supplier<? extends Block>)IEBlocks.MetalDevices.BARREL, (ModelFile)((SideConfigBuilder)((BlockModelBuilder)this.models().getBuilder("metal_devices/barrel")).customLoader(SideConfigBuilder::begin)).type(ModelConfigurableSides.Type.VERTICAL).baseName(this.modLoc("block/metal_device/barrel")).end());
        for (Map.Entry cap : ImmutableMap.of((Object)IEBlocks.MetalDevices.CAPACITOR_CREATIVE, (Object)"creative", (Object)IEBlocks.MetalDevices.CAPACITOR_LV, (Object)"lv", (Object)IEBlocks.MetalDevices.CAPACITOR_MV, (Object)"mv", (Object)IEBlocks.MetalDevices.CAPACITOR_HV, (Object)"hv").entrySet()) {
            ModelBuilder modelBuilder4 = ((SideConfigBuilder)((BlockModelBuilder)this.models().getBuilder("block/metal_device/capacitor_" + (String)cap.getValue())).customLoader(SideConfigBuilder::begin)).type(ModelConfigurableSides.Type.SIDE_TOP_BOTTOM).baseName(this.modLoc("block/metal_device/capacitor_" + (String)cap.getValue())).end();
            this.simpleBlockAndItem((Supplier<? extends Block>)((Supplier)cap.getKey()), (ModelFile)modelBuilder4);
        }
        ModelBuilder modelBuilder5 = ((BlockModelBuilder)((SideConfigBuilder)((BlockModelBuilder)this.models().getBuilder("block/metal_device/fluid_placer")).customLoader(SideConfigBuilder::begin)).type(ModelConfigurableSides.Type.ALL_SAME_TEXTURE).baseName(this.modLoc("block/metal_device/fluid_placer")).end()).renderType(ModelProviderUtils.getName(RenderType.cutout()));
        this.simpleBlockAndItem((Supplier<? extends Block>)IEBlocks.MetalDevices.FLUID_PLACER, (ModelFile)modelBuilder5);
        BlockModelBuilder blockModelBuilder2 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("furnace_heater_on", ImmersiveEngineering.rl((String)"block/ie_six_sides_overlay_all_but_one"))).texture("block_all", ImmersiveEngineering.rl((String)"block/metal_device/furnace_heater_active"))).texture("block_north", ImmersiveEngineering.rl((String)"block/metal_device/furnace_heater_socket"))).texture("overlay_all", ImmersiveEngineering.rl((String)"block/metal_device/furnace_heater_active_overlay"));
        BlockModelBuilder furnaceHeaterOff = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("furnace_heater_off", ImmersiveEngineering.rl((String)"block/ie_six_sides_overlay_all_but_one"))).texture("block_all", ImmersiveEngineering.rl((String)"block/metal_device/furnace_heater"))).texture("block_north", ImmersiveEngineering.rl((String)"block/metal_device/furnace_heater_socket"))).texture("overlay_all", ImmersiveEngineering.rl((String)"block/metal_device/furnace_heater_overlay"));
        this.setRenderType(RenderType.cutout(), new ModelBuilder[]{blockModelBuilder2, furnaceHeaterOff});
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDevices.FURNACE_HEATER, (VariantBlockStateBuilder.PartialBlockstate props) -> {
            if (props.getSetStates().get(IEProperties.ACTIVE) == Boolean.TRUE) {
                return furnaceHeaterOn;
            }
            return furnaceHeaterOff;
        }, (Property<Direction>)IEProperties.FACING_ALL, (List<Property<?>>)ImmutableList.of((Object)IEProperties.ACTIVE), 180, 0);
        this.itemModel((Supplier<? extends Block>)IEBlocks.MetalDevices.FURNACE_HEATER, (ModelFile)furnaceHeaterOff);
        this.createPump();
        ModelBuilder modelBuilder6 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("kinetic_dynamo", this.mcLoc("block/cube"))).texture("down", this.modLoc("block/metal_device/dynamo_top"))).texture("south", this.modLoc("block/metal_device/dynamo_top"))).texture("up", this.modLoc("block/metal_device/dynamo_top"))).texture("north", this.modLoc("block/metal_device/dynamo_front"))).texture("west", this.modLoc("block/metal_device/dynamo_side"))).texture("east", this.modLoc("block/metal_device/dynamo_side"))).texture("particle", this.modLoc("block/metal_device/dynamo_side"));
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDevices.DYNAMO, (ModelFile)modelBuilder6);
        this.itemModel((Supplier<? extends Block>)IEBlocks.MetalDevices.DYNAMO, (ModelFile)modelBuilder6);
        this.simpleBlockAndItem((Supplier<? extends Block>)IEBlocks.MetalDevices.THERMOELECTRIC_GEN, new ConfiguredModel((ModelFile)this.models().cubeBottomTop("thermoelectric_generator", this.modLoc("block/metal_device/thermoelectric_gen_side"), this.modLoc("block/metal_device/thermoelectric_gen_bottom"), this.modLoc("block/metal_device/thermoelectric_gen_top"))));
        ModelFile modelFile3 = this.createMultiLayer("metal_device/charging_station", (Map<RenderType, ResourceLocation>)ImmutableMap.of((Object)RenderType.solid(), (Object)this.modLoc("block/metal_device/charging_station.obj"), (Object)RenderType.translucent(), (Object)this.modLoc("block/metal_device/charging_station_glass.obj")), this.modLoc("block/metal_device/charging_station.obj"));
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDevices.CHARGING_STATION, modelFile3);
        this.itemModel((Supplier<? extends Block>)IEBlocks.MetalDevices.CHARGING_STATION, modelFile3);
        for (IEBlocks.BlockEntry b : IEBlocks.MetalDevices.CONVEYORS.values()) {
            this.createMultistateSingleModel((Supplier<? extends Block>)b, new ConfiguredModel((ModelFile)((ConveyorModelBuilder)((BlockModelBuilder)this.models().getBuilder(b.getId().getPath())).customLoader(ConveyorModelBuilder::begin)).type(((ConveyorBlock)b.get()).getType()).end()));
        }
        ModelBuilder modelBuilder7 = this.models().cubeBottomTop("electromagnet", this.modLoc("block/metal_device/electromagnet"), this.modLoc("block/metal_device/electromagnet_bottom"), this.modLoc("block/metal_device/electromagnet_top"));
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDevices.ELECTROMAGNET, (ModelFile)modelBuilder7, (Property<Direction>)IEProperties.FACING_ALL, (List<Property<?>>)ImmutableList.of(), -90, 0);
        this.itemModel((Supplier<? extends Block>)IEBlocks.MetalDevices.ELECTROMAGNET, (ModelFile)modelBuilder7);
        this.createHemp();
        BlockModelBuilder blockModelBuilder3 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("potted_hemp", this.mcLoc("block/flower_pot_cross"))).texture("plant", IEApi.ieLoc((String)"block/hemp/potted"))).renderType(ModelProviderUtils.getName(RenderType.cutout()));
        this.simpleBlock(IEBlocks.Misc.POTTED_HEMP.get(), (ModelFile)blockModelBuilder3);
        this.createSawdust();
        for (IEFluids.FluidEntry entry : IEFluids.ALL_ENTRIES) {
            IEFluid iEFluid = entry.getStill();
            ModelBuilder model2 = ((BlockModelBuilder)this.models().getBuilder("block/fluid/" + BuiltInRegistries.FLUID.getKey((Object)iEFluid).getPath())).texture("particle", entry.stillTexture());
            this.getVariantBuilder((Block)entry.getBlock()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2)});
        }
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDevices.TOOLBOX, (ModelFile)this.obj("block/toolbox.obj"));
    }

    public void createStructuralArm(String texture, Supplier<? extends Block> block) {
        ResourceLocation objFile = this.modLoc("block/slope.obj.ie");
        ResourceLocation textureRL = this.modLoc(texture);
        ModelBuilder steelModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.ieObjBuilder(this.name(block), objFile).callback((IEOBJCallback<?>)StructuralArmCallbacks.INSTANCE).layer(RenderType.cutout()).end()).texture("texture", textureRL)).texture("particle", textureRL)).parent((ModelFile)new ModelFile.ExistingModelFile(this.mcLoc("block/block"), this.existingFileHelper));
        this.createMultistateSingleModel(block, new ConfiguredModel((ModelFile)steelModel));
        this.itemModel(block, (ModelFile)this.obj(this.name(block) + "_item", objFile, (Map<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)textureRL), this.models()));
    }

    public void turret(Supplier<? extends Block> b, String loc) {
        BlockModelBuilder masterModel = (BlockModelBuilder)this.ieObjBuilder(loc).callback((IEOBJCallback<?>)TurretCallbacks.INSTANCE).end();
        ModelBuilder top = ((BlockModelBuilder)this.models().withExistingParent(this.name(b) + "_top", this.EMPTY_MODEL.model.getLocation())).texture("particle", (String)generatedParticleTextures.get(masterModel.getLocation()));
        this.createHorizontalRotatedBlock(b, arg_0 -> BlockStates.lambda$turret$3((ModelFile)top, masterModel, arg_0), (List<Property<?>>)ImmutableList.of((Object)IEProperties.MULTIBLOCKSLAVE));
    }

    public void fenceBlock(Supplier<? extends FenceBlock> b, ResourceLocation texture) {
        super.fenceBlock(b.get(), texture);
        this.itemModel(b, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)((Block)b.get())).getPath() + "_inventory", this.mcLoc("block/fence_inventory"))).texture("texture", texture));
    }

    public void fenceGateBlock(Supplier<? extends FenceGateBlock> b, ResourceLocation texture) {
        super.fenceGateBlock(b.get(), texture);
        this.itemModel(b, (ModelFile)this.models().getExistingFile(ImmersiveEngineering.rl((String)("block/" + BuiltInRegistries.BLOCK.getKey((Object)((Block)b.get())).getPath()))));
    }

    private void createMultistateSingleModel(Supplier<? extends Block> block, ConfiguredModel model) {
        this.getVariantBuilder(block.get()).partialState().setModels(new ConfiguredModel[]{model});
    }

    private void createPump() {
        VariantBlockStateBuilder builder = this.getVariantBuilder(IEBlocks.MetalDevices.FLUID_PUMP.get());
        builder.partialState().with((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.obj("block/metal_device/fluid_pump.obj"), 0, 0, false)});
        builder.partialState().with((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((SideConfigBuilder)((BlockModelBuilder)this.models().getBuilder("metal_device/pump_bottom")).customLoader(SideConfigBuilder::begin)).type(ModelConfigurableSides.Type.SIDE_VERTICAL).baseName(this.modLoc("block/metal_device/fluid_pump")).end())});
    }

    public ModelFile createMetalLadder(String name, @Nullable ResourceLocation bottomTop, @Nullable ResourceLocation sides, @Nullable ResourceLocation front) {
        ResourceLocation parent;
        HashMap<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
        if (bottomTop != null) {
            Preconditions.checkNotNull((Object)sides);
            textures.put("top", bottomTop);
            textures.put("bottom", bottomTop);
            textures.put("side", sides);
            if (front != null) {
                parent = IEApi.ieLoc((String)"block/ie_scaffoldladder_open");
                textures.put("front", front);
            } else {
                parent = IEApi.ieLoc((String)"block/ie_scaffoldladder");
            }
        } else {
            parent = IEApi.ieLoc((String)"block/ie_ladder");
        }
        textures.put("ladder", ImmersiveEngineering.rl((String)"block/metal_decoration/metal_ladder"));
        BlockModelBuilder ret = (BlockModelBuilder)this.models().withExistingParent(name, parent);
        for (Map.Entry e : textures.entrySet()) {
            ret.texture((String)e.getKey(), (ResourceLocation)e.getValue());
        }
        ret.renderType(ModelProviderUtils.getName(RenderType.cutout()));
        return ret;
    }

    private void createDirectionalBlock(Supplier<? extends Block> b, Property<Direction> prop, ModelFile model) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(b.get());
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            builder.partialState().with(prop, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, this.getAngle(d, 180), true)});
        }
    }

    private void createLadderBlock(Supplier<? extends Block> b, ModelFile model, ModelFile modelOpen) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(b.get());
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            builder.partialState().with((Property)LadderBlock.FACING, (Comparable)d).with((Property)MetalLadderBlock.OPEN, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, this.getAngle(d, 180), true)});
            builder.partialState().with((Property)LadderBlock.FACING, (Comparable)d).with((Property)MetalLadderBlock.OPEN, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(modelOpen, 0, this.getAngle(d, 180), false)});
        }
    }

    private void createWallmount(Supplier<? extends Block> b, ResourceLocation texture) {
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(b.get());
        for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
            int rotation = this.getAngle(d, 0);
            for (WallmountBlock.Orientation or : WallmountBlock.Orientation.values()) {
                ResourceLocation modelLoc = ImmersiveEngineering.rl((String)("block/wooden_device/wallmount" + or.modelSuffix() + ".obj"));
                Object model = this.obj(BuiltInRegistries.BLOCK.getKey((Object)b.get()).getPath() + or.modelSuffix(), modelLoc, (Map<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)texture), this.models());
                stateBuilder.partialState().with((Property)IEProperties.FACING_HORIZONTAL, (Comparable)d).with((Property)WallmountBlock.ORIENTATION, (Comparable)or).setModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, rotation, true)});
            }
        }
    }

    private void createCatwalk(Supplier<? extends Block> block, String textureTop, String textureSide) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath();
        BlockModelBuilder base = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_base", this.modLoc("block/catwalk_base"))).texture("top", textureTop)).texture("side", textureSide);
        BlockModelBuilder railing = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_railing", this.modLoc("block/catwalk_railing"))).texture("top", textureTop)).texture("side", textureSide);
        MultiPartBlockStateBuilder multipartBuilder = this.getMultipartBuilder(block.get());
        ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)base).addModel()).end();
        CatwalkBlock.RAILING_PROPERTIES.forEach((direction, booleanProperty) -> ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)railing).rotationY(this.getAngle((Direction)direction, 180)).addModel()).condition((Property)booleanProperty, (Comparable[])new Boolean[]{true}).end());
        this.itemModel(block, (ModelFile)((CompositeModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_item", "block/block")).customLoader(CompositeModelBuilder::begin)).child("base", (ModelBuilder)base).child("railing", (ModelBuilder)railing).end());
    }

    private void createCatwalkStairs(Supplier<? extends Block> block, String textureTop, String textureSide) {
        String name = BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath();
        ModelBuilder base = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_base", this.modLoc("block/catwalk_stairs"))).texture("top", textureTop)).texture("side", textureSide);
        ModelBuilder railing_r = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_railing_r", this.modLoc("block/catwalk_stairs_railing_r"))).texture("top", textureTop)).texture("side", textureSide);
        ModelBuilder railing_l = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_railing_l", this.modLoc("block/catwalk_stairs_railing_l"))).texture("top", textureTop)).texture("side", textureSide);
        MultiPartBlockStateBuilder multipartBuilder = this.getMultipartBuilder(block.get());
        for (Direction direction : IEProperties.FACING_HORIZONTAL.getPossibleValues()) {
            ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)base).rotationY(this.getAngle(direction, 180)).addModel()).condition((Property)IEProperties.FACING_HORIZONTAL, (Comparable[])new Direction[]{direction}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)railing_r).rotationY(this.getAngle(direction, 180)).addModel()).condition((Property)IEProperties.FACING_HORIZONTAL, (Comparable[])new Direction[]{direction}).condition((Property)CatwalkStairsBlock.RAILING_RIGHT, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)railing_l).rotationY(this.getAngle(direction, 180)).addModel()).condition((Property)IEProperties.FACING_HORIZONTAL, (Comparable[])new Direction[]{direction}).condition((Property)CatwalkStairsBlock.RAILING_LEFT, (Comparable[])new Boolean[]{true}).end();
        }
        this.itemModel(block, (ModelFile)base);
    }

    protected ModelFile createMultiLayer(String path, Map<RenderType, ResourceLocation> modelGetter, ResourceLocation particle) {
        CompositeModelBuilder modelBuilder = (CompositeModelBuilder)((BlockModelBuilder)this.models().getBuilder(path)).customLoader(CompositeModelBuilder::begin);
        for (Map.Entry<RenderType, ResourceLocation> entry : modelGetter.entrySet()) {
            ResourceLocation rl = entry.getValue();
            String layer = ModelProviderUtils.getName(entry.getKey());
            modelBuilder.child(layer, (ModelBuilder)((BlockModelBuilder)this.obj(new BlockModelBuilder(ImmersiveEngineering.rl((String)"temp"), this.existingFileHelper), rl, (Map<String, ResourceLocation>)ImmutableMap.of()).renderType(layer)));
        }
        return ((BlockModelBuilder)((BlockModelBuilder)modelBuilder.end()).parent((ModelFile)new ModelFile.ExistingModelFile(this.mcLoc("block/block"), this.existingFileHelper))).texture("particle", DataGenUtils.getTextureFromObj(particle, this.existingFileHelper));
    }

    private ModelFile quarter(String out, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().withExistingParent(out, this.modLoc("block/ie_quarter_block"))).texture("texture", texture);
    }

    private ModelFile threeQuarter(String out, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().withExistingParent(out, this.modLoc("block/ie_three_quarter_block"))).texture("texture", texture);
    }

    private void createDoor(Supplier<? extends DoorBlock> block, String texture) {
        this.doorBlockWithRenderType(block.get(), ImmersiveEngineering.rl((String)(texture + "_bottom")), ImmersiveEngineering.rl((String)(texture + "_top")), "cutout");
    }

    private void createTrapdoor(Supplier<? extends TrapDoorBlock> block, String texture) {
        this.trapdoorBlockWithRenderType(block.get(), ImmersiveEngineering.rl((String)texture), true, "cutout");
        this.itemModel(block, (ModelFile)this.models().getExistingFile(ImmersiveEngineering.rl((String)(BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).getPath() + "_bottom"))));
    }

    private void createSigns(IEBlocks.SignHolder holder, String particle) {
        this.signBlock((StandingSignBlock)holder.sign().get(), (WallSignBlock)holder.wall().get(), ImmersiveEngineering.rl((String)particle));
        this.hangingSignBlock((CeilingHangingSignBlock)holder.hanging().get(), (WallHangingSignBlock)holder.wallHanging().get(), ImmersiveEngineering.rl((String)particle));
    }

    private void createHemp() {
        VariantBlockStateBuilder builder = this.getVariantBuilder(IEBlocks.Misc.HEMP_PLANT.get());
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/hemp/top", ResourceLocation.withDefaultNamespace((String)"block/crop"))).texture("crop", IEApi.ieLoc((String)"block/hemp/top0"))).renderType(ModelProviderUtils.getName(RenderType.cutout()));
        builder.partialState().with((Property)HempBlock.HALF, (Comparable)DoubleBlockHalf.UPPER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        for (int i = 0; i <= 4; ++i) {
            model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/hemp/bottom" + i, ResourceLocation.withDefaultNamespace((String)"block/crop"))).texture("crop", IEApi.ieLoc((String)("block/hemp/bottom" + i)))).renderType(ModelProviderUtils.getName(RenderType.cutout()));
            builder.partialState().with((Property)HempBlock.HALF, (Comparable)DoubleBlockHalf.LOWER).with((Property)HempBlock.AGE, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }
    }

    private void createSawdust() {
        VariantBlockStateBuilder builder = this.getVariantBuilder(IEBlocks.WoodenDecoration.SAWDUST.get());
        ResourceLocation sawdustTexture = IEApi.ieLoc((String)"block/wooden_decoration/sawdust");
        ModelBuilder singleModel = null;
        Iterator iterator = SawdustBlock.LAYERS.getPossibleValues().iterator();
        while (iterator.hasNext()) {
            ModelBuilder model;
            int layer = (Integer)iterator.next();
            String name = "block/sawdust_" + layer;
            if (layer == 9) {
                model = this.models().cubeAll(name, sawdustTexture);
            } else {
                int height = layer * 2 - 1;
                model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, ResourceLocation.withDefaultNamespace((String)"block/thin_block"))).texture("particle", sawdustTexture)).texture("texture", sawdustTexture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, (float)height, 16.0f).allFaces((direction, faceBuilder) -> {
                    if (direction.getAxis() == Direction.Axis.Y) {
                        faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#texture");
                    } else {
                        faceBuilder.uvs(0.0f, (float)(16 - height), 16.0f, 16.0f).texture("#texture").cullface(direction);
                    }
                    if (direction != Direction.UP) {
                        faceBuilder.cullface(direction);
                    }
                }).end();
            }
            if (layer == 1) {
                singleModel = model;
            }
            builder.partialState().with((Property)SawdustBlock.LAYERS, (Comparable)Integer.valueOf(layer)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }
        this.itemModel((Supplier<? extends Block>)IEBlocks.WoodenDecoration.SAWDUST, (ModelFile)singleModel);
    }

    private ModelFile createRouterModel(ResourceLocation baseTexName, String outName) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(outName, this.modLoc("block/ie_six_sides"));
        for (Direction d : DirectionUtils.VALUES) {
            builder.texture(d.getSerializedName(), baseTexName.withSuffix("_" + d.ordinal()));
        }
        builder.texture("particle", baseTexName.withSuffix("_0"));
        return builder;
    }

    private static /* synthetic */ ModelFile lambda$turret$3(ModelFile top, BlockModelBuilder masterModel, VariantBlockStateBuilder.PartialBlockstate s) {
        if (s.getSetStates().get(IEProperties.MULTIBLOCKSLAVE) == Boolean.TRUE) {
            return top;
        }
        return masterModel;
    }
}

