/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.client.ieobj.BlockCallback;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.BucketWheelLogic;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class BucketWheelCallbacks
implements BlockCallback<Key> {
    public static final BucketWheelCallbacks INSTANCE = new BucketWheelCallbacks();
    private static final Key INVALID = new Key(Collections.emptyMap());

    @Override
    public Key extractKey(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState blockState, BlockEntity blockEntity) {
        MultiblockBlockEntityMaster masterBE;
        Object State2;
        if (blockEntity instanceof MultiblockBlockEntityMaster && (State2 = (masterBE = (MultiblockBlockEntityMaster)blockEntity).getHelper().getState()) instanceof BucketWheelLogic.State) {
            BucketWheelLogic.State state = (BucketWheelLogic.State)State2;
            return this.extractKey(state);
        }
        return this.getDefaultKey();
    }

    public Key extractKey(BucketWheelLogic.State state) {
        HashMap<String, TextureAtlasSprite> texMap = new HashMap<String, TextureAtlasSprite>();
        for (int i = 0; i < state.digStacks.size(); ++i) {
            ItemStack stackAtIndex = (ItemStack)state.digStacks.get(i);
            if (stackAtIndex.isEmpty()) continue;
            Block b = Block.byItem((Item)stackAtIndex.getItem());
            BlockState digState = b != Blocks.AIR ? b.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState();
            BakedModel digModel = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(digState);
            texMap.put("dig" + i, digModel.getParticleIcon(ModelData.EMPTY));
        }
        return new Key(texMap);
    }

    @Override
    @Nullable
    public TextureAtlasSprite getTextureReplacement(Key key, String group, String material) {
        return key.texMap.get(group);
    }

    @Override
    public Key getDefaultKey() {
        return INVALID;
    }

    @Override
    public boolean shouldRenderGroup(Key key, String group, RenderType layer) {
        return "bucketWheel".equals(group) || key.texMap.containsKey(group);
    }

    public record Key(Map<String, TextureAtlasSprite> texMap) {
    }
}

