/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.phys.Vec3;

public enum PlacementLimitation {
    SIDE_CLICKED((side, placer, hitPos) -> side),
    SIDE_CLICKED_INVERTED((side, placer, hitPos) -> side.getOpposite()),
    PISTON_LIKE((side, placer, hitPos) -> Direction.orderedByNearest((Entity)placer)[0]),
    PISTON_LIKE_NO_DOWN((side, placer, hitPos) -> {
        Direction f = Direction.orderedByNearest((Entity)placer)[0];
        return f == Direction.DOWN ? Direction.UP : f;
    }),
    PISTON_INVERTED((side, placer, hitPos) -> Direction.orderedByNearest((Entity)placer)[0].getOpposite()),
    PISTON_INVERTED_NO_DOWN((side, placer, hitPos) -> {
        Direction f = Direction.orderedByNearest((Entity)placer)[0];
        return f == Direction.DOWN ? Direction.UP : f.getOpposite();
    }),
    HORIZONTAL((side, placer, hitPos) -> Direction.fromYRot((double)placer.getYRot())),
    VERTICAL((side, placer, hitPos) -> side != Direction.DOWN && (side == Direction.UP || hitPos.y <= 0.5) ? Direction.UP : Direction.DOWN),
    HORIZONTAL_AXIS((side, placer, hitPos) -> {
        Direction f = Direction.fromYRot((double)placer.getYRot());
        if (f == Direction.SOUTH || f == Direction.WEST) {
            return f.getOpposite();
        }
        return f;
    }),
    HORIZONTAL_QUADRANT((side, placer, hitPos) -> {
        if (side.getAxis() != Direction.Axis.Y) {
            return side.getOpposite();
        }
        double xFromMid = hitPos.x - 0.5;
        double zFromMid = hitPos.z - 0.5;
        double max = Math.max(Math.abs(xFromMid), Math.abs(zFromMid));
        if (max == Math.abs(xFromMid)) {
            return xFromMid < 0.0 ? Direction.WEST : Direction.EAST;
        }
        return zFromMid < 0.0 ? Direction.NORTH : Direction.SOUTH;
    }),
    HORIZONTAL_PREFER_SIDE((side, placer, hitPos) -> side.getAxis() != Direction.Axis.Y ? side.getOpposite() : placer.getDirection()),
    FIXED_DOWN((side, placer, hitPos) -> Direction.DOWN);

    private final DirectionGetter dirGetter;

    private PlacementLimitation(DirectionGetter dirGetter) {
        this.dirGetter = dirGetter;
    }

    public Direction getDirectionForPlacement(Direction side, LivingEntity placer, Vec3 clickLocation) {
        return this.dirGetter.getDirectionForPlacement(side, placer, clickLocation);
    }

    public Direction getDirectionForPlacement(BlockPlaceContext context) {
        Vec3 clickLocation = context.getClickLocation();
        BlockPos pos = context.getClickedPos();
        clickLocation = clickLocation.subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        return this.getDirectionForPlacement(context.getClickedFace(), (LivingEntity)context.getPlayer(), clickLocation);
    }

    private static interface DirectionGetter {
        public Direction getDirectionForPlacement(Direction var1, LivingEntity var2, Vec3 var3);
    }
}

