/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEPotions;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=EventBusSubscriber.Bus.MOD)
public class ClientExtensions {
    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent ev) {
        ev.registerItem(ItemCallback.USE_IEOBJ_RENDER, new Item[]{IEItems.Tools.BUZZSAW.asItem(), IEItems.Tools.DRILL.asItem(), IEItems.Weapons.CHEMTHROWER.asItem(), IEItems.Weapons.RAILGUN.asItem(), IEItems.Weapons.REVOLVER.asItem(), IEItems.Misc.FLUORESCENT_TUBE.asItem(), IEItems.Misc.SHIELD.asItem()});
        for (DeferredHolder potion : IEPotions.REGISTER.getEntries()) {
            final IEPotions.IEPotion iePotion = (IEPotions.IEPotion)((Object)potion.get());
            ev.registerMobEffect(new IClientMobEffectExtensions(){

                public boolean isVisibleInGui(MobEffectInstance instance) {
                    return iePotion.showInHud;
                }

                public boolean isVisibleInInventory(MobEffectInstance instance) {
                    return iePotion.showInInventory;
                }
            }, new MobEffect[]{iePotion});
        }
        ev.registerFluidType(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return PotionFluid.PotionFluidType.TEXTURE_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return PotionFluid.PotionFluidType.TEXTURE_FLOW;
            }

            public int getTintColor(FluidStack stack) {
                PotionContents potionData = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                if (potionData == null) {
                    return -16776961;
                }
                return 0xFF000000 | potionData.getColor();
            }
        }, new FluidType[]{(FluidType)IEFluids.POTION_TYPE.value()});
        for (final IEFluids.FluidEntry fluid : IEFluids.ALL_ENTRIES) {
            ev.registerFluidType(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return fluid.stillTexture();
                }

                public ResourceLocation getFlowingTexture() {
                    return fluid.flowingTexture();
                }
            }, new FluidType[]{(FluidType)fluid.type().value()});
        }
    }
}

