/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.client.models.ModelPowerpack;
import blusunrize.immersiveengineering.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessagePowerpackAntenna(UUID player, boolean remove, BlockPos from, BlockPos to) implements IMessage
{
    public static final CustomPacketPayload.Type<MessagePowerpackAntenna> ID = IMessage.createType("powerpack_antenna");
    public static final StreamCodec<ByteBuf, MessagePowerpackAntenna> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, MessagePowerpackAntenna::player, (StreamCodec)ByteBufCodecs.BOOL, MessagePowerpackAntenna::remove, (StreamCodec)BlockPos.STREAM_CODEC, MessagePowerpackAntenna::from, (StreamCodec)BlockPos.STREAM_CODEC, MessagePowerpackAntenna::to, MessagePowerpackAntenna::new);

    public static MessagePowerpackAntenna create(Player player, @Nullable Connection connection) {
        if (connection == null) {
            return new MessagePowerpackAntenna(player.getUUID(), true, BlockPos.ZERO, BlockPos.ZERO);
        }
        return new MessagePowerpackAntenna(player.getUUID(), true, connection.getEndA().position(), connection.getEndB().position());
    }

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            Level world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null) {
                if (this.remove) {
                    ModelPowerpack.PLAYER_ATTACHED_TO.remove(this.player);
                } else {
                    GlobalWireNetwork global = GlobalWireNetwork.getNetwork(world);
                    global.getLocalNet(this.from).getConnections(this.from).stream().filter(conn -> conn.getEndA().position().equals((Object)this.from) && conn.getEndB().position().equals((Object)this.to) || conn.getEndB().position().equals((Object)this.from) && conn.getEndA().position().equals((Object)this.to)).findFirst().ifPresent(c -> ModelPowerpack.PLAYER_ATTACHED_TO.put(this.player, (Connection)c));
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

