/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.common.entities.IEMinecartEntity;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;

public class IEMinecartItem
extends IEBaseItem {
    private final IEMinecartEntity.MinecartConstructor constructor;
    private final boolean fitsIntoContainers;
    public static final DispenseItemBehavior MINECART_DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel world = source.level();
            double d0 = (double)source.pos().getX() + (double)direction.getStepX() * 1.125;
            double d1 = Math.floor(source.pos().getY()) + (double)direction.getStepY();
            double d2 = (double)source.pos().getZ() + (double)direction.getStepZ() * 1.125;
            BlockPos blockpos = source.pos().relative(direction);
            BlockState blockstate = world.getBlockState(blockpos);
            RailShape railShape = railshape = blockstate.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)world, blockpos, null) : RailShape.NORTH_SOUTH;
            if (blockstate.is(BlockTags.RAILS)) {
                d3 = railshape.isAscending() ? 0.6 : 0.1;
            } else {
                if (!blockstate.isAir() || !world.getBlockState(blockpos.below()).is(BlockTags.RAILS)) {
                    return this.behaviourDefaultDispenseItem.dispense(source, stack);
                }
                BlockState blockstate1 = world.getBlockState(blockpos.below());
                RailShape railshape1 = blockstate1.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate1.getBlock()).getRailDirection(blockstate1, (BlockGetter)world, blockpos.below(), null) : RailShape.NORTH_SOUTH;
                d3 = direction != Direction.DOWN && railshape1.isAscending() ? -0.4 : -0.9;
            }
            IEMinecartEntity<?> minecartEntity = ((IEMinecartItem)stack.getItem()).createCart((Level)world, d0, d1 + d3, d2, stack);
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                minecartEntity.setCustomName(stack.getHoverName());
            }
            minecartEntity.readTileFromItem(null, stack);
            world.addFreshEntity(minecartEntity);
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    };

    public IEMinecartItem(IEMinecartEntity.MinecartConstructor constructor, boolean fitsIntoContainers) {
        super(new Item.Properties().stacksTo(1));
        this.constructor = constructor;
        this.fitsIntoContainers = fitsIntoContainers;
    }

    public final IEMinecartEntity<?> createCart(Level world, double x, double y, double z, ItemStack stack) {
        return this.constructor.make(world, x, y, z);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level world = context.getLevel();
        BlockState blockstate = world.getBlockState(blockpos = context.getClickedPos());
        if (!blockstate.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = context.getItemInHand();
        if (!world.isClientSide) {
            RailShape railshape = blockstate.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)world, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.isAscending()) {
                d0 = 0.5;
            }
            IEMinecartEntity<?> minecartEntity = this.createCart(world, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.0625 + d0, (double)blockpos.getZ() + 0.5, itemstack);
            if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                minecartEntity.setCustomName(itemstack.getHoverName());
            }
            minecartEntity.readTileFromItem((LivingEntity)context.getPlayer(), itemstack);
            world.addFreshEntity(minecartEntity);
        }
        itemstack.shrink(1);
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag advanced) {
        super.appendHoverText(stack, ctx, tooltip, advanced);
        SimpleFluidContent content = (SimpleFluidContent)stack.get(IEDataComponents.GENERIC_FLUID);
        if (content != null) {
            FluidStack fs = content.copy();
            tooltip.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.fluidStored", (Object[])new Object[]{fs.getHoverName(), fs.getAmount()}), ChatFormatting.GRAY));
        }
    }

    public boolean canFitInsideContainerItems() {
        return this.fitsIntoContainers;
    }
}

