/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.blockstates;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallback;
import blusunrize.immersiveengineering.client.models.connection.FeedthroughLoader;
import blusunrize.immersiveengineering.client.models.obj.callback.block.BalloonCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.BreakerSwitchCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.FloodlightCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.ProbeConnectorCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.RSConnectorCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.RazorWireCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.SirenCallbacks;
import blusunrize.immersiveengineering.client.models.obj.callback.block.StructuralConnectorCallbacks;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.data.blockstates.ExtendedBlockstateProvider;
import blusunrize.immersiveengineering.data.models.SpecialModelBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ConnectorBlockStates
extends ExtendedBlockstateProvider {
    public ConnectorBlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.floodlightModel();
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.getEnergyConnector((String)"LV", (boolean)false), (ModelFile)this.obj("block/connector/connector_lv", ImmersiveEngineering.rl((String)"block/connector/connector_lv.obj"), (Map<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/connector_lv")), this.models()));
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.getEnergyConnector((String)"LV", (boolean)true), (ModelFile)this.obj("block/connector/relay_lv", ImmersiveEngineering.rl((String)"block/connector/connector_lv.obj"), (Map<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/relay_lv")), this.models()));
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.getEnergyConnector((String)"MV", (boolean)false), (ModelFile)this.obj("block/connector/connector_mv", ImmersiveEngineering.rl((String)"block/connector/connector_mv.obj"), (Map<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/connector_mv")), this.models()));
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.getEnergyConnector((String)"MV", (boolean)true), (ModelFile)this.obj("block/connector/relay_mv", ImmersiveEngineering.rl((String)"block/connector/connector_mv.obj"), (Map<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/relay_mv")), this.models()));
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.getEnergyConnector((String)"HV", (boolean)false), (ModelFile)this.obj("block/connector/connector_hv.obj"));
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.getEnergyConnector((String)"HV", (boolean)true), (ModelFile)this.obj("block/connector/relay_hv.obj", RenderType.translucent()));
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.CONNECTOR_STRUCTURAL, (ModelFile)this.ieObjBuilder("block/connector/connector_structural.obj.ie").callback((IEOBJCallback<?>)StructuralConnectorCallbacks.INSTANCE).end());
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.CONNECTOR_REDSTONE, (ModelFile)this.ieObjBuilder("block/connector/connector_redstone.obj.ie").callback((IEOBJCallback<?>)RSConnectorCallbacks.INSTANCE).end());
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.CONNECTOR_PROBE, (ModelFile)this.ieObjBuilder("block/connector/connector_probe.obj.ie").callback((IEOBJCallback<?>)ProbeConnectorCallbacks.INSTANCE).layer(RenderType.cutout(), RenderType.translucent()).end());
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.CONNECTOR_BUNDLED, (ModelFile)this.obj("block/connector/connector_bundled.obj", RenderType.cutout()));
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.REDSTONE_STATE_CELL, (ModelFile)this.obj("block/connector/redstone_state_cell.obj", RenderType.translucent()));
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.REDSTONE_TIMER, (ModelFile)this.ieObjBuilder("block/connector/redstone_timer.obj.ie").callback((IEOBJCallback<?>)RSConnectorCallbacks.INSTANCE).layer(RenderType.translucent()).end());
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.REDSTONE_SWITCHBOARD, (ModelFile)this.obj("block/connector/switchboard.obj", RenderType.cutout()));
        BlockModelBuilder model = (BlockModelBuilder)this.ieObjBuilder("block/connector/siren.obj.ie").callback((IEOBJCallback<?>)SirenCallbacks.INSTANCE).layer(RenderType.cutout()).end();
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(IEBlocks.Connectors.SIREN.get());
        ConnectorBlockStates.forEachState(stateBuilder.partialState(), List.of(), state -> {
            for (Direction d : IEProperties.FACING_ALL.getPossibleValues()) {
                state.with((Property)IEProperties.FACING_ALL, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, d.getAxis() == Direction.Axis.Y ? 0 : this.getAngle(d, 180), false)});
            }
        });
        ModelBuilder feedthroughModelFile = ((SpecialModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/connector/feedthrough")).customLoader(SpecialModelBuilder.forLoader(FeedthroughLoader.LOCATION))).end();
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.FEEDTHROUGH, (ModelFile)feedthroughModelFile);
        this.lanternModel();
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.REDSTONE_BREAKER, (ModelFile)this.ieObjBuilder("block/connector/redstone_breaker.obj.ie").callback((IEOBJCallback<?>)BreakerSwitchCallbacks.INSTANCE).end());
        this.breakerModel();
        this.transformerModel("block/connector/transformer_mv", (Supplier<? extends Block>)IEBlocks.Connectors.TRANSFORMER);
        this.transformerModel("block/connector/transformer_hv", (Supplier<? extends Block>)IEBlocks.Connectors.TRANSFORMER_HV);
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.POST_TRANSFORMER, (ModelFile)this.obj("block/connector/transformer_post.obj"), 0);
        ModelFile ctModel = this.split(this.innerObj("block/connector/e_meter.obj"), (List<Vec3i>)ImmutableList.of((Object)BlockPos.ZERO, (Object)new BlockPos(0, -1, 0)));
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.CURRENT_TRANSFORMER, ctModel, 0);
        this.createHorizontalRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDevices.RAZOR_WIRE, (ModelFile)this.ieObjBuilder("block/razor_wire.obj.ie").callback((IEOBJCallback<?>)RazorWireCallbacks.INSTANCE).layer(RenderType.cutout()).end(), 0);
        this.simpleBlock(IEBlocks.Cloth.BALLOON.get(), (ModelFile)this.ieObjBuilder("block/balloon.obj.ie").callback((IEOBJCallback<?>)BalloonCallbacks.INSTANCE).layer(RenderType.translucent()).end());
    }

    private void floodlightModel() {
        ResourceLocation modelLoc = this.modLoc("block/metal_device/floodlight.obj.ie");
        BlockModelBuilder offModel = (BlockModelBuilder)((BlockModelBuilder)this.ieObjBuilder("block/metal_device/floodlight_off", modelLoc).callback((IEOBJCallback<?>)FloodlightCallbacks.INSTANCE).layer(RenderType.solid(), RenderType.translucent()).end()).texture("texture", this.modLoc("block/metal_device/floodlight"));
        BlockModelBuilder onModel = (BlockModelBuilder)((BlockModelBuilder)this.ieObjBuilder("block/metal_device/floodlight_on", modelLoc).callback((IEOBJCallback<?>)FloodlightCallbacks.INSTANCE).layer(RenderType.solid(), RenderType.translucent()).end()).texture("texture", this.modLoc("block/metal_device/floodlight_on"));
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDevices.FLOODLIGHT, state -> state.getSetStates().get(IEProperties.ACTIVE) == Boolean.TRUE ? onModel : offModel, List.of(IEProperties.ACTIVE));
    }

    private void lanternModel() {
        BlockModelBuilder offModel = (BlockModelBuilder)this.obj("block/metal_device/e_lantern_off", ImmersiveEngineering.rl((String)"block/metal_device/e_lantern.obj"), (Map<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/metal_device/electric_lantern")), this.models());
        BlockModelBuilder onModel = (BlockModelBuilder)this.obj("block/metal_device/e_lantern_on", ImmersiveEngineering.rl((String)"block/metal_device/e_lantern.obj"), (Map<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/metal_device/electric_lantern_on")), this.models());
        this.createRotatedBlock((Supplier<? extends Block>)IEBlocks.MetalDevices.ELECTRIC_LANTERN, (VariantBlockStateBuilder.PartialBlockstate state) -> state.getSetStates().get(IEProperties.ACTIVE) == Boolean.TRUE ? onModel : offModel, (Property<Direction>)IEProperties.FACING_TOP_DOWN, List.of(IEProperties.ACTIVE), 90, 180);
    }

    private void breakerModel() {
        BlockModelBuilder onModel = (BlockModelBuilder)this.ieObjBuilder("block/connector/breaker_switch_on.obj.ie").callback((IEOBJCallback<?>)BreakerSwitchCallbacks.INSTANCE).end();
        BlockModelBuilder offModel = (BlockModelBuilder)this.ieObjBuilder("block/connector/breaker_switch_off.obj.ie").callback((IEOBJCallback<?>)BreakerSwitchCallbacks.INSTANCE).end();
        this.createAllRotatedBlock((Supplier<? extends Block>)IEBlocks.Connectors.BREAKER_SWITCH, state -> state.getSetStates().get(IEProperties.ACTIVE) == Boolean.TRUE ? onModel : offModel, List.of(IEProperties.ACTIVE));
    }

    private void transformerModel(String baseName, Supplier<? extends Block> transformer) {
        ModelFile leftModel = this.split(this.innerObj(baseName + "_left.obj"), COLUMN_THREE);
        ModelFile rightModel = this.split(this.mirror(this.innerObj(baseName + "_left.obj"), this.innerModels), COLUMN_THREE);
        this.createRotatedBlock(transformer, (VariantBlockStateBuilder.PartialBlockstate state) -> state.getSetStates().get(IEProperties.MIRRORED) == Boolean.TRUE ? rightModel : leftModel, (Property<Direction>)IEProperties.FACING_HORIZONTAL, List.of(IEProperties.MIRRORED), 0, 0);
    }

    @Nonnull
    public String getName() {
        return "Connector models/block states";
    }
}

