/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.multiblocks.BlockMatcher;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.AlloySmelterMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.ArcFurnaceMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.AssemblerMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.AutoWorkbenchMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.BlastFurnaceMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.BottlingMachineMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.BucketWheelMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.ChunkLoaderMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.CokeOvenMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.CrusherMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.DieselGeneratorMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.ExcavatorMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.FeedthroughMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.FermenterMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.ImprovedBlastfurnaceMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.LightningRodMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MetalPressMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MixerMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.RadioTowerMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.RefineryMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.SawmillMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.SheetmetalTankMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.SiloMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.SqueezerMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.UnionMultiblock;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class IEMultiblocks {
    public static final List<MultiblockHandler.IMultiblock> IE_MULTIBLOCKS = new ArrayList<MultiblockHandler.IMultiblock>();
    public static IETemplateMultiblock CRUSHER;
    public static IETemplateMultiblock SAWMILL;
    public static IETemplateMultiblock ALLOY_SMELTER;
    public static IETemplateMultiblock ARC_FURNACE;
    public static IETemplateMultiblock ASSEMBLER;
    public static IETemplateMultiblock AUTO_WORKBENCH;
    public static IETemplateMultiblock BLAST_FURNACE;
    public static IETemplateMultiblock ADVANCED_BLAST_FURNACE;
    public static IETemplateMultiblock BOTTLING_MACHINE;
    public static IETemplateMultiblock BUCKET_WHEEL;
    public static IETemplateMultiblock COKE_OVEN;
    public static IETemplateMultiblock DIESEL_GENERATOR;
    public static IETemplateMultiblock EXCAVATOR;
    public static MultiblockHandler.IMultiblock EXCAVATOR_DEMO;
    public static MultiblockHandler.IMultiblock FEEDTHROUGH;
    public static IETemplateMultiblock FERMENTER;
    public static IETemplateMultiblock LIGHTNING_ROD;
    public static IETemplateMultiblock METAL_PRESS;
    public static IETemplateMultiblock MIXER;
    public static IETemplateMultiblock REFINERY;
    public static IETemplateMultiblock SHEETMETAL_TANK;
    public static IETemplateMultiblock SILO;
    public static IETemplateMultiblock SQUEEZER;
    public static IETemplateMultiblock RADIO_TOWER;
    public static IETemplateMultiblock CHUNK_LOADER;

    public static void init() {
        BlockMatcher.addPredicate((expected, found, world, pos) -> expected == found ? BlockMatcher.Result.allow(1) : BlockMatcher.Result.deny(1));
        ImmutableList sideProperties = ImmutableList.of((Object)CrossCollisionBlock.NORTH, (Object)CrossCollisionBlock.EAST, (Object)CrossCollisionBlock.SOUTH, (Object)CrossCollisionBlock.WEST);
        BlockMatcher.addPreprocessor((arg_0, arg_1, arg_2, arg_3) -> IEMultiblocks.lambda$init$1((List)sideProperties, arg_0, arg_1, arg_2, arg_3));
        ImmutableList.Builder genericTagsBuilder = ImmutableList.builder();
        for (EnumMetals metal : EnumMetals.values()) {
            IETags.MetalTags tags = IETags.getTagsFor(metal);
            genericTagsBuilder.add(tags.storage).add(tags.sheetmetal);
        }
        genericTagsBuilder.add(IETags.scaffoldingAlu);
        genericTagsBuilder.add(IETags.scaffoldingSteel);
        genericTagsBuilder.add(IETags.treatedWoodSlab);
        genericTagsBuilder.add(IETags.treatedWood);
        genericTagsBuilder.add(IETags.fencesSteel);
        genericTagsBuilder.add(IETags.fencesAlu);
        ImmutableList genericTags = genericTagsBuilder.build();
        BlockMatcher.addPredicate((arg_0, arg_1, arg_2, arg_3) -> IEMultiblocks.lambda$init$2((List)genericTags, arg_0, arg_1, arg_2, arg_3));
        BlockMatcher.addPreprocessor((expected, found, world, pos) -> {
            if (expected.getBlock() == Blocks.HOPPER && found.getBlock() == Blocks.HOPPER) {
                return (BlockState)found.setValue((Property)HopperBlock.FACING, (Comparable)((Direction)expected.getValue((Property)HopperBlock.FACING)));
            }
            return found;
        });
        BlockMatcher.addPreprocessor((expected, found, world, pos) -> {
            if (expected.getBlock() == Blocks.CALIBRATED_SCULK_SENSOR && found.getBlock() == Blocks.CALIBRATED_SCULK_SENSOR) {
                return expected;
            }
            return found;
        });
        BlockMatcher.addPreprocessor((expected, found, world, pos) -> {
            if (expected.hasProperty((Property)BlockStateProperties.WATERLOGGED) && found.hasProperty((Property)BlockStateProperties.WATERLOGGED) && !((Boolean)expected.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && ((Boolean)found.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                return (BlockState)found.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            return found;
        });
        CRUSHER = IEMultiblocks.register(new CrusherMultiblock());
        SAWMILL = IEMultiblocks.register(new SawmillMultiblock());
        ALLOY_SMELTER = IEMultiblocks.register(new AlloySmelterMultiblock());
        ARC_FURNACE = IEMultiblocks.register(new ArcFurnaceMultiblock());
        ASSEMBLER = IEMultiblocks.register(new AssemblerMultiblock());
        AUTO_WORKBENCH = IEMultiblocks.register(new AutoWorkbenchMultiblock());
        BLAST_FURNACE = IEMultiblocks.register(new BlastFurnaceMultiblock());
        ADVANCED_BLAST_FURNACE = IEMultiblocks.register(new ImprovedBlastfurnaceMultiblock());
        BOTTLING_MACHINE = IEMultiblocks.register(new BottlingMachineMultiblock());
        BUCKET_WHEEL = IEMultiblocks.register(new BucketWheelMultiblock());
        COKE_OVEN = IEMultiblocks.register(new CokeOvenMultiblock());
        DIESEL_GENERATOR = IEMultiblocks.register(new DieselGeneratorMultiblock());
        EXCAVATOR = IEMultiblocks.register(new ExcavatorMultiblock());
        FEEDTHROUGH = IEMultiblocks.register(new FeedthroughMultiblock());
        FERMENTER = IEMultiblocks.register(new FermenterMultiblock());
        LIGHTNING_ROD = IEMultiblocks.register(new LightningRodMultiblock());
        METAL_PRESS = IEMultiblocks.register(new MetalPressMultiblock());
        MIXER = IEMultiblocks.register(new MixerMultiblock());
        REFINERY = IEMultiblocks.register(new RefineryMultiblock());
        SHEETMETAL_TANK = IEMultiblocks.register(new SheetmetalTankMultiblock());
        SILO = IEMultiblocks.register(new SiloMultiblock());
        SQUEEZER = IEMultiblocks.register(new SqueezerMultiblock());
        EXCAVATOR_DEMO = IEMultiblocks.register(new UnionMultiblock(IEApi.ieLoc("excavator_demo"), (List<UnionMultiblock.TransformedMultiblock>)ImmutableList.of((Object)new UnionMultiblock.TransformedMultiblock(EXCAVATOR, Vec3i.ZERO, Rotation.NONE), (Object)new UnionMultiblock.TransformedMultiblock(BUCKET_WHEEL, new Vec3i(1, -2, 4), Rotation.COUNTERCLOCKWISE_90))));
        RADIO_TOWER = IEMultiblocks.register(new RadioTowerMultiblock());
        CHUNK_LOADER = IEMultiblocks.register(new ChunkLoaderMultiblock());
    }

    private static <T extends MultiblockHandler.IMultiblock> T register(T multiblock) {
        IE_MULTIBLOCKS.add(multiblock);
        MultiblockHandler.registerMultiblock(multiblock);
        return multiblock;
    }

    private static /* synthetic */ BlockMatcher.Result lambda$init$2(List genericTags, BlockState expected, BlockState found, Level world, BlockPos pos) {
        if (expected.getBlock() != found.getBlock()) {
            for (TagKey t : genericTags) {
                if (!expected.is(t) || !found.is(t)) continue;
                return BlockMatcher.Result.allow(2);
            }
        }
        return BlockMatcher.Result.DEFAULT;
    }

    private static /* synthetic */ BlockState lambda$init$1(List sideProperties, BlockState expected, BlockState found, Level world, BlockPos pos) {
        if (expected.getBlock() instanceof CrossCollisionBlock && expected.getBlock() == found.getBlock()) {
            for (Property side : sideProperties) {
                if (((Boolean)expected.getValue(side)).booleanValue()) continue;
                found = (BlockState)found.setValue(side, (Comparable)Boolean.valueOf(false));
            }
        }
        return found;
    }
}

