/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.data.recipes.builder;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.data.recipes.builder.BaseHelpers;
import blusunrize.immersiveengineering.data.recipes.builder.IERecipeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public class CrusherRecipeBuilder
extends IERecipeBuilder<CrusherRecipeBuilder>
implements BaseHelpers.UnsizedItemInput<CrusherRecipeBuilder>,
BaseHelpers.ItemOutput<CrusherRecipeBuilder> {
    private Ingredient input;
    private TagOutput output;
    private final List<StackWithChance> secondaries = new ArrayList<StackWithChance>();
    private int energy;

    private CrusherRecipeBuilder() {
    }

    public static CrusherRecipeBuilder builder() {
        return new CrusherRecipeBuilder();
    }

    @Override
    public CrusherRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    @Override
    public CrusherRecipeBuilder output(TagOutput output) {
        this.output = output;
        return this;
    }

    public CrusherRecipeBuilder addSecondary(IngredientWithSize item, float chance, ICondition ... conditions) {
        this.secondaries.add(new StackWithChance(new TagOutput(item), chance, Arrays.asList(conditions)));
        return this;
    }

    public CrusherRecipeBuilder addSecondary(TagKey<Item> dust, float chance, ICondition ... conditions) {
        return this.addSecondary(new IngredientWithSize(dust), chance, conditions);
    }

    public CrusherRecipeBuilder addSecondary(Item item, float chance, ICondition ... conditions) {
        return this.addSecondary(new IngredientWithSize(Ingredient.of((ItemLike[])new ItemLike[]{item})), chance, conditions);
    }

    public CrusherRecipeBuilder setEnergy(int energy) {
        this.energy = energy;
        return this;
    }

    public void build(RecipeOutput out, ResourceLocation name) {
        CrusherRecipe recipe = new CrusherRecipe(this.output, this.input, this.energy, this.secondaries);
        out.accept(name, (Recipe)recipe, null, this.getConditions());
    }
}

