/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.Lib;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class IEDoorBlock
extends DoorBlock {
    private boolean lockedByRedstone = false;

    public IEDoorBlock(BlockSetType blockSetType, BlockBehaviour.Properties properties) {
        super(blockSetType, properties);
    }

    public IEDoorBlock setLockedByRedstone() {
        this.lockedByRedstone = true;
        return this;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        if (this.lockedByRedstone) {
            return (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.lockedByRedstone && ((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            level.playSound(player, pos, SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, SoundSource.BLOCKS, 0.25f, level.getRandom().nextFloat() * 0.1f + 0.9f);
            return ItemInteractionResult.CONSUME_PARTIAL;
        }
        return super.useItemOn(stack, blockState, level, pos, player, hand, hitResult);
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.lockedByRedstone) {
            boolean flag;
            boolean bl = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.relative(blockState.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
            if (!this.defaultBlockState().is(block) && flag != (Boolean)blockState.getValue((Property)POWERED)) {
                level.setBlock(pos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            }
        } else {
            super.neighborChanged(blockState, level, pos, block, fromPos, isMoving);
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            Stream<WrappedGoal> runningGoals = mob.goalSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning);
            if (runningGoals.anyMatch(wrappedGoal -> wrappedGoal.getGoal() instanceof BreakDoorGoal)) {
                return this.type() != Lib.BlockSetTypes.STEEL;
            }
        }
        return super.canEntityDestroy(state, level, pos, entity);
    }
}

