/*
 * BluSunrize
 * Copyright (c) 2020
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 *
 */

package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.InterModComms.IMCMessage;

import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

/**
 * @author BluSunrize - 27.05.2018
 */
public class IEIMCHandler
{
	private static final HashMap<String, Consumer<IMCMessage>> MESSAGE_HANDLERS = new HashMap<>();

	public static void init()
	{
		MESSAGE_HANDLERS.put("fluidpipe_cover", imcMessage -> {
			Predicate<Block> func = (Predicate<Block>)imcMessage.messageSupplier().get();
			FluidPipeBlockEntity.validPipeCovers.add(func);
		});

		MESSAGE_HANDLERS.put("fluidpipe_cover_climb", imcMessage -> {
			Predicate<Block> func = (Predicate<Block>)imcMessage.messageSupplier().get();
			FluidPipeBlockEntity.climbablePipeCovers.add(func);
		});
	}

	public static void handleIMCMessages(Stream<IMCMessage> messages)
	{
		messages.forEach(message -> {
			if(MESSAGE_HANDLERS.containsKey(message.method()))
			{
				Consumer<IMCMessage> handler = MESSAGE_HANDLERS.get(message.method());
				handler.accept(message);
			}
		});
	}

}
