/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.energy.WrappingEnergyStorage;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.WireDamageHandler;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.items.components.AttachedItem;
import blusunrize.immersiveengineering.common.network.MessagePowerpackAntenna;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemGetterList;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.network.PacketDistributor;

public class PowerpackItem
extends UpgradeableToolItem {
    public static final String TYPE = "POWERPACK";
    public static final int CHEST_SLOT = 36 + EquipmentSlot.CHEST.getIndex();
    private static final Supplier<Map<Item, IEServerConfig.Machines.CapacitorConfig>> capacitorConfigMap = Suppliers.memoize(() -> {
        HashMap<Item, IEServerConfig.Machines.CapacitorConfig> capacitorConfigMap = new HashMap<Item, IEServerConfig.Machines.CapacitorConfig>();
        capacitorConfigMap.put(IEBlocks.MetalDevices.CAPACITOR_LV.asItem(), IEServerConfig.MACHINES.lvCapConfig);
        capacitorConfigMap.put(IEBlocks.MetalDevices.CAPACITOR_MV.asItem(), IEServerConfig.MACHINES.mvCapConfig);
        capacitorConfigMap.put(IEBlocks.MetalDevices.CAPACITOR_HV.asItem(), IEServerConfig.MACHINES.hvCapConfig);
        capacitorConfigMap.put(IEBlocks.MetalDevices.CAPACITOR_CREATIVE.asItem(), IEServerConfig.Machines.CapacitorConfig.CREATIVE);
        return capacitorConfigMap;
    });
    private static final Map<UUID, Connection> PLAYER_ATTACHED_TO = new HashMap<UUID, Connection>();
    public static final ItemGetterList POWERPACK_GETTER = new ItemGetterList(player -> {
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        if (chest.getItem() instanceof PowerpackItem) {
            return chest;
        }
        AttachedItem attachedPack = (AttachedItem)chest.get(IEDataComponents.CONTAINED_POWERPACK);
        if (attachedPack != null) {
            return attachedPack.attached();
        }
        return ItemStack.EMPTY;
    });
    public static final int ITEM_CHARGE_RATE = 256;
    public static final int INDUCTION_CHARGE_RATE = 8;
    public static final int ANTENNA_CHARGE_RATE = 32;
    public static final int TESLA_CONSUMPTION = 1024;
    public static final int MAGNET_CONSUMPTION = 8;

    public PowerpackItem() {
        super(new Item.Properties().stacksTo(1), TYPE, 4);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy != null) {
            String stored = energy.getEnergyStored() + "/" + PowerpackItem.getMaxEnergyStored(stack);
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}).withStyle(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        EquipmentSlot slot = player.getEquipmentSlotForItem(heldItem);
        if (!player.getItemBySlot(slot).isEmpty()) {
            return InteractionResultHolder.fail((Object)heldItem);
        }
        player.setItemSlot(slot, heldItem.copy());
        if (!world.isClientSide()) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        heldItem.setCount(0);
        return InteractionResultHolder.sidedSuccess((Object)heldItem, (boolean)world.isClientSide());
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (itemSlot == CHEST_SLOT || itemSlot == -1) {
                PowerpackItem.tickWornPack(stack, world, player);
            }
        }
    }

    public static void tickWornPack(ItemStack itemStack, Level world, Player player) {
        IEnergyStorage packEnergy = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (packEnergy == null) {
            return;
        }
        UpgradeData upgrades = PowerpackItem.getUpgradesStatic(itemStack);
        int energy = packEnergy.getEnergyStored();
        if (energy > 0) {
            int pre = energy;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                energy -= PowerpackItem.insertInto(player.getItemBySlot(slot), energy);
            }
            if (upgrades.has(UpgradeEffect.INDUCTION) && player.tickCount % 4 == 0) {
                NonNullList allItems = player.getInventory().items;
                int selected = player.getInventory().selected;
                for (int i = 0; i < allItems.size() && (i == selected || (energy -= PowerpackItem.insertInto((ItemStack)allItems.get(i), energy)) > 0); ++i) {
                }
            }
            if (pre != energy) {
                packEnergy.extractEnergy(pre - energy, false);
            }
        }
        if (upgrades.has(UpgradeEffect.ANTENNA)) {
            PowerpackItem.handleAntennaTick(itemStack, world, player);
        }
        if (upgrades.has(UpgradeEffect.MAGNET) && energy >= 8) {
            PowerpackItem.handleMagnetTick(itemStack, world, player);
        }
    }

    private static int insertInto(ItemStack insertInto, int maxAmount) {
        IEnergyStorage equippedEnergy = (IEnergyStorage)insertInto.getCapability(Capabilities.EnergyStorage.ITEM);
        Item insertItem = insertInto.getItem();
        if (equippedEnergy != null && !(insertItem instanceof PowerpackItem) && !(insertItem instanceof BlockItem)) {
            return equippedEnergy.receiveEnergy(Math.min(maxAmount, 256), false);
        }
        return 0;
    }

    private static void handleAntennaTick(ItemStack itemStack, Level world, Player player) {
        AbstractMinecart minecart;
        BlockPos railPos;
        Entity entity;
        boolean grounded = player.getRootVehicle().onGround();
        if (!grounded && (entity = player.getRootVehicle()) instanceof AbstractMinecart && world.getBlockState(railPos = (minecart = (AbstractMinecart)entity).getCurrentRailPosition()).is(BlockTags.RAILS)) {
            grounded = true;
        }
        if (!grounded || world.isClientSide()) {
            return;
        }
        GlobalWireNetwork global = GlobalWireNetwork.getNetwork(world);
        if (PLAYER_ATTACHED_TO.containsKey(player.getUUID())) {
            Connection conn2 = PLAYER_ATTACHED_TO.get(player.getUUID());
            Connection.CatenaryData catenary = conn2.getCatenaryData();
            Vec3 antennaTip = player.position().add(0.0, 2.5, 0.0);
            Vec3 ap = antennaTip.subtract(Vec3.atLowerCornerOf((Vec3i)conn2.getEndA().position()).add(conn2.getEndAOffset()));
            double orthLength = ap.dot(catenary.delta()) / catenary.delta().dot(catenary.delta());
            Vec3 catPoint = conn2.getPoint(orthLength, conn2.getEndA()).add(Vec3.atLowerCornerOf((Vec3i)conn2.getEndA().position()));
            double dist = antennaTip.subtract(catPoint).lengthSqr();
            if (orthLength < 0.0 || orthLength > 1.0 || dist >= 8.0) {
                PLAYER_ATTACHED_TO.remove(player.getUUID());
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new MessagePowerpackAntenna(player.getUUID(), false, conn2.getEndA().position(), conn2.getEndB().position()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (!world.isClientSide()) {
                PowerpackItem.findBestSource(global, conn2).ifPresent(e -> {
                    int charge = Math.min(e.getAvailableEnergy(), 32);
                    charge = EnergyHelper.insertFlux(itemStack, charge, false);
                    e.extractEnergy(charge);
                });
            }
        } else {
            WireCollisionData wireData = global.getCollisionData();
            Collection<WireCollisionData.CollisionInfo> atBlock = wireData.getCollisionInfo(player.getOnPos().above(4));
            Optional<Connection> connection = atBlock.stream().filter(WireCollisionData.CollisionInfo::isInBlock).map(WireCollisionData.CollisionInfo::connection).filter(c -> c.type instanceof WireDamageHandler.IShockingWire).filter(c -> {
                Vec3 delta = c.getCatenaryData().delta();
                double angle = c.getCatenaryData().isVertical() ? 1.0 : delta.y() / Math.sqrt(delta.x() * delta.x() + delta.z() * delta.z());
                return Math.abs(angle) < 0.5;
            }).findAny();
            connection.ifPresent(conn -> {
                AbstractMinecart minecart;
                PLAYER_ATTACHED_TO.put(player.getUUID(), (Connection)conn);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new MessagePowerpackAntenna(player.getUUID(), false, conn.getEndA().position(), conn.getEndB().position()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                Entity patt0$temp = player.getVehicle();
                if (patt0$temp instanceof AbstractMinecart && (minecart = (AbstractMinecart)patt0$temp).getDeltaMovement().lengthSqr() > 4.0) {
                    PowerpackItem.findBestSource(global, conn).ifPresent(e -> {
                        if (e.getAvailableEnergy() >= 4096) {
                            e.extractEnergy(4096);
                            LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(world);
                            lightningbolt.moveTo(player.getX(), player.getY(), player.getZ());
                            world.addFreshEntity((Entity)lightningbolt);
                            Vec3 dir = minecart.getDeltaMovement().normalize();
                            Vec3 orth = dir.yRot((float)Math.toRadians(90.0));
                            Vec3 off = dir.scale(0.125);
                            Vec3 left = minecart.position().add(orth.scale(0.625));
                            Vec3 right = minecart.position().add(orth.scale(-0.625));
                            for (int i = 0; i < 80; ++i) {
                                left = left.add(off);
                                right = right.add(off);
                                ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.FLAME, left.x, left.y, left.z, 0, 0.0, 0.0, 0.0, 1.0);
                                ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.FLAME, right.x, right.y, right.z, 0, 0.0, 0.0, 0.0, 1.0);
                            }
                            Utils.unlockIEAdvancement(player, "tools/secret_bttf");
                        }
                    });
                }
            });
        }
    }

    private static Optional<EnergyTransferHandler.EnergyConnector> findBestSource(GlobalWireNetwork globalNetwork, Connection connection) {
        EnergyTransferHandler energyHandler = connection.getContainingNet(globalNetwork).getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class);
        if (energyHandler == null) {
            return Optional.empty();
        }
        return energyHandler.getSources().values().stream().filter(o -> o.getAvailableEnergy() > 0).max(Comparator.comparingInt(EnergyTransferHandler.EnergyConnector::getAvailableEnergy));
    }

    private static void handleMagnetTick(ItemStack itemStack, Level world, Player player) {
        if (world.isClientSide()) {
            return;
        }
        int radius = 6;
        List items = world.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(6.0, 6.0, 6.0), itemEntity -> {
            if (itemEntity.hasPickUpDelay()) {
                return false;
            }
            String magnetSource = itemEntity.getPersistentData().getString("immersiveengineering:magnet_source");
            if (!magnetSource.isEmpty() && !magnetSource.equals(player.getStringUUID())) {
                return false;
            }
            return !itemEntity.getPersistentData().contains("PreventRemoteMovement");
        });
        IEnergyStorage magnetEnergy = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        for (ItemEntity itemEntity2 : items) {
            if (!((double)itemEntity2.distanceTo((Entity)player) > 0.001) || magnetEnergy.extractEnergy(8, false) < 8) continue;
            if (!itemEntity2.getPersistentData().contains("immersiveengineering:magnet_source")) {
                itemEntity2.playSound((SoundEvent)IESounds.electromagnet.value(), (float)(0.125 + player.getRandom().nextDouble() * 0.25), 1.0f);
                itemEntity2.getPersistentData().putString("immersiveengineering:magnet_source", player.getStringUUID());
            }
            Vec3 dist = player.position().subtract(itemEntity2.position());
            Vec3 diffToPlayer = new Vec3(Math.min(dist.x, 1.0), Math.min(dist.y, 1.0), Math.min(dist.z, 1.0)).subtract(player.getDeltaMovement());
            itemEntity2.setDeltaMovement(diffToPlayer.scale(0.2));
        }
    }

    private static void setCapacitorStatic(ItemStack container, ItemStack capacitor) {
        if (!capacitorConfigMap.get().containsKey(capacitor.getItem())) {
            return;
        }
        IItemHandler cap = (IItemHandler)container.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)cap;
            modifiable.setStackInSlot(0, capacitor);
        }
    }

    public static ItemStack getCapacitorStatic(ItemStack container) {
        IItemHandler cap = (IItemHandler)container.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap != null) {
            ItemStack capacitor = cap.getStackInSlot(0);
            return capacitorConfigMap.get().containsKey(capacitor.getItem()) ? capacitor : ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getBannerStatic(ItemStack container) {
        IItemHandler cap = (IItemHandler)container.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap != null) {
            ItemStack banner = cap.getStackInSlot(1);
            if (banner.getItem() instanceof BannerItem) {
                return banner;
            }
            if (banner.getItem() instanceof IShaderItem) {
                return banner;
            }
        }
        return ItemStack.EMPTY;
    }

    public static int getMaxEnergyStored(ItemStack container) {
        IEServerConfig.Machines.CapacitorConfig cfg;
        ItemStack capacitor = PowerpackItem.getCapacitorStatic(container);
        if (!capacitor.isEmpty() && (cfg = capacitorConfigMap.get().get(capacitor.getItem())) != null) {
            return cfg.storage.getAsInt();
        }
        return 0;
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        PowerpackItem.registerCapabilitiesISI(registrar);
        registrar.register(Capabilities.EnergyStorage.ITEM, stack -> {
            ItemStack capacitor = PowerpackItem.getCapacitorStatic(stack);
            IEnergyStorage capacitorStorage = (IEnergyStorage)capacitor.getCapability(Capabilities.EnergyStorage.ITEM);
            if (capacitorStorage == null) {
                return null;
            }
            return new WrappingEnergyStorage(capacitorStorage, true, true, () -> PowerpackItem.setCapacitorStatic(stack, capacitor));
        });
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.WithPredicate(toolInventory, 0, 98, 22, itemStack -> capacitorConfigMap.get().containsKey(itemStack.getItem())), new IESlot.WithPredicate(toolInventory, 1, 134, 22, itemStack -> itemStack.getItem() instanceof BannerItem || itemStack.getItem() instanceof IShaderItem), new IESlot.Upgrades(container, toolInventory, 2, 79, 52, TYPE, stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 3, 117, 52, TYPE, stack, true, level, getPlayer)};
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (!(inv == null || inv.getStackInSlot(0).isEmpty() || inv.getStackInSlot(2).isEmpty() || inv.getStackInSlot(3).isEmpty())) {
            Utils.unlockIEAdvancement(player, "tools/upgrade_powerpack");
        }
    }
}

