/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.items.ShaderBagItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ShaderBagRecipe
extends CustomRecipe {
    public ShaderBagRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, @Nonnull Level world) {
        ItemStack stack = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (!stack.isEmpty()) {
                return false;
            }
            Rarity rarity = stackInSlot.getRarity();
            IEItems.ItemRegObject<ShaderBagItem> shaderBagForRarity = IEItems.Misc.SHADER_BAG.get(rarity);
            if (shaderBagForRarity != null && stackInSlot.is(shaderBagForRarity.asItem())) {
                stack = stackInSlot;
                continue;
            }
            return false;
        }
        return !stack.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            Rarity next = ShaderRegistry.getLowerRarity(stackInSlot.getRarity());
            ItemStack output = new ItemStack((ItemLike)IEItems.Misc.SHADER_BAG.get(next), next != stackInSlot.getRarity() ? 2 : 1);
            if (next == null) continue;
            output.set(DataComponents.RARITY, (Object)next);
            return output;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider access) {
        return new ItemStack((ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.COMMON), 2);
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.SHADER_BAG_SERIALIZER.get();
    }
}

